/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.execactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.authentication.actiontoken.DefaultActionToken;

public class ExecuteActionsActionToken
extends DefaultActionToken {
    public static final String TOKEN_TYPE = "execute-actions";
    private static final String JSON_FIELD_REQUIRED_ACTIONS = "rqac";
    private static final String JSON_FIELD_REDIRECT_URI = "reduri";

    public ExecuteActionsActionToken(String userId, int absoluteExpirationInSecs, List<String> requiredActions, String redirectUri, String clientId) {
        super(userId, TOKEN_TYPE, absoluteExpirationInSecs, null);
        this.setRequiredActions(requiredActions == null ? new LinkedList<String>() : new LinkedList<String>(requiredActions));
        this.setRedirectUri(redirectUri);
        this.issuedFor = clientId;
    }

    private ExecuteActionsActionToken() {
    }

    @JsonProperty(value="rqac")
    public List<String> getRequiredActions() {
        return (List)this.getOtherClaims().get(JSON_FIELD_REQUIRED_ACTIONS);
    }

    @JsonProperty(value="rqac")
    public final void setRequiredActions(List<String> requiredActions) {
        if (requiredActions == null) {
            this.getOtherClaims().remove(JSON_FIELD_REQUIRED_ACTIONS);
        } else {
            this.setOtherClaims(JSON_FIELD_REQUIRED_ACTIONS, requiredActions);
        }
    }

    @JsonProperty(value="reduri")
    public String getRedirectUri() {
        return (String)this.getOtherClaims().get(JSON_FIELD_REDIRECT_URI);
    }

    @JsonProperty(value="reduri")
    public final void setRedirectUri(String redirectUri) {
        if (redirectUri == null) {
            this.getOtherClaims().remove(JSON_FIELD_REDIRECT_URI);
        } else {
            this.setOtherClaims(JSON_FIELD_REDIRECT_URI, redirectUri);
        }
    }
}

