#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.5
visibility:           public
id:                   hOpenPGP-2.9.5-929GZN1wcbv7otZiIfZP1P
key:                  hOpenPGP-2.9.5-929GZN1wcbv7otZiIfZP1P
license:              MIT
copyright:            2012-2020  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  c4c535b971b38425c8be3d2f310e0b2a
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher

import-dirs:          /usr/lib/ghc-8.10.2/site-local/hOpenPGP-2.9.5
library-dirs:         /usr/lib/ghc-8.10.2/site-local/hOpenPGP-2.9.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/hOpenPGP-2.9.5
hs-libraries:         HShOpenPGP-2.9.5-929GZN1wcbv7otZiIfZP1P
depends:
    aeson-1.5.4.1-1IeGMr9U117LwJYrLRVKTY
    asn1-encoding-0.9.6-2TXpQeH3zpRmmJ2JDDFTh
    attoparsec-0.13.2.4-AOCP0w3yjps1ekkc06TeAr base-4.14.1.0
    base16-bytestring-0.1.1.7-7MnoTKrQfBC3WeMx0LqUK0
    bifunctors-5.5.8-A6tYbzQrPtsH4vjNxzZac4 binary-0.8.8.0
    binary-conduit-1.3.1-7xOcazZFzCKiFYaQnz5oB bytestring-0.10.10.0
    bz2-1.0.1.0-COXEUyoOH9HI1MItX5vF0g
    conduit-1.3.4-4jvOBOzxV1hIVvrhitNicH
    conduit-extra-1.3.5-HfFATvBEagDKm7nPa1b9L3 containers-0.6.2.1
    crypto-cipher-types-0.0.9-4lLcbiqzzgFJfDDaicapOR
    cryptonite-0.27-HpkQ9Stao3P6Ep1pdHbpFR
    errors-2.3.0-2LgaK8Zc9K66pZHBMy7LAa
    hashable-1.3.0.0-FvkEiMgheS54ROKCBeHULc
    incremental-parser-0.5-KchZ0udVk9i9T0VMdORf3Y
    ixset-typed-0.5-HURAtewZ6AmLnAhguVqaGE
    lens-4.19.2-HdgDJZEqQbsGlphfAuieXM
    memory-0.15.0-359cYXe7lRF64CAN0G53fp
    monad-loops-0.4.3-C0LVokhtCoUF1FVS5cJB0Q
    nettle-0.3.0-9hTjugt98GwIOGeydKnTvB
    network-uri-2.6.3.0-CE9vL8IhbUnKuOSwc8HcNM
    openpgp-asciiarmor-0.1.2-LRvUZz0SGrlFu5Q3iqaY92
    prettyprinter-1.7.0-DGqrb02FRD0KnjJHMpibvj
    resourcet-1.2.4.2-IBltYvRLbCe9QRRPgabVbi
    split-0.2.3.4-15npQ2h4TqNDaGU8Z2EdgB text-1.2.3.2 time-1.9.3
    time-locale-compat-0.1.1.5-75n5v6JklqyMdEmBwWBxO
    transformers-0.5.6.2 unliftio-core-0.2.0.1-9GVcmaajsglG88oErAZOTV
    unordered-containers-0.2.13.0-7BSbisgDeQuHhhzTcs4ukq
    zlib-0.6.2.2-85jZF5E8OnCKweDgfCRJUx

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

