#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.39.0
visibility:           public
id:                   dhall-1.39.0-7VzSqvXon9HAtuy5pJaNgD
key:                  dhall-1.39.0-7VzSqvXon9HAtuy5pJaNgD
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  72d939935b97951c0305263ff8b62fe1
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Marshal.Internal
    Dhall.Normalize Dhall.Parser.Combinators Dhall.Pretty.Internal
    Dhall.Syntax Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-8.10.5/site-local/dhall-1.39.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/dhall-1.39.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.39.0-7VzSqvXon9HAtuy5pJaNgD
depends:
    Diff-0.4.0-13VXofqCMLyHuBACVASIzF
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs
    aeson-pretty-0.8.8-7Y85LeXJfbRBFaLbPECV89
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i
    atomic-write-0.2.0.7-EpGthskVMzK1fsEcdLdU4 base-4.14.2.0
    bytestring-0.10.12.0
    case-insensitive-1.2.1.0-6tEs2ust6UoJNkdDoolIXx
    cborg-0.2.5.0-9EvLXFRKXWFK41IT7yryAK
    cborg-json-0.2.2.0-FGtoFn9OfrK1iwWZmiFYFp containers-0.6.4.1
    contravariant-1.5.3-KWoYE9wiUjmElzHNq2wj10
    cryptonite-0.29-DOJpzHmGf631cPBYwOScHA
    data-fix-0.3.1-D9MFel1sX0UA9T9qsnfRBB deepseq-1.4.4.0
    directory-1.3.6.0 dotgen-0.4.3-CYDj58Mb9IBFJpxulglUb5
    either-5.0.1.1-CmaFcYiEYCOC8zIFNTIPYH exceptions-0.10.4
    filepath-1.4.2.1 half-0.3.1-CkbRDGX7YGBF0y5EvDisTr
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo haskeline-0.8.0.1
    http-client-0.7.8-9CCfo3vVp8P3jNF4QXUQLt
    http-client-tls-0.3.5.3-BwcyGhNOyAz2bcL5AaZcNX
    http-types-0.12.3-Di0Av9jbzuQGAtr7LDgLEc
    lens-family-core-2.1.0-5dWeSS3yNbY9tgCjzxRena
    megaparsec-9.0.1-IyAio6GA8vt39fw1sjLrjI
    memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
    mmorph-1.1.5-HQ5yL7dTs6W12JIMoRbUvr mtl-2.2.2
    network-uri-2.6.4.1-FvgDgWAahTMJnOZjiFXR50
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e
    parser-combinators-1.3.0-I56cvBuZMEG2VbjtPZAqZY
    parsers-0.12.10-DGz13yHc7wxB3ssNjoRPte
    pretty-simple-4.0.0.0-4rmXCdoD1mXINKFmCosdsr
    prettyprinter-1.7.0-CsdPyvSK7SYH1Sdty7tDdn
    prettyprinter-ansi-terminal-1.1.2-8t5lfdDDTyYCi98eRKlTl
    profunctors-5.6.2-HmnVxCk8JDbE3jxtqz7wd8
    repline-0.4.0.0-KFIMb37KT4JF8sbXX0sefZ
    scientific-0.3.7.0-Ea1GK6jx8XDEEsfAKxwFym
    serialise-0.2.3.0-CEecDehvhq3Dhts5nt0CQ4 template-haskell-2.16.0.0
    text-1.2.4.1 text-manipulate-0.3.0.0-IA1vwAbagmRJhy7paqdrR0
    th-lift-instances-0.1.18-ISzSdEYjwO2HcQG406Y9jF
    transformers-0.5.6.2
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    uri-encode-1.5.0.7-9ZjETguLDyRFTlurXeamP5
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

