/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count;

import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo.CountElementVo;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo.CountVo;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class JavadocCounter {
    public CountVo count(ICompilationUnit comp, String typeName) throws JavaModelException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        parser.setSource(comp);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        CountVo cuCount = new CountVo(comp);
        cuCount.setTotalJavadocLines(this.getCompilationUnitDocLines(cu));
        List types = cu.types();
        if (types.size() < 1) {
            return cuCount;
        }
        Iterator typeIt = types.iterator();
        while (typeIt.hasNext()) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)typeIt.next();
            if (!typeName.equals(declaration.getName().getIdentifier())) continue;
            cuCount.setJavadocLines(this.getLineLength(cu, (ASTNode)declaration.getJavadoc()));
            if (!(declaration instanceof TypeDeclaration)) break;
            TypeDeclaration type = (TypeDeclaration)declaration;
            this.countFields(cu, cuCount, type);
            this.countMethods(cu, cuCount, type);
            break;
        }
        return cuCount;
    }

    public CountVo count(ICompilationUnit comp) throws JavaModelException {
        String elemenetName = comp.getElementName();
        String fileName = elemenetName.substring(0, elemenetName.length() - 5);
        return this.count(comp, fileName);
    }

    private void countMethods(CompilationUnit cu, CountVo cuCount, TypeDeclaration type) {
        MethodDeclaration[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            int line = this.getLineLength(cu, (ASTNode)methods[i].getJavadoc());
            CountElementVo methodCount = new CountElementVo(null, methods[i].getName().getIdentifier(), line);
            cuCount.addMethod(methodCount);
            ++i;
        }
    }

    private void countFields(CompilationUnit cu, CountVo cuCount, TypeDeclaration type) {
        FieldDeclaration[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            List list = fields[i].fragments();
            StringBuffer sb = new StringBuffer();
            int fieldNum = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                VariableDeclarationFragment vbf = (VariableDeclarationFragment)iter.next();
                sb.append(vbf.getName() + ",");
                ++fieldNum;
            }
            sb.setLength(sb.length() - 1);
            int line = this.getLineLength(cu, (ASTNode)fields[i].getJavadoc());
            CountElementVo fieldCount = new CountElementVo(sb.toString(), line, fieldNum);
            cuCount.addField(fieldCount);
            ++i;
        }
    }

    private int getCompilationUnitDocLines(CompilationUnit cu) {
        int lines = 0;
        List comments = cu.getCommentList();
        Iterator iter = comments.iterator();
        while (iter.hasNext()) {
            Comment com = (Comment)iter.next();
            if (!com.isDocComment()) continue;
            lines += this.getLineLength(cu, (ASTNode)com);
        }
        return lines;
    }

    private int getLineLength(CompilationUnit cu, ASTNode node) {
        if (node == null) {
            return 0;
        }
        int start = cu.getLineNumber(node.getStartPosition());
        int end = cu.getLineNumber(node.getStartPosition() + node.getLength());
        return end - start + 1;
    }
}

