/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.Activator;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count.JavadocCounter;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.JavadocCountView;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo.CountVo;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class CounterJob
extends WorkspaceJob {
    private Collection target;

    public CounterJob(Collection countTarget) {
        super("Javadoc Counter");
        this.target = countTarget;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Javadoc Counter", this.target.size() + 1);
        final ArrayList<CountVo> countResult = new ArrayList<CountVo>();
        JavadocCounter counter = new JavadocCounter();
        Iterator iter = this.target.iterator();
        while (iter.hasNext()) {
            ICompilationUnit cu = (ICompilationUnit)iter.next();
            CountVo vo = counter.count(cu);
            countResult.add(vo);
            monitor.worked(1);
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = Activator.getActiveWorkbenchWindow().getActivePage();
                try {
                    JavadocCountView view = (JavadocCountView)page.showView("jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.JavadocView");
                    view.updateView(countResult);
                }
                catch (PartInitException e) {
                    Activator.logError(e);
                }
            }
        });
        monitor.done();
        return Status.OK_STATUS;
    }
}

