/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.Activator;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.Messages;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count.CounterJob;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CountAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        try {
            Collection compUnits = this.collectCompilationUnit((IStructuredSelection)this.selection);
            if (compUnits.size() != 0) {
                new CounterJob(compUnits).schedule();
            } else {
                MessageDialog.openInformation((Shell)Activator.getShell(), null, (String)Messages.Message_NoCountFile);
            }
        }
        catch (JavaModelException e) {
            Activator.logError(e);
        }
    }

    private Collection collectCompilationUnit(IStructuredSelection selection) throws JavaModelException {
        ArrayList compilationUnits = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            this.collect(element, compilationUnits);
        }
        return compilationUnits;
    }

    private void collect(IJavaElement javaElement, Collection elements) throws JavaModelException {
        IPackageFragment packageFragment;
        IPackageFragmentRoot root;
        if (javaElement.getElementType() == 5) {
            elements.add(javaElement);
            return;
        }
        IJavaProject parent = null;
        if (javaElement.getElementType() == 2) {
            parent = (IJavaProject)javaElement;
        } else if (javaElement.getElementType() == 3) {
            IPackageFragmentRoot root2 = (IPackageFragmentRoot)javaElement;
            if (this.isSourceKind(root2)) {
                parent = root2;
            }
        } else if (javaElement.getElementType() == 4 && this.isSourceKind(root = (IPackageFragmentRoot)(packageFragment = (IPackageFragment)javaElement).getParent())) {
            parent = packageFragment;
        }
        if (parent != null && parent.hasChildren()) {
            IJavaElement[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collect(children[i], elements);
                ++i;
            }
        }
    }

    private boolean isSourceKind(IPackageFragmentRoot root) throws JavaModelException {
        return root.getKind() == 1;
    }
}

