/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;

public class InputCache {
    public static final String KEY_INPUT = ".input";
    public static final String KEY_OUTPUT = ".output";
    public static final String KEY_PROPERTY = ".property";
    private String baseKey;
    private IPreferenceStore store;

    public InputCache(IFile file) {
        this.baseKey = this.createBaseKey(file);
        this.store = Activator.getDefault().getPreferenceStore();
    }

    public boolean hasLastConfig() {
        return this.store.contains(this.baseKey);
    }

    public String getStoreValue(String key) {
        String name = String.valueOf(this.baseKey) + key;
        return this.store.getString(name);
    }

    public void storeLastValue(String key, String value) {
        String name = String.valueOf(this.baseKey) + key;
        this.store.setValue(name, value);
        this.store.setValue(this.baseKey, true);
    }

    private String createBaseKey(IFile file) {
        return file.getFullPath().toPortableString();
    }
}

