package lll.l4P5;

import processing.core.*;
import lll.Loc.*;

/* class l4p5, static utilities drawing the Loc objects to P5's sketch
 *           coded by Classiclll on 08/07/20
[initial setting, always needed]
 *  setup(PApplet parent)
[Processing's primitives]
	translate(Loc l)
	translate(Rod r)
	translate(Tag t)
	translate(Ship t)
	line2D(Loc s, Loc t)
	line2D(Rod r)
 	line(Loc s, Loc t)
	line(Rod r)
	vertex(Loc l)
	vertex(Loc l, float u, float v) 
	vertex2D(Loc l)
 	vertex2D(Loc l, float u, float v) 
	bezierVertex(Loc l, Loc m, float x, float y, float z)
	bezierVertex2D(Loc l, Loc m, float x, float y)
	ellipse(Loc l, float width, float height)
	ellipse(Rod r)
	ellipse(Tag t)
	rect(Loc l, float width, float height)
	rect(Rod r)
*	rect(Tag t)
	point(Loc l)
	point2D(Loc l)
	box(Loc l, float width, float height, float depth)
	box(Rod r)
	box(Ship s)
	sphere(Loc l, float radius)
	sphere(Rod r)
[Extended stufs]
	polygon(Loc[] at)
	polygon(Loc[] at, PImage img)
[Texture Mapped 3D Primitives.    coded by Classiclll on 5/1/2006]
	"dim" is the degree of detail of each shapes (positive odd number)
	[Capsules]
	void tmdSphere(float radius, PImage img)
	void tmdOctahedron(float radius, PImage img)
	void tmdBarrel(float radius, PImage img)
	void tmdCapsule(int dim, float radius, PImage img)
	[Tubes]
	void tmdBox(float len, PImage img)
	void tmdHexapole(float radius, float len, PImage img)
	void tmdTube(int dim, float radius, float len, PImage img)
	[Cones]
	void tmdTetra(float len, PImage img)
	void tmdCone(float radius, float len, PImage img)
	void tmdCone(int dim, float radius, float len, PImage img)
	[Torus]
		// To Do
*/
public class l4p5{
	static PApplet p5;
	static public void setup(PApplet parent) { p5=parent;}
//	 translate()
	static public void translate(Loc l) {
		p5.translate(l.x,l.y,l.z);
	}
	static public void translate(Rod r) {
		translate(r.stern());
	}
	static public void translate(Tag t) {
		translate(t.stern());
	}
	static public void translate(Ship s) {
		translate(s.stern());
	}
//	 line()
	static public void line(Loc f, Loc t) {
		p5.line(f.x,f.y,f.z,t.x,t.y,t.z);
	}
	static public void line2D(Loc f, Loc t) {
		p5.line(f.x,f.y,t.x,t.y);
	}
	static public void line(Rod r) {
		line(r.stern(),r.bow());
	}
	static public void line2D(Rod r) {
		line2D(r.stern(),r.bow());
	}
// vertex
	static public void vertex(Loc l) {
		p5.vertex(l.x,l.y,l.z);
	}
	static public void vertex(Loc l, float u, float v) {
		p5.vertex(l.x,l.y,l.z,u,v);
	}
	static public void vertex2D(Loc l) {
		p5.vertex(l.x,l.y);
	}
	static public void vertex2D(Loc l, float u, float v) {
		p5.vertex(l.x,l.y,u,v);
	}
	static public void bezierVertex(Loc l, Loc m, float x, float y, float z) {
		p5.bezierVertex(l.x,l.y,l.z,m.x,m.y,m.z,x,y,z);
	}
	static public void bezierVertex2D(Loc l, Loc m, float x, float y) {
		p5.bezierVertex(l.x, l.y, m.x, m.y, x, y);
	}
// ellipse		Rod, Loc
	static public void ellipse (Loc l, float width, float height) {
		p5.ellipse(l.x, l.y, width, height);
	}
	static public void ellipse(Rod r) {
		Loc b = r.fore().scale(r.length());
		ellipse(r.stern(), b.x, b.y);
	}
	static public void ellipse(Tag t) {
		p5.pushMatrix();
		translate(t.stern());
		p5.rotateX(t.fore().x);p5.rotateY(t.fore().y);p5.rotateZ(t.fore().z);
		ellipse(t.stern(), t.width(), t.length());
		p5.popMatrix();
	}
// rect			Rod,Loc
	static public void rect(Loc l, float width, float height) {
		p5.rect(l.x, l.y, width, height);
	}
	static public void rect(Rod r) {
		Loc b = r.fore().scale(r.length());
		rect(r.stern(), b.x, b.y);
	}
	static public void rect(Tag t) {
		p5.pushMatrix();
		translate(t.stern());
		p5.rotateX(t.fore().x);p5.rotateY(t.fore().y);p5.rotateZ(t.fore().z);
		rect(t.stern(), t.width(), t.length());
		p5.popMatrix();
	}
// point			Loc
	static public void point(Loc l) {
		p5.point(l.x,l.y,l.z);
	}
	static public void point2D(Loc l) {
		p5.point(l.x, l.y);
	}
// box			Rod,Loc
	static public void box(Loc l, float width, float height, float depth) {
		p5.pushMatrix();
		p5.translate(l.x, l.y, l.z);
		p5.box(width,height,depth);
		p5.popMatrix();
	}
	static public void box(Rod r) {
		Loc b = r.bow();
		box(r.stern(), b.x, b.y, b.z);
	}
	static public void box(Ship s) {
		box(s.stern(), s.length(), s.width(), s.height());
	}
// sphere		Rod, Loc
	static public void sphere(Loc l, float radius) {
		p5.pushMatrix();
		p5.translate(l.x, l.y, l.z);
		p5.sphere(radius);
		p5.popMatrix();
	}
	static public void sphere(Rod r) {
		sphere(r.stern(),r.length());
	}
// polygon Loc[]
	static public void polygon(Loc[] at) {
		p5.beginShape();
		for (int i=0; i<at.length; i++) {
			vertex(at[i]);
		}
		p5.endShape(PApplet.CLOSE);
	}
	static public void polygon(Loc[] at, PImage img) {
		p5.beginShape();
		p5.textureMode(PApplet.NORMALIZED);
		p5.texture(img);
		Loc lt=new Loc(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, 0);
		Loc rb= new Loc(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, 0);
		for (int i=0; i<at.length; i++) {
			lt.move(Math.min(lt.x,at[i].x), Math.min(lt.y,at[i].y), 0);
			rb.move(Math.max(rb.x,at[i].x), Math.max(rb.y,at[i].y), 0);
		}
		for (int i=0; i<at.length; i++) {
			float u = (at[i].x-rb.x)/(lt.x-rb.x);
			float v = (at[i].y-rb.y)/(lt.y-rb.y);
			vertex(at[i], u, v);
		}
		p5.endShape(PApplet.CLOSE);
	}

// Texture Mapped 3D Primitives

	static public void tmdSphere(float rad, PImage img) {
	  tmdCapsule(32, rad, img);
	}
	static public void tmdOctahedron(float rad, PImage img) {
	  tmdCapsule(4, rad, img);
	}
	static public void tmdBarrel(float rad, PImage img) {
	  tmdCapsule(6, rad, img);
	}
	static public void tmdCapsule(int dim, float rad, PImage img) {
	  Loc l = new Loc();
	  p5.textureMode(PApplet.NORMALIZED);
	  p5.noStroke();
	  p5.beginShape(PApplet.QUAD_STRIP);
	  p5.texture(img);
	  float dlt=PApplet.TWO_PI/dim;
	  for (int it=0; it<dim; it++) {
	    float lt=it*dlt;
	    for(int ig=0; ig<=dim/2; ig++) {
	      float lg=ig*dlt-PApplet.HALF_PI;
	      l.movePolar(rad, lg,     lt   );
	      vertex(l,lt/PApplet.TWO_PI,(lg+PApplet.HALF_PI)/PApplet.PI);
	      l.movePolar(rad, lg,     lt+dlt);
	      vertex(l,(lt+dlt)/PApplet.TWO_PI,(lg+PApplet.HALF_PI)/PApplet.PI);
	    }
	  }
	  p5.endShape();
	  p5.stroke(0);
	}

	static public void tmdBox(float len, PImage img) {
	  tmdTube(4,(float) (len/Math.sqrt(2)*8/7),len*8/7,img);
	}
	static public void tmdHexapole(float rad, float len, PImage img) {
	  tmdTube(6,rad,len,img);
	}
	static public void tmdTube(int dim, float rad, float len, PImage img) {
	  Loc l = new Loc();
	  p5.textureMode(PApplet.NORMALIZED);
	  p5.noStroke();
	  p5.beginShape(PApplet.QUAD_STRIP);
	  p5.texture(img);
	  float dlt=PApplet.TWO_PI/dim;
	  float h = len/2;
	  float h1 = rad/(len+6*rad);
	  float h2 = 1-h1;
	  for (int it=0; it<=dim; it++) {
	    float lt=it*dlt;
	    l.move(0, 0, h);
	    vertex(l,lt/PApplet.TWO_PI,0);
	    l.movePolar(rad, 0, lt).shift(0, 0, h);
	    vertex(l,lt/PApplet.TWO_PI,h1);
	  }
	  for (int it=0; it<=dim; it++) {
	    float lt=it*dlt;
	    l.movePolar(rad, 0, lt).shift(0, 0, h);
	    vertex(l,lt/PApplet.TWO_PI,h1);
	    l.movePolar(rad, 0, lt).shift(0, 0, -h);
	    vertex(l,lt/PApplet.TWO_PI,h2);
	  }
	  for (int it=0; it<=dim; it++) {
	    float lt=it*dlt;
	    l.movePolar(rad, 0, lt).shift(0, 0, -h);
	    vertex(l,lt/PApplet.TWO_PI,h2);
	    l.move( 0, 0, -h);
	    vertex(l,lt/PApplet.TWO_PI,1f);
	  }
	  p5.endShape();
	  p5.stroke(0);
	}

	static public void tmdTetra(float len, PImage img) {
	  tmdCone(3,len,(float) (len*Math.sqrt(2)),img);
	}
	static public void tmdCone(float rad, float len, PImage img) {
	  tmdCone(24,rad,len,img);
	}
	static public void tmdCone(int dim, float rad, float len, PImage img) {
	  Loc l = new Loc();
	  p5.textureMode(PApplet.NORMALIZED);
	  p5.noStroke();
	  p5.beginShape(PApplet.QUAD_STRIP);
	  p5.texture(img);
	  float dlt=PApplet.TWO_PI/dim;
	  float h = len/2;
	  float h1 = len/(len+rad/3);
	  for (int it=0; it<=dim; it++) {
	    float lt=it*dlt;
	    l.move(0, 0, h);
	    vertex(l,lt/PApplet.TWO_PI,0);
	    l.movePolar(rad, 0, lt).shift(0, 0, -h);
	    vertex(l,lt/PApplet.TWO_PI,h1);
	  }
	  for (int it=0; it<=dim; it++) {
	    float lt=it*dlt;
	    l.movePolar(rad, 0, lt).shift(0, 0, -h);
	    vertex(l,lt/PApplet.TWO_PI,h1);
	    l.move( 0, 0, -h);
	    vertex(l,lt/PApplet.TWO_PI,1f);
	  }
	  p5.endShape();
	  p5.stroke(0);
	}
}