<?php
/*
Plugin Name: wp-hatena 拡張版 ( wp-hatena Extended version )
Plugin URI: http://wppluginsj.sourceforge.jp/wp-hatena/
Description: エントリにはてなブックマーク等に追加するリンクタグとはてなブックマーク被リンク数表示を挿入します。
Author: hiromasa
Extended version Author: inocco (hibiki)
Versionin: 0.5 ( Base wp-hatena Version: 0.93j )
Author URI: http://hiromasa.zone.ne.jp/blog/
Extended version Author URI: http://wp.graphact.com/
Special Thanks: Castaway. (http://bless.babyblue.jp/wp/)
Bug Report: Masayan (http://wp.mmrt-jp.net/)
Bug Report: kohaku (http://aoiro-blog.com/)
*/

/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * 使い方 :
 *  プラグインを有効にした後 WP テーマ内の **エントリ表示位置** に、
 *   はてなの場合      : <?php if(isset($wph)) $wph->addHatena(); ?>
 *   del.icio.usの場合 : <?php if(isset($wph)) $wph->adddelicious(); ?>
 *  を挿入してください。
 *****************************************************************************/

/******************************************************************************
 * WpHatena function define.
 *****************************************************************************/
if(class_exists('WpHatena')) {
	
	$wph = & new WpHatena();
	
	// JavaScript 画像説明ポップアップ用
	// add_action('wp_head', array(&$wph, 'addScript'));
	
}

/******************************************************************************
 * WpHatena - Extended version
 * 
 * @author		hiromasa	// @extended version author		hibiki
 * @version	0.93j			// @extended version 0.5
 *
 *****************************************************************************/
class WpHatena {
	
	var $plugin_path;
	var $popup_jsname;
	var $blog_charset;
	var $path_css;
	
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return Object reference
	 */
	function WpHatena() {
		
		$this->plugin_path  = get_settings('siteurl');
		$this->plugin_path .= '/wp-content/plugins/wp-hatena/';
		$this->popup_jsname = 'popup.js';
		$this->blog_charset = get_settings('blog_charset');
		$this->path_css = "wp-hatena.css";
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (はてなブックマーク用のタグを echo)
	 */
	function addHatena() {
		
		echo
			$this->makeBookmarkURL(
				'はてなブックマーク',
				'http://b.hatena.ne.jp/append?' . get_permalink(),
				'hatena.gif',
				16, 12,
				''
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (新はてなブックマーク用のタグを echo)
	 */
	function addNewHatena() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeNewHatenaURL(
				urlencode($title),
				'http://b.hatena.ne.jp/entry/' . get_permalink()
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (del.icio.us 用のタグを echo)
	 */
	function adddelicious() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'del.icio.us',
				'http://del.icio.us/post?url=' . get_permalink(),
				'delicious.12px.gif',
				12, 12,
				'&amp;title=' . urlencode($title)
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (Livedoor Clip用のタグを echo)
	 */
	function addLivedoor() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'Livedoor Clip',
				'http://clip.livedoor.com/clip/add?link=' . get_permalink(),
				'livedoor.gif',
				16, 16,
				'&amp;title=' . urlencode($title) . '&amp;jump=ref'
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (Yahoo! ブックマーク用のタグを echo)
	 */
	function addYahoo() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'Yahoo!ブックマーク',
				'http://bookmarks.yahoo.co.jp/bookmarklet/showpopup?t=' . urlencode($title),
				'yahoo.gif',
				16, 16,
				'&amp;u=' . get_permalink() . '&amp;opener=bm&amp;ei=UTF-8'
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (FC2ブックマーク用のタグを echo)
	 */
	function addFC2() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'FC2ブックマーク',
				'http://bookmark.fc2.com/user/post?url=' . get_permalink(),
				'fc2.gif',
				16, 16,
				'&amp;title=' . urlencode($title)
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (Nifty用のタグを echo)
	 */
	function addNifty() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'Nifty Clip',
				'http://clip.nifty.com/create?url=' . get_permalink(),
				'nifty.gif',
				14, 14,
				'&amp;title=' . urlencode($title)
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (POOKMARK用のタグを echo)
	 */
	function addPOOKMARK() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'POOKMARK. Airlines',
				'http://pookmark.jp/post?url=' . get_permalink(),
				'pookmark.gif',
				18, 12,
				'&amp;title=' . urlencode($title)
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (buzzurl用のタグを echo)
	 */
	function addBuzzurl() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'Buzzurl（バザール）',
				'http://news.ecnavi.jp/config/add/confirm?url=' . get_permalink(),
				'buzzurl.gif',
				21, 15,
				'&amp;title=' . urlencode($title)
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (Choix用のタグを echo)
	 */
	function addChoix() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'Choix',
				'http://www.choix.jp/bloglink/' . get_permalink(),
				'choix.gif',
				16, 16,
				''
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (newsing用のタグを echo)
	 */
	function addnewsing() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeBookmarkURL(
				'newsing',
				'http://newsing.jp/nbutton?title=' . urlencode($title),
				'newsing.gif',
				16, 16,
				'&amp;url=' . get_permalink()
			);
		
	}

	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (mixiチェック用のタグを echo)
	 */
	function addMixicheck() {
		echo
			$this->makeMixiCheckURL(
				//▼mixi キー
				''
			);
	}

	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (twitterツイートボタン用のタグを echo)
	 */
	function addTweetBtn() {
		echo
			$this->makeTwitterBtnURL();
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (Evernote Clip 用のタグを echo)
	 */
	function addEvernoteClip() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeEvernoteClipURL(
				$title,
				get_permalink(),
				//▼Evernoteアフィ（空欄可）
				'',
				//▼Clip する部分の id
				'content'
			);
		
	}
	
	/**
	 * WP interface.
	 * 
	 * @param none
	 * @return none (Facebook 用のタグを echo)
	 */
	function addFacebook() {
		
		$title = $this->utf8_encode(get_the_title());
		
		echo
			$this->makeFacebookURL(
				'http://www.facebook.com/plugins/like.php?href=' . get_permalink()
			);
		
	}
	
	/**
	 * Bookmark URL maker.
	 * 
	 * @param $sitename (サイト名称文字列)
	 * @param $url (URL)
	 * @param $iconfile (画像ファイル URL)
	 * @param $width (画像 width)
	 * @param $height (画像 height)
	 * @param $ext_url (その他の追加 URL)
	 * @return $tag (画像リンクタグ)
	 */
	function makeBookmarkURL($sitename, $url, $iconfile, $width, $height, $ext_url) {
		
		$tag  = '<a';
		$tag .= ' href="' . $url . $ext_url . '"';
		$tag .= ' target="_blank"';
		$tag .= ' class="wph" ';
		$tag .= '>';
		$tag .= '<img';
		$tag .= ' src="' . $this->plugin_path . $iconfile . '"';
		$tag .= ' alt="このエントリを' . $sitename . 'に追加"';
		$tag .= ' title="このエントリを' . $sitename . 'に追加"';
		$tag .= ' width="' . $width . '" height="' . $height . '"';
		//$tag .= ' onmouseover="wpHatenaPopup()"';
		$tag .= '/>';
		$tag .= '</a>';
		
		return $tag;
		
	}

	/**
	 * for mixi check.
	 * 
	 * @param $key (mixiキー)
	 * @return $tag (画像リンクタグ)
	 */
	function makeMixiCheckURL($key) {
		
		$tag  = '<a';
		$tag .= ' href="http://mixi.jp/share.pl"';
		$tag .= ' class="mixi-check-button wph"';
		$tag .= ' data-key="' . $key . '"';
		$tag .= '>';
		$tag .= 'mixiチェック';
		$tag .= '</a>';
		$tag .= '<script type="text/javascript" src="http://static.mixi.jp/js/share.js"></script>';
		
		return $tag;
		
	}

	/**
	 * for twitter btn.
	 * 
	 * @return $tag (画像リンクタグ)
	 */
	function makeTwitterBtnURL() {
		
		$tag  = '<a';
		$tag .= ' href="http://twitter.com/share"';
		$tag .= ' class="twitter-share-button wph"';
		$tag .= ' data-count="none"';
		$tag .= ' data-lang="ja"';
		$tag .= '>';
		$tag .= 'Tweet';
		$tag .= '</a>';
		$tag .= '<script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>';
		
		return $tag;
		
	}

	/**
	 * for Evernote Clip btn.
	 * 
	 * @param $title
	 * @param $url (URL)
	 * @param $contentid (クリップする id)
	 * @return $tag (画像リンクタグ)
	 */
	function makeEvernoteClipURL($title, $url, $key, $contentid) {
		
		$tag  = '<a';
		$tag .= ' href="#"';
		$tag .= ' class="wph"';
		$tag .= ' onclick="Evernote.doClip({';
		$tag .= ' providerName:\'Numb.\',';
		$tag .= ' code:\' . $key . \',';
		$tag .= ' title:\'' . $title . '\',';
		$tag .= ' url:\'' . $url . '\',';
		$tag .= ' contentId:\''. $contentid . '\'';
		$tag .= '}); return false;">';
		$tag .= '<img src="http://static.evernote.com/article-clipper-jp.png" alt="Clip to Evernote" />';
		$tag .= '</a>';
		$tag .= '<script type="text/javascript" src="http://static.evernote.com/noteit.js"></script>';
		
		return $tag;
		
	}

	/**
	 * for newHatena.
	 * 
	 * @param $title
	 * @param $imgurl (imgURL)
	 * @param $url (URL)
	 * @return $tag (画像リンクタグ)
	 */
	function makeNewHatenaURL($title, $url) {
		
		$tag  = '<a';
		$tag .= ' href="' . $url . '"';
		$tag .= ' class="hatena-bookmark-button wph"';
		$tag .= ' data-hatena-bookmark-title="' . $title . '"';
		$tag .= ' data-hatena-bookmark-layout="standard"';
		$tag .= ' title="このエントリーをはてなブックマークに追加"';
		$tag .= '>';
		$tag .= '<img src="http://b.st-hatena.com/images/entry-button/button-only.gif" alt="このエントリーをはてなブックマークに追加" />';
		$tag .= '</a>';
		$tag .= '<script type="text/javascript" src="http://b.st-hatena.com/js/bookmark_button.js" charset="utf-8" async="async"></script>';
		
		return $tag;
		
	}

	/**
	 * for Facebook like btn.
	 * 
	 * @param $url (URL)
	 * @return $tag (画像リンクタグ)
	 */
	function makeFacebookURL($url) {
		
		$tag  = '<iframe';
		$tag .= ' src="' . $url;
		$tag .= '&amp;layout=button_count&amp;show_faces=true&amp;width=110&amp;action=like&amp;colorscheme=light&amp;height=20" scrolling="no" frameborder="0" class="wph facebook" allowTransparency="true"';
		$tag .= '>';
		$tag .= '</iframe>';
		
		return $tag;
		
	}

	/**
	 * UTF-8 encoder.
	 * 
	 * @param $text
	 * @return $text (UTF-8 に変換した文字列)
	 */
	function utf8_encode($text) {
		
		if(!preg_match ("/UTF-8/i", $this->blog_charset)) {
			if(function_exists('mb_convert_encoding')) {
				$text = 
					mb_convert_encoding(
						$text,
						'UTF-8',
						$this->blog_charset
					);
			}
		}
		
		return $text;
		
	}

	/**
	 * WP filter interface.(wp_head)
	 *  - 未使用 (popup.js 未実装のため)
	 * 
	 * @param none
	 * @return none (画像説明ポップアップ JavaScript を echo)
	 */
	function addScript() {
		
		echo '<script type="text/javascript"';
		echo ' src="'. $this->plugin_path . $this->popup_jsname . '"';
		echo '>';
		echo '</script>' . "\n";		
	}

	/**
	 * WP filter interface.(wp_head)
	 * 
	 * @param none
	 * @return none (CSS を echo)
	 */
	function echoCss() {
		
		echo '<link rel="stylesheet"';
		echo ' href="' . $this->plugin_path . $this->path_css . '"';
		echo 'type="text/css" media="screen" />' . "\n";
		
	}
	
}

/******************************************************************************
 * wp-hatena css - WordPress Interface Define
 *****************************************************************************/
$wph = & new WpHatena();
add_action('wp_head', array(&$wph, 'echoCss'));

?>
