<?php
/*
Plugin Name: Hatena bookmark anywhere
Version: 0.1.5
Plugin URI: http://wppluginsj.sourceforge.jp/hatena-bookmark-anywhere/
Description: Hatena bookmark anywhere
Author: <a href="http://blog.masuidrive.jp/" title="Visit Authorhomepage">masuidrive</a> &amp; <a href="http://dogmap.jp/" title="Visit Authorhomepage">wokamoto</a>
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2008 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Includes:
 This plugin includes "どこでもはてブ - Hatena bookmark anywhere"
  http://blog.masuidrive.jp/index.php/category/hba/
  The MIT License
  Copyright (c) 2008 Yuichiro MASUI <masui@masuidrive.jp>
*/

if (!class_exists('wokController') || !class_exists('wokScriptManager'))
	require(dirname(__FILE__).'/includes/common-controller.php');

class HateBuAnywhereController extends wokController {
	var $plugin_name  = 'hatena-bookmark-anywhere';

	var $js_file      = 'js/hatena-bookmark-anywhere-0-1.js';
	var $js_ver       = '0.1';

	var $_options_default;

	/*
	* Constructor
	*/
	function HateBuAnywhereController() {
		$this->__construct();
	}
	function __construct() {
		$this->init(__FILE__);
		$this->options = $this->_initOptions($this->getOptions());
	}

	function _initOptions($wk_options = '') {
		$this->_options_default = array(
			 'limit'       => 100	// 表示する件数
			,'style'       => true	// true でデフォルトスタイル false を設定するとCSSでスタイルの指定が可能
			,'collapse'    => false	// true にすると、コメントの書いてないブクマを表示しない。指定しない場合は、表示件数を超えた場合のみコメントを表示しない
			,'set_auto'    => true	// true にすると、本文記事の後に自動でセット
			,'set_css'     => false	// true にすると、ヘッダ部にCSSを読込
			,'css'         => array(
				 'body'    => 'font-size: 90%; font-family: "Arial", sans-serif; color: #000;'
				,'any'     => 'margin: 0; padding: 0; text-align: left; font-weight: normal; font-family: "Arial", sans-serif;'
				,'zero'    => 'background-color:#edf1fd; border-top:1px solid #5279e7; list-style-position: inside; margin:2px 0 0 0;padding: 8px 5px 12px 8px;'
				,'ul'      => 'background-color:#edf1fd; border-top:1px solid #5279e7; list-style-position: inside; margin:2px 0 0 0;padding: 8px 5px 12px 8px;'
				,'li'      => 'list-style-type: circle; padding: 1px 0;'
				,'user'    => 'color: #00e; text-decoration: underline; margin: 0 2px;'
				,'tags'    => 'font-size: 90%; color: #66c; margin: 0 4px 0 2px;'
				,'tags_a'  => 'text-decoration: none; color: #66c;'
				,'go'      => 'font-size: 90%; color: #66c; text-decoration: none;'
				)
			,'css_id'      => 'hatena_bookmark_anywhere'
			,'load'        => array(
				 'single'  => true
				,'page'    => true
				)
			);
		if (!is_array($wk_options)) $wk_options = array();
		if (!isset($wk_options['limit']))      $wk_options['limit']      = $this->_options_default['limit'];
		if (!isset($wk_options['style']))      $wk_options['style']      = $this->_options_default['style'];
		if (!isset($wk_options['collapse']))   $wk_options['collapse']   = $this->_options_default['collapse'];
		if (!isset($wk_options['set_auto']))   $wk_options['set_auto']   = $this->_options_default['set_auto'];
		if (!isset($wk_options['set_css']))    $wk_options['set_css']    = $this->_options_default['set_css'];
		if (!isset($wk_options['css']))        $wk_options['css']        = '';
		if (!isset($wk_options['load']))       $wk_options['load']       = $this->_options_default['load'];
		return $wk_options;
	}

	function _isDisplay() {
		return (
			($this->options['load']['single'] && is_single())
			|| ($this->options['load']['page'] && is_page())
			);
	}

	// regist script
	function addScripts() {
		if ($this->_isDisplay()) {
			wp_enqueue_script($this->plugin_name, $this->plugin_url.$this->js_file, array(), $this->js_ver);
		}
	}

	function addHead() {
		if (!($this->options['set_css'] && is_array($this->options['css']))) return;

		if ($this->_isDisplay()) {
			$wk_tmpl = "#".$this->_options_default['css_id']." %s{%s}\n";
			$out  = "<style type=\"text/css\">\n";
			$out .= sprintf($wk_tmpl, "", $this->options['css']['body']);
			$out .= sprintf($wk_tmpl, "* ", $this->options['css']['any']);
			$out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_zero ", $this->options['css']['zero']);
			$out .= sprintf($wk_tmpl, "ul ", $this->options['css']['ul']);
			$out .= sprintf($wk_tmpl, "ul li ", $this->options['css']['li']);
			$out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_user ", $this->options['css']['user']);
			$out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_tags ", $this->options['css']['tags']);
			$out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_tags a ", $this->options['css']['tags_a']);
			$out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_go ", $this->options['css']['go']);
			$out .= "</style>\n";
			echo $out;
		}
	}

	function addFooter() {
		if ($this->_isDisplay()) {
			$out = '';
			echo $out;
		}
	}

	function addContent($content) {
		if ($this->_isDisplay()) {
			// パーセントエンコーディングを大文字に変換
			$url  = get_permalink();
			if (preg_match('/(%[0-9a-f]{2}?)+/', $url))
				$url  = preg_replace_callback('/(%[0-9a-f]{2}?)+/', create_function('$matches','return strtoupper($matches[0]);'), $url);

			$content .= ($this->options['set_auto'] ? "<br clear=\"all\" /><div id=\"{$this->_options_default['css_id']}\"></div>\n" : '');

			$content .= "<script type=\"text/javascript\">\n";
			$content .= "var hatena_bookmark_anywhere_limit = {$this->options['limit']};";
			$content .= "var hatena_bookmark_anywhere_style = " . ($this->options['style'] ? "true" : "false") . ";";
			$content .= ($this->options['collapse'] ? "var hatena_bookmark_anywhere_collapse = true;" : '');
			$content .= "var hatena_bookmark_anywhere_url = '{$url}';";
			$content .= "\n";
			$content .= "</script>\n";
		}
		return $content;
	}

	function addAdminMenu() {
		$this->addOptionPage( __('Hatena bookmark anywhere', $this->textdomain_name), array($this,'optionPage'));
	}

	function optionPage() {
		if(isset($_POST['ap_options_update'])) {
			// check referer
			if ($this->wp25)
				check_admin_referer("update_options", "_wpnonce_update_options");

			// strip slashes array
			$_POST = $this->stripArray($_POST);

			// get options
			$this->options['limit']          = (is_numeric($_POST['hatena_bookmark_anywhere_limit']) ? $_POST['hatena_bookmark_anywhere_limit'] : $this->_options_default['limit']);
			$this->options['set_auto']       = (isset($_POST['hatena_bookmark_anywhere_auto']) && $_POST['hatena_bookmark_anywhere_auto']=='1' ? true : false);
			$this->options['load']['single'] = (isset($_POST['hatena_bookmark_anywhere_single']) && $_POST['hatena_bookmark_anywhere_single']=='1' ? true : false);
			$this->options['load']['page']   = (isset($_POST['hatena_bookmark_anywhere_page']) && $_POST['hatena_bookmark_anywhere_page']=='1' ? true : false);
			$this->options['style']          = (isset($_POST['hatena_bookmark_anywhere_style']) && $_POST['hatena_bookmark_anywhere_style']=='1' ? true : false);
			$this->options['collapse']       = (isset($_POST['hatena_bookmark_anywhere_collapse']) && $_POST['hatena_bookmark_anywhere_collapse']=='1' ? true : false);
			$this->options['set_css']        = (isset($_POST['hatena_bookmark_anywhere_style']) && $_POST['hatena_bookmark_anywhere_style']!='1' && isset($_POST['hatena_bookmark_anywhere_css']) && $_POST['hatena_bookmark_anywhere_css']=='1' ? true : false);
			if ($this->options['set_css']) {
				$this->options['css'] = array(
					 'body'    => $_POST['css_body']
					,'any'     => $_POST['css_any']
					,'zero'    => $_POST['css_zero']
					,'ul'      => $_POST['css_ul']
					,'li'      => $_POST['css_li']
					,'user'    => $_POST['css_user']
					,'tags'    => $_POST['css_tags']
					,'tags_a'  => $_POST['css_tags_a']
					,'go'      => $_POST['css_go']
					);
			}
			$_POST = '';

			// options update
			$this->updateOptions();

			// Done!
			$this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

		} elseif(isset($_POST['ap_options_delete'])) {
			// check referer
			if ($this->wp25)
				check_admin_referer("delete_options", "_wpnonce_delete_options");

			// options delete
			$this->deleteOptions();
			$this->options = $this->_initOptions();

			// Done!
			$this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
			$this->error++;
		}

		$out  = '';

		// Add Options
		$out .= "<div class=\"wrap\">\n";
		$out .= "<h2>".__('Hatena bookmark anywhere Options', $this->textdomain_name)."</h2><br />\n";
		$out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
		$out .= ($this->wp25 ? $this->makeNonceField("update_options", "_wpnonce_update_options", true, false) : '');

		$out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

		// Limit
		$out .= "<tr>";
		$out .= "<td style=\"width:60px;\"><strong>".__('Limit', $this->textdomain_name)."</strong></td>";
		$out .= "<td><input type=\"text\" name=\"hatena_bookmark_anywhere_limit\" id=\"hatena_bookmark_anywhere_limit\" size=\"10\" value=\"".$this->options['limit']."\" /></td>";
		$out .= "</tr>\n";

		// Display
		$out .= "<tr>";
		$out .= "<td><strong>".__('Display', $this->textdomain_name)."</strong></td>";
		$out .= "<td><input type=\"checkbox\" name=\"hatena_bookmark_anywhere_auto\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['set_auto']?' checked="true"':'')." />".__('Displays automatically', $this->textdomain_name)."</td>";
		$out .= "</tr>\n";

		// JavaScript Load
		$out .= "<tr>";
		$out .= "<td><strong>".__('Load', $this->textdomain_name)."</strong></td>";
		$out .= "<td>";
		$out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_single\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['load']['single']?' checked="true"':'')." />".__('Post')."&nbsp;";
		$out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_page\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['load']['page']?' checked="true"':'')." />".__('Page');
		$out .= "</td>";
		$out .= "</tr>\n";

		// Style
		$out .= "<tr>";
		$out .= "<td><strong>".__('Style', $this->textdomain_name)."</strong></td>";
		$out .= "<td>";
		$out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_style\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['style']?' checked="true"':'')." onclick=\"javascript:document.getElementById('hatena-bookmark-anywhere_css_check').style.display=(!this.checked?'block':'none');if(this.checked){document.getElementById('hatena_bookmark_anywhere_css').checked = false;document.getElementById('hatena-bookmark-anywhere_css_options').style.display='none';}\" />".__('Default Style', $this->textdomain_name)."<br />";

		// CSS
		$wk_css_options = (!is_array($this->options['css']) ? $this->options['css'] : $this->_options_default['css']);
		$out .= "<span id=\"hatena-bookmark-anywhere_css_check\" style=\"display:".(!$this->options['style']?'block':'none').";\">";
		$out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_css\" id=\"hatena_bookmark_anywhere_css\" value=\"1\" style=\"margin-right:0.5em\" ".(!$this->options['style'] && $this->options['set_css']?' checked="true"':'')." onclick=\"javascript:document.getElementById('hatena-bookmark-anywhere_css_options').style.display=(this.checked?'block':'none');\" />".__('CSS is set from the plugin', $this->textdomain_name)."<br />";
		$out .= "</span>";

		$sub_table_style = " style=\"margin:.25em;padding:0;border-style:none;\"";
		$out .= "<div id=\"hatena-bookmark-anywhere_css_options\" style=\"display:".(!$this->options['style'] && $this->options['set_css']?'block':'none').";\">";
		$out .= "<table{$sub_table_style}>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('Background', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_body\" id=\"css_body\" size=\"100\" value=\"".$wk_css_options['body']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('Any', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_any\" id=\"css_any\" size=\"100\" value=\"".$wk_css_options['any']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('Zero', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_zero\" id=\"css_zero\" size=\"100\" value=\"".$wk_css_options['zero']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('List (ul)', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_ul\" id=\"css_ul\" size=\"100\" value=\"".$wk_css_options['ul']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('List (li)', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_li\" id=\"css_li\" size=\"100\" value=\"".$wk_css_options['li']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('User', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_user\" id=\"css_user\" size=\"100\" value=\"".$wk_css_options['user']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('Tags', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_tags\" id=\"css_tags\" size=\"100\" value=\"".$wk_css_options['tags']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('Tags (link)', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_tags_a\" id=\"css_tags_a\" size=\"100\" value=\"".$wk_css_options['tags_a']."\" /></td>";
		$out .= "</tr>";
		$out .= "<tr{$sub_table_style}>";
		$out .= "<td{$sub_table_style}><strong>".__('Go', $this->textdomain_name)."</strong></td>";
		$out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_go\" id=\"css_go\" size=\"100\" value=\"".$wk_css_options['go']."\" /></td>";
		$out .= "</tr>";
		$out .= "</table>";
		$out .= "</div>";
		unset($wk_css_options);

		$out .= "</td>";
		$out .= "</tr>\n";

		// Collapse
		$out .= "<tr>";
		$out .= "<td><strong>".__('Collapse', $this->textdomain_name)."</strong></td>";
		$out .= "<td><input type=\"checkbox\" name=\"hatena_bookmark_anywhere_collapse\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['collapse']?' checked="true"':'')." />".__('No display where the comment is not written', $this->textdomain_name)."</td>";
		$out .= "</tr>\n";

		$out .= "</tbody></table>";

		// Add Update Button
		$out .= "<p style=\"margin-top:1em;\"><input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
		$out .= "</form></div>\n";

		// Add Options
		$out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
		$out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
		$out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
		$out .= ($this->wp25 ? $this->makeNonceField("delete_options", "_wpnonce_delete_options", true, false) : '');

		// Delete Button
		$out .= "<input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
		$out .= "</form></div>\n";

		// Output
		echo (!empty($this->note) ? "<div id=\"message\" class=\"updated fade\"><p>{$this->note}</p></div>\n" : '')."\n";
		echo ($this->error == 0 ? $out : '')."\n";
	}
}//class

$HateBuAnywhere = new HateBuAnywhereController();

if (is_admin()) {
	add_action('admin_menu', array(&$HateBuAnywhere,'addAdminMenu'));
} else {
	add_action('wp_print_scripts', array(&$HateBuAnywhere,'addScripts'));
	add_action('wp_head', array(&$HateBuAnywhere,'addHead'));
	add_action('wp_footer', array(&$HateBuAnywhere,'addFooter'));
	add_filter('the_content', array(&$HateBuAnywhere,'addContent'), 9999);
}

unset($HateBuAnywhere);
?>