<?php
/*
Plugin Name: WP-AutoPager
Version: 0.4.5
Plugin URI: http://wppluginsj.sourceforge.jp/wp-autopager/
Description: Add autoloading for next page to Wordpress. DblClick to enable/disable it.
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 this script based on
 GoogleAutoPager(http://la.ma.la/blog/diary_200506231749.htm)
 thanks to ma.la.
*/

class AutoPagerController {
  var $plugin_name   = 'wp-autopager';

  var $jquery_js     = 'jquery-1.2.3.min.js';
  var $jquery_ver    = '1.2.3';

  var $autopager_js  = 'wp-autopager.js';
  var $autopager_ver = '0.4.5';

  var $js_type = array(0 => 'none',
                       1 => 'Prototype',
                       2 => 'jQuery');

  var $options, $option_name;
  var $textdomain_name;
  var $admin_option, $admin_action;
  var $note, $error;

  var $wpLightpop_enable = false;

  /*
  * Constructor
  */
  function AutoPagerController() {
    $this->note = '';
    $this->error = 0;

    $this->option_name  = $this->plugin_name." Options";
    $this->options      = get_option($this->option_name);
    $this->initOptions();

    $this->textdomain_name = $this->plugin_name;
    load_plugin_textdomain($this->textdomain_name, 'wp-content/plugins/wp-autopager');

    $this->admin_option = basename(__FILE__);
    $this->admin_action = get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option;

    // wp-lightpop active?
    foreach (get_option("active_plugins") as $val) {
      if (preg_match('/wp\-lightpop\.php/i', $val)) {$this->wpLightpop_enable = true; break;}
    }
  }

  /*
  * Init Options
  */
  function initOptions() {
    if (!is_array($this->options)) $this->options = array();

    if (!isset($this->options['content_id']))       $this->options['content_id'] = "content";
    if (!isset($this->options['post_class']))       $this->options['post_class'] = "post";
    if (!isset($this->options['navigation_class'])) $this->options['navigation_class'] = "navigation";
    if (!isset($this->options['remain']))           $this->options['remain'] = 500;
    if (!isset($this->options['default_enable']))   $this->options['default_enable'] = 1;
    if (!isset($this->options['plugin_uri']))       $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
    if (!isset($this->options['js_type'])) {
     $this->options['js_type'] = strtolower($this->js_type[0]);
    } elseif (strtolower($this->options['js_type']) == 'jquery.noconflict') {
     $this->options['js_type'] = strtolower($this->js_type[2]);
    }
  }

  /*
  * Update Options
  */
  function update_options() {
    update_option($this->option_name, $this->options);
    $this->autopagerJs_write();
  }

  /*
  * Delete Options
  */
  function deleteOptions() {
    delete_option($this->option_name);
    $this->options = array();
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  /*
  * regist script
  */
  function re_regist_script( $handle, $src = '', $deps = false, $ver = false ) {
    global $wp_scripts;
    if ( !is_a($wp_scripts, 'WP_Scripts') ) $wp_scripts = new WP_Scripts();
    if ( isset($wp_scripts->scripts[$handle]) ) {
      if ( version_compare($wp_scripts->scripts[$handle]->ver, $ver, "<") ) {
        if ($src  != '')     $wp_scripts->scripts[$handle]->src  = $src;
        if (is_array($deps)) $wp_scripts->scripts[$handle]->deps = $deps;
        if ($ver  != false)  $wp_scripts->scripts[$handle]->ver  = $ver;
      }
    } else {
      if (!is_array($deps)) $deps = array();
      $wp_scripts->add( $handle, $src, $deps, $ver );
    }
  }

  /*
  * add action (wp_print_scripts)
  */
  function addScripts() {
   if (is_admin() || is_404() || is_single() || is_page() ) {return false;}

   switch($this->options['js_type']) {
    case strtolower($this->js_type[1]):
     $deps = array('prototype');
     break;
    case strtolower($this->js_type[2]):
    case strtolower($this->js_type[3]):
     $this->re_regist_script('jquery', $this->options['plugin_uri'].'/'.$this->jquery_js, false, $this->jquery_ver);
     $deps = array('jquery');
     break;
    default:
     $deps = array();
     break;
   }
   wp_enqueue_script('wp-autopager', $this->options['plugin_uri'].'/'.$this->autopager_js, $deps, $this->autopager_ver);
  }

  function isLoadScripts() {
    return (!is_404() && !is_single() && !is_page());
  }

  /*
  * add action (wp_head)
  */
  function addWpHead() {
    if ($this->isLoadScripts() && !have_posts()){
      header("HTTP/1.1 404 Not Found");
    }
  }

  /*
  * add action (wp_footer)
  */
  function addWpFooter() {
    if ($this->isLoadScripts() && have_posts()){
      global $request, $posts_per_page, $wpdb, $paged;

      // get Max Page
      $numposts = 0;
      if(strpos(get_query_var('tag'), " ")) {
        preg_match('#^(.*)\sLIMIT#siU', $request, $matches);
        $fromwhere = $matches[1];
        $results = $wpdb->get_results($fromwhere);
        $numposts = count($results);
      } else {
        preg_match('#FROM\s*+(.+?)\s+(GROUP BY|ORDER BY)#si', $request, $matches);
        $fromwhere = $matches[1];
        $numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");
      }
      $max_page = ceil($numposts/$posts_per_page);

      // get Next Page No.
      if(empty($paged)) {$paged = 1;}
      $next_page = $paged + 1;

      // get Query String
      $query = get_pagenum_link($next_page);
      if (strstr($query,"?") != false) {
        if (preg_match("/^(.*\/)page\/(\d+)\/(.*)$/i", $query, $matches)) {
          $query = $matches[1].$matches[3]."&paged=";
          $next_page = $matches[2];
        } elseif (preg_match("/(.*paged=)(\d+)/i", $query, $matches)) {
          $query = $matches[1];
          $next_page = $matches[2];
        }
      } elseif (preg_match("/(.+page\/)(\d+)/i", $query, $matches)) {
          $query = $matches[1];
          $next_page = $matches[2];
      } else {
        if (preg_match("/(.+paged=)(\d+)/i", $query, $matches)) {
          $query = $matches[1];
          $next_page = $matches[2];
        } else {
          if (strstr($query,"?")) {
            $query = $query."&paged=";
          }
        }
      }
      $query = str_replace('http://'.$_SERVER['SERVER_NAME'].'/', '/', $query);

      // echo javascript
      $start_autopager = "autopager('%s', %d, %d%s);";
      $out  = "<script type=\"text/javascript\">/*<![CDATA[*/\n";
      switch($this->options['js_type']) {
       case strtolower($this->js_type[1]):
        $out .= "Event.observe(window, 'load', function(){".sprintf($start_autopager,$query,$next_page,$max_page,"")."}, false);\n";
        break;
       case strtolower($this->js_type[2]):
       case strtolower($this->js_type[3]):
        $out .= "(function(jQuery){".sprintf($start_autopager,$query,$next_page,$max_page,", jQuery")."})(jQuery);\n";
        break;
       default:
        $out .= sprintf($start_autopager,$query,$next_page,$max_page,"")."\n";
        break;
      }
      $out .= "/*]]>*/</script>\n";
      echo $out;
    }
  }

  /*
  * add action (init)
  */
  function install() {
    if (isset($_GET['activate']) && $_GET['activate'] == 'true') {
      $this->autopagerJs_write();
    }
  }

  /*
  * add action (admin_menu)
  */
  function addAdminMenu() {
    add_options_page(__('AutoPager', $this->textdomain_name)
                    ,__('AutoPager', $this->textdomain_name)
                    ,9
                    ,$this->admin_option
                    ,array($this,'optionPage')
                    );
  }

  function optionPage() {
    // options update
    if(isset($_POST['ap_options_update'])) {
      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['content_id']       = $_POST['ap_content_id'];
      $this->options['post_class']       = $_POST['ap_post_class'];
      $this->options['navigation_class'] = $_POST['ap_navigation_class'];
      $this->options['remain']           = $_POST['ap_remain'];
      $this->options['default_enable']   = $_POST['ap_default_enable'] == 1;
      $this->options['plugin_uri']       = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $this->options['js_type']          = strtolower($this->js_type[$_POST['js_type']]);
      $_POST = '';

      // Done!
      $this->update_options();
      $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);

    } elseif(isset($_POST['ap_options_uninstall'])) {
      // uninstall
      $this->deleteOptions();
      $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);
      $this->error++;
      $this->initOptions();
   }

    // Add Options
    $out .= '<div class="wrap">'."\n";
    $out .= '<h2>'.__('WP-AutoPager Options', $this->textdomain_name).'</h2><br />'."\n";
    $out .= '<form method="post" id="update_options" action="'.$this->admin_action.'">'."\n";

    $out .= '<table>'."\n";

    // Content ID
    $out .= '<tr><td><strong>'.__('Content ID', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_content_id" value="'.$this->options['content_id'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    // Posts Class
    $out .= '<tr><td><strong>'.__('Posts Class', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_post_class" value="'.$this->options['post_class'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    // Navigation Class
    $out .= '<tr><td><strong>'.__('Navigation Class', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_navigation_class" value="'.$this->options['navigation_class'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    // Remain
    $out .= '<tr><td><strong>'.__('Remain', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_remain" value="'.$this->options['remain'].'" /></td>';
    $out .= '<td>'.__('Position in which lookahead is begun(relative value px from the bottom of a browser)', $this->textdomain_name).'</td></tr>'."\n";

    // Default Enable / Desable
    $out .= '<tr><td><strong>'.__('Default Enable', $this->textdomain_name).'</strong></td>';
    $out .= '<td><select name="ap_default_enable">';
    $out .= '<option value="0"'.($this->options['default_enable']==0?' selected="selected"':'').'>'.__('disable', $this->textdomain_name).'</option>';
    $out .= '<option value="1"'.($this->options['default_enable']==1?' selected="selected"':'').'>'.__('enable', $this->textdomain_name).'</option>';
    $out .= '</select></td>';
    $out .= '<td>'.__('Whether operation is enabled when the page is displayed is set.', $this->textdomain_name).'</td></tr>'."\n";

    // Choose Javascript Framework
    $out .= '<tr><td><strong>'.__('JS Framework', $this->textdomain_name).'</strong></td>';
    $out .= '<td><select name="js_type">';
    for ($i = 0; $i < sizeof($this->js_type); $i++) {
      $out .= '<option value="'.$i.'"'.($this->options['js_type'] == strtolower($this->js_type[$i]) ? ' selected="selected"' : '').'>'.__($this->js_type[$i], $this->textdomain_name).'</option>';
    }
    $out .= '</select>';
    $out .= '</td>';
    $out .= '<td>'.__('Please choose the type of JavaScript Framework.', $this->textdomain_name).'<br /> (Prototype.js, jQuery.js or none)</td></tr>'."\n";

    $out .= '</table>'."\n";

    // Add Update Button
    $out .= '<input type="submit" name="ap_options_update" value="'.__('Update Options', $this->textdomain_name).' &raquo;" class="button" />';
    $out .= '</form></div>'."\n";

    // Add Usage
    $out .= '<div class="wrap" style="margin-top:3em;">'."\n";
    $out .= '<h2>'.__('Usage', $this->textdomain_name).'</h2><br />'."\n";
    $out .= '<p>'.__('If it is a default template base, it operates yet in there is no template correction.', $this->textdomain_name).'<br />'."\n";
    $out .= __('If the structure of HTML is as follows, it is OK.', $this->textdomain_name).'</p>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7ED;width:auto;_width:95%;margin:0.25em;padding:0.25em;">'."\n";
    $out .= '&lt;html&gt;<br />'."\n";
    $out .= '&lt;head&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<p>&lt;/head&gt;<br />'."\n";
    $out .= '&lt;body&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7DD;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>id=&#8221;content&#8221;</strong></em>&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7BB;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;navigation&#8221;</strong></em>&gt;&#8230;'.__('Page navigation', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";

    $out .= '<p>&lt;/div&gt;</div>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<p>&lt;/body&gt;<br />'."\n";
    $out .= '&lt;/html&gt;'."\n";
    $out .= '</div>'."\n";

    $out .= '</div>'."\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:3em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_uninstall\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function autopagerJs($fname, $ftype) {
    if ($ftype == "") {$ftype = strtolower($this->js_type[0]);}
    $filename = dirname($fname)."/js_template/".basename($fname).".min.".$ftype;
    if (!file_exists($filename)) {$filename = dirname(__FILE__)."/js_template/".basename($fname).".min.default";}

    $handle = fopen($filename, "r");
    $out_tmpl = fread($handle, filesize($filename));
    fclose($handle);

    switch($ftype) {
     case strtolower($this->js_type[2]):
     case strtolower($this->js_type[3]):
      $lightpop = '';
      if ($this->wpLightpop_enable) {
       $arrLigtpop_options = get_option("wp-lightpop Options");
       if (is_array($arrLigtpop_options)) {
        $lightpop .= 'var l='.$arrLigtpop_options['lightpop_option'].';';
        foreach(preg_split('/[\n\r]/', apply_filters('css_elements/wp-lightpop.php', $arrLigtpop_options['targetCSS'])) as $value) {
         if (trim($value) != '') {$lightpop .= "jQuery('".trim($value)."',b).lightpop(l);";}
        }
       } else {
        $lightpop .= "jQuery('a',b).lightpop();";
       }
       unset($arrLigtpop_options);
      } else {
       $lightpop .= "jQuery('a',b).lightpop();";
      }
      $out = sprintf($out_tmpl, ($this->options['default_enable']==1?'true':'false'), $this->options['remain'], $this->options['plugin_uri'], $this->options['post_class'], $this->options['navigation_class'], $this->options['content_id'], $lightpop);
      break;
     default:
      $out = sprintf($out_tmpl, ($this->options['default_enable']==1?'true':'false'), $this->options['remain'], $this->options['plugin_uri'], $this->options['post_class'], $this->options['navigation_class'], $this->options['content_id']);
      break;
    }

    return $out;
  }

  function autopagerJs_write() {
    $filename = dirname(__FILE__)."/".$this->autopager_js;
    $js_type = strtolower($this->options['js_type']);

    $js_text = $this->autopagerJs($filename, $js_type);
    $retVal = TRUE;

    if (is_writable($filename)) {
      if (!$handle = fopen($filename, 'w')) {
        $retVal = FALSE;
      } else {
        if (fwrite($handle, $js_text) === FALSE) {$retVal = FALSE;}
        fclose($handle);
      }
    } else {
      $retVal = FALSE;
    }
    return $retVal;
  }

}//class

$wpAutoPager = new AutoPagerController();

add_action('init', array(&$wpAutoPager,'install'));
add_action('admin_menu', array(&$wpAutoPager,'addAdminMenu'));

add_action('wp_print_scripts', array(&$wpAutoPager,'addScripts'));
add_action('wp_head',array(&$wpAutoPager,'addWpHead'));
add_action('wp_footer',array(&$wpAutoPager,'addWpFooter'));

unset($wpAutoPager);
?>
