<?php
/******************************************************************************
 * bbEmoticons version 0.72
 * 
 * A Clickable Smilies hack for bbPress.
 * 
 * @Author        hiromasa (http://hiromasa.zone.ne.jp/blog/)
 * @Thanks        kohaku (http://www.orioa.com/)
 *                aka (http://plasticdreams.org/)
 * @Original      WP Grins By Alex King
 *                 (http://www.alexking.org/software/wordpress/)
 *                WordPress convert_smilies function and images
 *                 (http://wordpress.org/)
 *****************************************************************************/

/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * bbEmoticons
 * 
 * @author     hiromasa
 * @version    0.72
 * 
 *****************************************************************************/
class bbEmoticons {
	
	var $bb_grins;
	var $bb_smiliessearch = array();
	var $bb_smiliesreplace = array();
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function bbEmoticons() {
		
		if (isset($_GET['bb_grins_output'])) {
			switch ($_GET['bb_grins_output']) {
				case "javascript":
					$this->outputGringJS();
			}
			exit(0);
		}
		
		$bb_smiliestrans = array(
			' :)'       => 'icon_smile.gif',
			' :D'       => 'icon_biggrin.gif',
			' :-D'      => 'icon_biggrin.gif',
			':grin:'    => 'icon_biggrin.gif',
			' :)'       => 'icon_smile.gif',
			' :-)'      => 'icon_smile.gif',
			':smile:'   => 'icon_smile.gif',
			' :('       => 'icon_sad.gif',
			' :-('      => 'icon_sad.gif',
			':sad:'     => 'icon_sad.gif',
			' :o'       => 'icon_surprised.gif',
			' :-o'      => 'icon_surprised.gif',
			':eek:'     => 'icon_surprised.gif',
			' 8O'       => 'icon_eek.gif',
			' 8-O'      => 'icon_eek.gif',
			':shock:'   => 'icon_eek.gif',
			' :?'       => 'icon_confused.gif',
			' :-?'      => 'icon_confused.gif',
			' :???:'    => 'icon_confused.gif',
			' 8)'       => 'icon_cool.gif',
			' 8-)'      => 'icon_cool.gif',
			':cool:'    => 'icon_cool.gif',
			':lol:'     => 'icon_lol.gif',
			' :x'       => 'icon_mad.gif',
			' :-x'      => 'icon_mad.gif',
			':mad:'     => 'icon_mad.gif',
			' :P'       => 'icon_razz.gif',
			' :-P'      => 'icon_razz.gif',
			':razz:'    => 'icon_razz.gif',
			':oops:'    => 'icon_redface.gif',
			':cry:'     => 'icon_cry.gif',
			':evil:'    => 'icon_evil.gif',
			':twisted:' => 'icon_twisted.gif',
			':roll:'    => 'icon_rolleyes.gif',
			':wink:'    => 'icon_wink.gif',
			' ;)'       => 'icon_wink.gif',
			' ;-)'      => 'icon_wink.gif',
			':!:'       => 'icon_exclaim.gif',
			':?:'       => 'icon_question.gif',
			':idea:'    => 'icon_idea.gif',
			':arrow:'   => 'icon_arrow.gif',
			' :|'       => 'icon_neutral.gif',
			' :-|'      => 'icon_neutral.gif',
			':neutral:' => 'icon_neutral.gif',
			':mrgreen:' => 'icon_mrgreen.gif',
		);
		
		foreach($bb_smiliestrans as $smiley => $img) {
			$this->bb_smiliessearch[] = $smiley;
			$smiley_masked = htmlspecialchars(trim($smiley), ENT_QUOTES);
			$this->bb_smiliesreplace[] = 
				" <img src='" . bb_get_option('uri') .
				"bb-images/smilies/$img' alt='$smiley_masked' class='wp-smiley' /> ";
		}
		
		$this->grins = '';
		$smiled = array();
		foreach ($bb_smiliestrans as $tag => $grin) {
			if (!in_array($grin, $smiled)) {
				$smiled[] = $grin;
				$tag = str_replace(' ', '', $tag);
				$this->grins .=
					'<img src="'. bb_get_option('uri') .
					'bb-images/smilies/'.$grin.'" alt="' .$tag .
					'" onclick="grin(\' '.$tag.'\');"/> ';
			}
		}
		
	}
	
	/**
	 * post_text filter
	 * 
	 * @param $text
	 * @return $output
	 */
	function convert_smilies($text) {
		
		$output = '';
		$textarr = preg_split("/(<.*>)/U", $text, -1, PREG_SPLIT_DELIM_CAPTURE);
		$stop = count($textarr);
		for($i=0; $i<$stop; $i++) {
			$content = $textarr[$i];
			if((strlen($content) > 0) && ('<' != $content{0})) {
				$content = str_replace(
					$this->bb_smiliessearch,
					$this->bb_smiliesreplace,
					$content);
			}
			$output .= $content;
		}
		
		return $output;
		
	}
	
	/**
	 * bb_grins action
	 * 
	 * @param none
	 * @return none
	 */
	function bb_grins() {
		
		echo '<div id="bb_grins">' . $this->grins . '</div>';
		
	}
	
	/**
	 * bb_head action
	 * 
	 * @param none
	 * @return none
	 */
	function bb_grins_head() {
		
		echo
			'<script type="text/javascript" src="'. bb_get_option('uri') .
			'my-plugins/bb-emoticons.php?bb_grins_output=javascript"></script>' .
			"\n";
		
	}
	
	/**
	 * Output Grins JavaScript
	 * 
	 * @param none
	 * @return none
	 */
	function outputGringJS() {
	
?>
function grin(tag) {
	var myField;
	if (document.getElementById('post_content') && document.getElementById('post_content').type == 'textarea') {
		myField = document.getElementById('post_content');
	}
	else if (document.getElementById('comment') && document.getElementById('comment').type == 'textarea') {
		myField = document.getElementById('comment');
	}
	else {
		return false;
	}
	if (document.selection) {
		myField.focus();
		sel = document.selection.createRange();
		sel.text = tag;
		myField.focus();
	}
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		var cursorPos = endPos;
		myField.value = myField.value.substring(0, startPos)
					  + tag
					  + myField.value.substring(endPos, myField.value.length);
		cursorPos += tag.length;
		myField.focus();
		myField.selectionStart = cursorPos;
		myField.selectionEnd = cursorPos;
	}
	else {
		myField.value += tag;
		myField.focus();
	}
}
<?php
	
	}
	
}

/******************************************************************************
 * - Define for bbPress interface
 *****************************************************************************/

$bbemoticons = & new bbEmoticons();

bb_add_filter('post_text', array(&$bbemoticons, 'convert_smilies'));
//bb_head is not called always. :-)
//bb_add_action('bb_head', array(&$bbemoticons, 'bb_grins_head'));
bb_add_action('bb_feed_head', array(&$bbemoticons, 'bb_grins_head'));
bb_add_action('bb_grins', array(&$bbemoticons, 'bb_grins'));

?>
