<?php
	$supported_image_types=array("jpg","jpeg","gif","png");
	
	function organizer_is_gif_readble(){
		$gd_info = gd_info();
		if (array_key_exists("GIF Read Support", $gd_info)) { 
		   return true; 
		}else{
		   return false; 
		}
	}

	function organizer_is_gif_editable(){
		$gd_info = gd_info();
		if (array_key_exists("GIF Create Support", $gd_info)) { 
		   return true; 
		}else{
		   return false; 
		}
	}

	function organizer_is_jpeg_editable(){
		$gd_info = gd_info();
		if (array_key_exists("JPG Support", $gd_info)) { 
		   return true; 
		}else{
		   return false; 
		}
	}

	function organizer_is_png_editable(){
		$gd_info = gd_info();
		if (array_key_exists("PNG Support", $gd_info)) { 
		   return true; 
		}else{
		   return false; 
		}
	}

	function organizer_image_type_editable($image_type){
		if($image_type=="gif"){
			return organizer_is_gif_editable();
		}elseif($image_type=="png"){
			return organizer_is_png_editable();
		}elseif($image_type=="jpg" || $image_type=="jpeg"){
			return organizer_is_jpeg_editable();
		}else{
			return false;
		}
	}
	
	function organizer_image_type_readble($image_type){
		if($image_type=="gif"){
			return organizer_is_gif_readble();
		}elseif($image_type=="png"){
			return organizer_is_png_editable();
		}elseif($image_type=="jpg" || $image_type=="jpeg"){
			return organizer_is_jpeg_editable();
		}else{
			return false;
		}
	}


	function organizer_is_file_image($filename){
		global $supported_image_types;
		if (in_array(organizer_get_image_type($filename), $supported_image_types)) { 
			return true;
		}else{
			return false;
		}
	}

	function organizer_get_image_type($filename){
		$file_info=pathinfo($filename);
		return strtolower($file_info['extension']);
	}

	function organizer_is_image_editable($path,$filename){
		global $supported_image_types;
		if($filename[0][write]){
			if(function_exists("gd_info")){
				if (organizer_is_file_image($filename[0][name])) { 
					if(organizer_image_type_editable(organizer_get_image_type($filename[0][name]))){
						return true;
					}else{
						return false;
					}
				}else{
					return false;
				}
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	function organizer_is_image_readable($path,$filename){
		global $supported_image_types;
		if(function_exists("gd_info")){
			if (organizer_is_file_image($filename[0][name])) { 
				if(organizer_image_type_readble(organizer_get_image_type($filename[0][name]))){
					return true;
				}else{
					return false;
				}
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
	
	function organizer_make_filename($path,$filename){
		if(substr($path,-1)=='/'){
			return $path.$filename;
		}else{
			return $path.'/'.$filename;
		}
	}
	
	function organizer_open_image_file($path,$filename){
		$image_file_type = organizer_get_image_type($filename);
		
		if($image_file_type=="gif"){
			 return imagecreatefromgif(organizer_make_filename($path,$filename)); 
		}elseif($image_file_type=="png"){
			 return imagecreatefrompng(organizer_make_filename($path,$filename)); 
		}elseif($image_file_type=="jpg" || $image_file_type=="jpeg"){
			 return imagecreatefromjpeg(organizer_make_filename($path,$filename)); 
		}
	}

	function organizer_save_image_file($path,$filename,$image_res){
		$image_file_type = organizer_get_image_type($filename);
		if($image_file_type=="gif"){
			 imagegif($image_res,organizer_make_filename($path,$filename));
			 @imagedestroy($image_res);
		}elseif($image_file_type=="png"){
			 imagepng($image_res,organizer_make_filename($path,$filename));
			 @imagedestroy($image_res);
		}elseif($image_file_type=="jpg" || $image_file_type=="jpeg"){
			 imagejpeg($image_res,organizer_make_filename($path,$filename),80);
			 @imagedestroy($image_res);
		}
	}

	function organizer_create_image($width,$height){
		if (function_exists("imagecreatetruecolor")){
			return imagecreatetruecolor($width,$height);
		}else{
			return imagecreate($width,$height);
		}
	}

	function organizer_resize_image($src_image,$resize_level){
		$open_image_width=imagesx($src_image);
		$open_image_height=imagesy($src_image);
		$resize_width=round($open_image_width * ($resize_level/100))!=0?round($open_image_width * ($resize_level/100)):1;
		$resize_height=round($open_image_height * ($resize_level/100))!=0?round($open_image_height * ($resize_level/100)):1;
		$new_resized_image=organizer_create_image($resize_width,$resize_height);
		if (function_exists("imagecreatetruecolor")){
			if (function_exists("imagecopyresampled")){
				imagecopyresampled ($new_resized_image,$src_image,0,0,0,0,$resize_width,$resize_height,$open_image_width,$open_image_height);
			}else{
				imagecopyresized ($new_resized_image,$src_image,0,0,0,0,$resize_width,$resize_height,$open_image_width,$open_image_height);
			}
		}else{
			imagecopyresized ($new_resized_image,$src_image,0,0,0,0,$resize_width,$resize_height,$open_image_width,$open_image_height);
		}
		return $new_resized_image;
	}

$mode=isset($_REQUEST['m'])?trim(strtolower($_REQUEST['m'])):'';
$path=isset($_REQUEST['p'])?$_REQUEST['p']:'';
$filename=isset($_REQUEST['f'])?$_REQUEST['f']:'';
$level=isset($_REQUEST['l'])?intval($_REQUEST['l']):100;
if($mode=='r'){
	$open_image=organizer_open_image_file($path,$filename);
	$white = imagecolorallocate($open_image , 255, 255, 255);
	imagefill($open_image, 0, 0, $white);
	$resized_image=organizer_resize_image($open_image,$level);
	header ("Content-type: image/jpeg"); 
	imagejpeg($resized_image,'',80); 
	@imagedestroy($open_image);
	@imagedestroy($resized_image);
	@imagedestroy($new_resized_image);
}elseif ($mode=='t'){
	$open_image=organizer_open_image_file($path,$filename);
	$width_orig=imagesx($open_image);
	$height_orig=imagesy($open_image);
	$width = 50;
	$height = 50;
	header('Content-type: image/jpeg');
	header('Content-Disposition: attachment; filename="thumb_'.$filename.'.jpg"');
	if ($width && ($width_orig < $height_orig)) {
	   $width = ($height / $height_orig) * $width_orig;
	} else {
	   $height = ($width / $width_orig) * $height_orig;
	}
	$image_p = organizer_create_image($width, $height);
	$white = imagecolorallocate($image_p , 255, 255, 255);
	imagefill($image_p, 0, 0, $white);
	imagecopyresampled($image_p, $open_image, 0, 0, 0, 0, $width, $height, $width_orig, $height_orig);
	imagejpeg($image_p, null, 80);	
	@imagedestroy($open_image);
	@imagedestroy($image_p);
}
?>