<?php

/*
Plugin Name: Maintenance Mode
Plugin URI: http://sw-guide.de/wordpress/maintenance-mode-plugin/
Description: Activate this plugin to make the site unavailable to everyone, except logged in users / admins. Please save the <a href="options-general.php?page=maintenance-mode.php"><strong>options</strong></a> when using this plugin the 1st time.
Version: 2.0
Author: Michael Woehrer
Author URI: http://sw-guide.de/
*/ 

/*	----------------------------------------------------------------------------
 	    ____________________________________________________
       |                                                    |
       |                 Maintenance Mode                   |
       |                © Michael Woehrer                   |
       |____________________________________________________|

	© Copyright 2006  Michael Woehrer  (michael dot woehrer at gmail dot com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

	----------------------------------------------------------------------------

	ACKNOWLEDGEMENTS
	- Thanks to Angsuman Chakraborty (http://blog.taragana.com/) for his plugin
	  "Site Unavailable".
	- Thanks to Frank Bueltge (http://bueltge.de/). He modified/extended the
	  "Site Unavailable" and I took his plugin and extended it. 

	----------------------------------------------------------------------------
*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	Load Translation file
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

load_plugin_textdomain('maintenance-mode',$path = 'wp-content/plugins/maintenance-mode');

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	Get options
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
$mw_maintenance_opt = get_option('plugin_maintenancemode');

if(	   !strstr($_SERVER['PHP_SELF'], 'feed/') 
	&& !strstr($_SERVER['PHP_SELF'], 'trackback/')
	&& !strstr($_SERVER['PHP_SELF'], 'wp-admin/') 
	&& !strstr($_SERVER['PHP_SELF'], 'wp-login.php')
	&& !in_array($_SERVER['REQUEST_URI'], explode(' ', $mw_maintenance_opt['mwmm_excludepaths']) )
	&& !mw_maintenance_is_user_logged()
	) {
		// Apply Maintenance Mode
		include('maintenance-mode_site.php');

	    exit();    

} elseif(strstr($_SERVER['PHP_SELF'], 'feed/') || strstr($_SERVER['PHP_SELF'], 'trackback/')) {
	// Special HTML header for feed and trackback
    $mm_backtime = intval($mm_opt['mwmm_backtime']) * 60;
    header("HTTP/1.0 503 Service Unavailable"); 
    header("Retry-After: $mm_backtime"); 
    exit();    
}


function mw_maintenance_is_user_logged() {
   /***********************************************
    Check if user is logged in 
   ***********************************************/

	global $mm_allow_logged_in_users, $mw_maintenance_opt;

	// For "get_currentuserinfo();". We need to include now since it is included only after plugins are being loaded	
	include (ABSPATH . WPINC . '/pluggable-functions.php');
	
	global $userdata;
	get_currentuserinfo();

	if ( intval($userdata->user_level) >= $mw_maintenance_opt['mwmm_minuserlevel']  ) {
		return true;
	} else {
		return false;
	}

}


/*******************************************************************************
 * Admin
*******************************************************************************/

// Add admin menu
function mw_maintenance_add_options_to_admin() {
    if (function_exists('add_options_page')) {
		add_options_page('Maintenance Mode', 'Maintenance Mode', 8, basename(__FILE__), 'mw_maintenance_mode_options_subpanel');
    }
}

// This will add the new item, 'Maintenance Mode', to the Options menu.
function mw_maintenance_mode_options_subpanel() {

	/* Lets add some default options if they don't exist
			If an option with the specified name already exists, no changes are made to its value
			or to the database as a whole. add_option() can only add options, not alter them.*/

	$tmp_langmessage = '<h1>Maintenance Mode</h1>
<p><a title="[blogtitle]" href="[blogurl]">[blogtitle]</a> is currently undergoing scheduled maintenance.<br />
Please try back <strong>in [backtime] minutes</strong>.</p>
<p>Sorry for the inconvenience.</p>';
	$tmp_langaltmessage = '<h1>Wartungsmodus</h1>
<p>Derzeit werden auf <a title="[blogtitle]" href="[blogurl]">[blogtitle]</a> Wartungsarbeiten durchgef&uuml;hrt.<br />
Bitte versuchen Sie es <strong>in [backtime] Minuten</strong> nochmal.</p>
<p>Vielen Dank f&uuml;r Ihr Verst&auml;ndnis.</p>';
	$optionarray_def = array(
		'mwmm_excludepaths' => '',
		'mwmm_backtime' => '60',
		'mwmm_minuserlevel' => '10',
		'mwmm_langtitle' => 'Maintenance Mode',
		'mwmm_langmessage' => $tmp_langmessage,
		'mwmm_applyaltlang' => '',
		'mwmm_langalttitle' => 'Wartungsmodus',
		'mwmm_langaltmessage' => $tmp_langaltmessage,
		);
	add_option('plugin_maintenancemode', $optionarray_def, 'Link Indication Plugin Options');

	/* Check form submission and update options if no error occurred */
	if (isset($_POST['submit']) ) {
		$optionarray_update = array (
			'mwmm_excludepaths' => mw_maintenance_txtLineBreakToWhiteSpace($_POST['mwmm_excludepaths']),
			'mwmm_backtime' => $_POST['mwmm_backtime'],
			'mwmm_minuserlevel' => $_POST['mwmm_minuserlevel'],
			'mwmm_langtitle' => $_POST['mwmm_langtitle'],
			'mwmm_langmessage' => $_POST['mwmm_langmessage'],
			'mwmm_applyaltlang' => $_POST['mwmm_applyaltlang'],
			'mwmm_langalttitle' => $_POST['mwmm_langalttitle'],
			'mwmm_langaltmessage' => $_POST['mwmm_langaltmessage'],
		);
		update_option('plugin_maintenancemode', $optionarray_update);

	}

	/* Get options */
	$optionarray_def = get_option('plugin_maintenancemode');

	
?>
<div class=wrap>

	<h2><?php _e('Maintenance Mode Options','maintenance-mode') ?></h2>

	<form name="form1" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?page=maintenance-mode.php&updated=true">

	<fieldset class="options"> 
		<legend><?php _e('General settings','maintenance-mode') ?></legend>
		<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr valign="center"> 
			<th width="170px" scope="row"><label for="mwmm_backtime"><?php _e('Backtime in minutes:','maintenance-mode') ?></label></th> 
			<td width="30px"><input name="mwmm_backtime" type="text" id="mwmm_backtime" value="<?php echo $optionarray_def['mwmm_backtime']; ?>" size="3" /></td> 
			<td style="color: #555; font-size: .85em;"><?php _e('Hint to the visitors to retry after the time in minutes.','maintenance-mode') ?></td>
		</tr> 
		<tr valign="center"> 
			<th scope="row"><label for="mwli_mailto"><?php _e('Minimum user level:','maintenance-mode') ?></label></th> 
			<td>
				<select name="mwmm_minuserlevel" id="mwmm_minuserlevel">
					<option value="10"<?php if ('10' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>10 <?php _e('(admin)','maintenance-mode') ?></option>
					<option value="9"<?php if ('9' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>9</option>
					<option value="8"<?php if ('8' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>8</option>
					<option value="7"<?php if ('7' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>7</option>
					<option value="6"<?php if ('6' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>6</option>
					<option value="5"<?php if ('5' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>5</option>
					<option value="4"<?php if ('4' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>4</option>
					<option value="3"<?php if ('3' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>3</option>
					<option value="2"<?php if ('2' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>2</option>
					<option value="1"<?php if ('1' == $optionarray_def['mwmm_minuserlevel']) echo ' selected="selected"'; ?>>1</option>
				</select>
			</td> 
			<td style="color: #555; font-size: .85em;"><?php _e('(The minimum user level to view/edit the frontend, for details regarding user levels see <a target="_blank" href="http://codex.wordpress.org/User_Levels">WordPress Codex: User Levels</a>.)','maintenance-mode') ?></td>
		</tr>
		</table>
	</fieldset>

	<fieldset class="options">
		<legend><?php _e('Message:','maintenance-mode') ?></legend>
		<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr valign="center"> 
			<th width="170px" scope="row"><label for="mwmm_langtitle"><?php _e('Title:','maintenance-mode') ?></label></th> 
			<td width="500px"><input name="mwmm_langtitle" type="text" id="mwmm_langtitle" value="<?php echo htmlspecialchars(stripslashes($optionarray_def['mwmm_langtitle'])); ?>" size="40" /></td>
		</tr>
		<tr valign="top"> 
			<th width="170px" scope="row"><label for="mwmm_langmessage"><?php _e('Message:','maintenance-mode') ?></label></th> 
			<td width="500px"><textarea style="font-size: 90%" name="mwmm_langmessage" id="mwmm_langmessage" cols="100%" rows="5" ><?php echo htmlspecialchars(stripslashes($optionarray_def['mwmm_langmessage'])); ?></textarea>
			<p style="color: #555; font-size: .85em;"><?php _e('Use HTML only, no PHP allowed. You can use <strong>[blogurl]</strong>, <strong>[blogtitle]</strong> and <strong>[backtime]</strong> as placeholders.','maintenance-mode') ?></p>
			</td>
		</tr>
		</table>

	</fieldset>

	<fieldset class="options">
		<legend><?php _e('Second language','maintenance-mode') ?></legend>
		<p style="margin-left: 25px;">
			<input name="mwmm_applyaltlang" type="checkbox" id="mwmm_applyaltlang" value="1" <?php checked('1', $optionarray_def["mwmm_applyaltlang"]); ?>"  /> 
			<label for="mwmm_applyaltlang"><?php _e('Apply second language','maintenance-mode') ?></label>		
		</p>
		
		<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr valign="center"> 
			<th width="170px" scope="row"><label for="mwmm_langalttitle"><?php _e('Title:','maintenance-mode') ?></label></th> 
			<td width="500px"><input name="mwmm_langalttitle" type="text" id="mwmm_langalttitle" value="<?php echo htmlspecialchars(stripslashes($optionarray_def['mwmm_langalttitle'])); ?>" size="40" /></td>
		</tr>
		<tr valign="top"> 
			<th width="170px" scope="row"><label for="mwmm_langaltmessage"><?php _e('Message:','maintenance-mode') ?></label></th> 
			<td width="500px"><textarea style="font-size: 90%" name="mwmm_langaltmessage" id="mwmm_langaltmessage" cols="100%" rows="5" ><?php echo htmlspecialchars(stripslashes($optionarray_def['mwmm_langaltmessage'])); ?></textarea>
			<p style="color: #555; font-size: .85em;"><?php _e('Use HTML only, no PHP allowed. You can use <strong>[blogurl]</strong>, <strong>[blogtitle]</strong> and <strong>[backtime]</strong> as placeholders.','maintenance-mode') ?></p>
			</td>
		</tr>
		</table>
	</fieldset>

	<fieldset class="options">
		<legend><?php _e('Paths to be still accessable:','maintenance-mode') ?></legend>
		<p style="margin-left: 25px; color: #555; font-size: .85em;">
			<?php _e('Enter paths that shall be excluded and still be accessable. Separate multiple paths with line breaks.<br />','maintenance-mode') ?>
			<?php _e('Example: If you want to exclude <em>http://site.com/about/</em>, then enter <em>/about/</em>','maintenance-mode') ?>
		</p>
		<textarea style="margin-left: 25px" name="mwmm_excludepaths" id="mwmm_excludepaths" cols="100%" rows="2" ><?php echo mw_maintenance_txtWhiteSpaceToLineBreak($optionarray_def['mwmm_excludepaths']); ?></textarea>
	</fieldset>

	<div class="submit">
		<input type="submit" name="submit" value="<?php _e('Update Options','maintenance-mode') ?> &raquo;" />
	</div>

	</form>
	<p style="text-align: center; font-size: .85em;">&copy; Copyright 2006&nbsp;&nbsp;<a href="http://sw-guide.de">Michael W&ouml;hrer</a></p>

</div> <!-- [wrap] -->

<?php


} // mw_maintenance_mode_options_subpanel



/* =============================================================================
   Auxiliary admin functions
============================================================================= */


// **** Converts textarea content (separated by line break) to space separated string
//		since we want to store it like this in MySQL
function mw_maintenance_txtLineBreakToWhiteSpace($input) {

	// Remove white spaces
	$input = str_replace(' ', '', $input);

	// Replace linebreaks with white space, considering both \n and \r
	$input = preg_replace("/\r|\n/s", ' ', $input);

	// Create result. We create an array and loop thru it but do not consider empty values. 
	$sourceArray = explode(' ', $input);
	$loopcount = 0;
	$result = '';
	foreach ($sourceArray as $loopval) {

		if ($loopval <> '') {

			// Create separator
			$sep = '';
			if ($loopcount >= 1) $sep = ' ';
			
			// result
			$result .= $sep . $loopval;
		
			$loopcount++;				
		}
	}
	return $result;

}


// *** Replace white space with new line for displaying in text area
function mw_maintenance_txtWhiteSpaceToLineBreak($input) {

	$output = str_replace(' ', "\n", $input);
	
	return $output;

}

/* =============================================================================
   Apply the admin menu
============================================================================= */

add_action('admin_menu', 'mw_maintenance_add_options_to_admin');




?>