package sql.diff;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.engine.DifferenceInStructureRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.resource.DBResourceType;

import java.io.File;

public class HelloDiff {

	static File macConnections = new File(
			"/Users/yonsama/tools/eclipse36/wk/WolfSQLParser/config/");
	static File winConnections = new File(
			"C:/Users/yoshioka/Desktop/WolfDBManager2-v0_9_3_b/w_config");

	protected ConnectionProperties diff_1_con_properties = null;
	protected ConnectionProperties diff_2_con_properties = null;
	protected DatabaseType databaseTypeFrom;
	protected DatabaseType databaseTypeTo;
	protected ConnectionSettingBean bean = null;

	public static void main(String[] args) {
		HelloDiff obj = new HelloDiff();
		obj.doWork();
	}

	private void doWork() {
		try {
			this.connect();
			DifferenceInStructureRequest request = new DifferenceInStructureRequest(
					diff_1_con_properties, diff_2_con_properties);
			request.addResourceType(DBResourceType.TABLE);
			request.addResourceType(DBResourceType.VIEW);
			request.addResourceType(DBResourceType.SEQUENCE);
			boolean ret = SQLServerThread.runNowThisRequest(request);
			System.out.println("ret:" + ret);
			System.out.println("catalog:" + request.getDiffCatalog());
			// request.getDiffCatalog().
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				this.disconnect();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}

	protected void connect() throws Exception {
		if (hiro.yoshioka.util.Util.isWindowsOs()) {
			SQLServerThread.getSQLServer().init(winConnections);
		} else {
			SQLServerThread.getSQLServer().init(macConnections);
		}
		this.bean = SQLServerThread.getSQLServer().getConnectionSettingBean();
		diff_1_con_properties = bean
				.getConnectionPropertiesByDisplay("cm_treasurebox");
		diff_2_con_properties = bean
				.getConnectionPropertiesByDisplay("local_treasurebox");

		databaseTypeFrom = diff_1_con_properties.getDatabaseType();
		databaseTypeTo = diff_2_con_properties.getDatabaseType();

		Request request = new Request(SQLOperationType.CONNECT,
				diff_1_con_properties);

		SQLServerThread.runNowThisRequest(request);
		request = new Request(SQLOperationType.CONNECT, diff_2_con_properties);

		SQLServerThread.runNowThisRequest(request);

	}

	protected void disconnect() throws Exception {
		Request request = new Request(SQLOperationType.CLOSE,
				diff_1_con_properties);
		SQLServerThread.runNowThisRequest(request);
		request = new Request(SQLOperationType.CLOSE, diff_2_con_properties);
		SQLServerThread.runNowThisRequest(request);
		SQLServerThread.getSQLServer().dispose();
	}

}
