package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfRichTextRange extends AbsWolfDominoReflection {
	private Method getTextParagraph;
	private Method getTextRun;
	private Method getNavigator;
	private Method setBegin;
	private Method setEnd;
	private Method getStyle;

	public WolfRichTextRange(ClassManager classManager, Object instance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException, IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		super(classManager, instance);
		Class dominoBaseClazz = classManager
				.getClassForName("lotus.domino.Base");
		setBegin = targetInstance.getClass().getMethod("setBegin",
				dominoBaseClazz);

		setEnd = targetInstance.getClass().getMethod("setEnd", dominoBaseClazz);

		getNavigator = targetInstance.getClass().getMethod("getNavigator");

		getTextParagraph = targetInstance.getClass().getMethod(
				"getTextParagraph");

		getTextRun = targetInstance.getClass().getMethod("getTextRun");

		getStyle = targetInstance.getClass().getMethod("getStyle");
	}

	public String getTextParagraph() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getTextParagraph.invoke(targetInstance);
	}

	public String getTextRun() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getTextRun.invoke(targetInstance);
	}

	public void setBegin(WolfRichTextNavigator navigator)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		setBegin.invoke(targetInstance, navigator.getTargetInstance());
	}

	public void setEnd(WolfRichTextNavigator navigator)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		setEnd.invoke(targetInstance, navigator.getTargetInstance());
	}

	public WolfRichTextStyle getStyle() throws MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException,
			IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		Object instance = getStyle.invoke(targetInstance);
		if (instance == null) {
			return null;
		}

		return new WolfRichTextStyle(classManager, instance);

	}

	public WolfRichTextNavigator getNavigator() throws MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException,
			IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		Object instance = getNavigator.invoke(targetInstance);
		if (instance == null) {
			return null;
		}

		return new WolfRichTextNavigator(classManager, instance);

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.RichTextRange";
	}

}
