package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfRichTextNavigator extends AbsWolfDominoReflection {
	Method createRange;
	Method findFirstElement;
	Method findNthElement;
	Method findNextElement;
	Method findNextElement2;
	Method getElement;

	public WolfRichTextNavigator(ClassManager classManager, Object instance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, instance);
		findFirstElement = targetInstance.getClass().getMethod(
				"findFirstElement", int.class);

		findNthElement = targetInstance.getClass().getMethod("findNthElement",
				int.class, int.class);
		findNextElement = targetInstance.getClass()
				.getMethod("findNextElement");
		findNextElement2 = targetInstance.getClass().getMethod(
				"findNextElement", int.class);
		getElement = targetInstance.getClass().getMethod("getElement");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.RichTextNavigator";
	}

	public WolfEmbeddedObject getEmbeddedElement()
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {
		Object instance = getElement.invoke(targetInstance);
		if (instance == null) {
			return null;
		}

		return new WolfEmbeddedObject(classManager, instance);

	}

	public void setPositionAtEnd() throws ClassNotFoundException,
			IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, SecurityException, NoSuchMethodException {
		Class clazz = Class.forName("lotus.domino.Base");
		Method setPositionAtEnd = targetInstance.getClass().getMethod(
				"setPositionAtEnd", clazz);
		setPositionAtEnd.invoke(targetInstance, getTargetInstance());
	}

	public boolean findFirstElement(int type) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) findFirstElement.invoke(targetInstance, type);
	}

	public boolean findNthElement(int type, int num)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		return (Boolean) findNthElement.invoke(targetInstance, type, num);
	}

	public boolean findNextElement() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) findNextElement.invoke(targetInstance);
	}

	public boolean findNextElement(int type) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) findNextElement2.invoke(targetInstance, type);
	}

	public WolfRichTextRange createRange() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = createRange.invoke(targetInstance);
		if (instance == null) {
			return null;
		}

		return new WolfRichTextRange(classManager, instance);

	}

	@Override
	public String toString() {
		try {
			return String.format("WolfRichTextNavigator ");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "WolfRichTextNavigator";
	}

}
