package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.resource.notes.ItemType;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Region extends PardefElement implements Serializable {

	private static final long serialVersionUID = -3765270692733240554L;
	String href, targetframe;
	Boolean showborder;
	Font font;

	public Region(Node atts) {
		NamedNodeMap names = atts.getAttributes();
		href = Form.getAttrValueString(names, "href");
		targetframe = Form.getAttrValueString(names, "targetframe");
		this.showborder = Form.getAttrValueBoolean(names, "showborder");
		Node n = atts.getFirstChild();
		if ("run".equals(n.getNodeName())) {
			parseRun(n);
		} else {
			n = atts.getLastChild();
			if ("run".equals(n.getNodeName())) {
				parseRun(n);
			}
		}
	}

	private void parseRun(Node run) {
		NodeList list = run.getChildNodes();

		for (int i = 0; i < list.getLength(); i++) {
			Node child = list.item(i);
			if ("font".equals(child.getNodeName())) {
				font = new Font(child);
			} else if (Node.TEXT_NODE == child.getNodeType()) {
				if (child.getTextContent().replaceAll("[\r\n]", "").trim()
						.length() > 0) {
					if (font != null) {
						font.setCharactor(child.getTextContent());
					}
				}
			} else {
				System.out.println("     ??UrlLink#parseRun#child="
						+ child.getNodeName());
			}
		}
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row, File imgDir) {
		StringBuilder sb = new StringBuilder();
		if (showborder != null && showborder.booleanValue()) {
			sb.append(String.format(
					"<a href='%s' style='border:solid 1px teal;' >", href));
		} else {
			sb.append(String.format("<a href='%s'  >", href));
		}
		if (font != null) {
			sb.append(font.itemToHtmlString());
		}
		sb.append("</a>");
		return sb.toString();
	}

	@Override
	public String itemToHtmlString() {
		return toHtmlString(null, 0, null);

	}
}
