import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.FileMakerSQL;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.GettingResourceRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.params.DBResourceCapturingFilter;
import hiro.yoshioka.sql.params.DBUserPass;

import java.io.File;

import org.omg.IOP.TransactionService;

public class FileMakerMetaTest {
	static File winConnections = new File(
			"D:/tools/pleiades-e3.7_wolf/eclipse/w_config");

	public static void main(java.lang.String[] args) {
		ConnectionProperties p = new ConnectionProperties();

		// dom
		p.setHost("localhost");
		p.setAuthenticate(new DBUserPass("yuko admin", "password"));

		p.setCaptureWithDDL(false);
		p.setCaptureWithColumnInfo(false);
		p.setCaptureWithViewInfo(false);

		p.setCapturingFilter(DBResourceCapturingFilter.MATCHES);
		// p.addFilePathRegrex(".*hoge.*");
		ClassManager cm = new ClassManager();
		try {
			cm.add_lib(new File("D:/tools/jdbc/fmjdbc.jar"));

			SQLServerThread.getSQLServer().init(winConnections);

			ConnectionSettingBean bean = SQLServerThread.getSQLServer()
					.getConnectionSettingBean();
			p = bean.getConnectionPropertiesByDisplay("ファイルメーカ");

			Request request = new Request(SQLOperationType.CONNECT, p);
			SQLServerThread.runNowThisRequest(request);

			ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(p);

			FileMakerSQL fsql = ((FileMakerSQL)sql);

			fsql.test();

			request = new Request(SQLOperationType.CLOSE, p);
			SQLServerThread.runNowThisRequest(request);

		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} finally {
			SQLServerThread.getSQLServer().dispose();
		}
	}
}
