/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import com.thoughtworks.selenium.webdriven.commands.SeleniumSelect;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class FindFirstSelectedOptionProperty
extends SeleneseCommand<String> {
    private final JavascriptLibrary library;
    private final ElementFinder finder;
    private final String property;

    public FindFirstSelectedOptionProperty(JavascriptLibrary library, ElementFinder finder, String property) {
        this.library = library;
        this.finder = finder;
        this.property = property;
    }

    @Override
    protected String handleSeleneseCommand(WebDriver driver, String selectLocator, String ignored) {
        SeleniumSelect select = new SeleniumSelect(this.library, this.finder, driver, selectLocator);
        List<WebElement> allOptions = select.getSelectedOptions();
        if (allOptions.isEmpty()) {
            throw new SeleniumException("No options are selected: " + selectLocator);
        }
        return allOptions.get(0).getAttribute(this.property);
    }
}

