/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.web.Container;

public class RESTServlet
extends HttpServlet {
    static final Map<String, String> DEFAULT_METHOD = new HashMap<String, String>();
    static final Set<String> DEFAULT_VERB = new HashSet<String>();
    protected Container container;
    Config config;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String configText = servletConfig.getInitParameter("config");
        JSON json = new JSON();
        if (configText == null) {
            HashMap map = new HashMap();
            Enumeration e = (Enumeration)Container.cast(servletConfig.getInitParameterNames());
            while (e.hasMoreElements()) {
                map.put(e.nextElement(), servletConfig.getInitParameter((String)e.nextElement()));
            }
            configText = json.format(map);
        }
        try {
            this.config = json.parse((CharSequence)configText, Config.class);
            if (this.config.container == null) {
                this.config.container = Container.class;
            }
            this.container = json.parse((CharSequence)configText, this.config.container);
            this.container.init(this);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (this.config.definitions == null) {
            this.config.definitions = new HashMap<String, Pattern>();
        }
        if (!this.config.definitions.containsKey("package")) {
            this.config.definitions.put("package", Pattern.compile(".+"));
        }
        if (this.config.errors == null) {
            this.config.errors = Collections.emptyMap();
        }
        if (this.config.method == null) {
            this.config.method = DEFAULT_METHOD;
        }
        if (this.config.verb == null) {
            this.config.verb = DEFAULT_VERB;
        }
        if (this.config.mappings == null) {
            this.config.mappings = Collections.emptyMap();
        }
        for (Map.Entry<String, RouteMapping> entry : this.config.mappings.entrySet()) {
            entry.getValue().init(entry.getKey(), this.config);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doREST(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doREST(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doREST(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doREST(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doREST(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doREST(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doREST(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getContextPath().equals("/") ? request.getRequestURI() : request.getRequestURI().substring(request.getContextPath().length());
        Route route = null;
        for (RouteMapping m : this.config.mappings.values()) {
            route = m.matches(request, uri);
            if (route == null) continue;
            this.container.debug("Route found: " + request.getMethod() + " " + uri);
            break;
        }
        if (route == null) {
            response.sendError(404, "Not Found");
            return;
        }
        if (route.getHttpMethod() == null || route.getRestMethod() == null) {
            this.container.debug("Method mapping not found: " + route.getHttpMethod());
            response.sendError(405, "Method Not Allowed");
            return;
        }
        int status = 200;
        String callback = null;
        LinkedHashMap<String, Object> result = null;
        if ("GET".equals(request.getMethod())) {
            callback = route.getParameter("callback");
        } else if ("POST".equals(route.getHttpMethod())) {
            status = 201;
        }
        this.container.start(request, response);
        JSON json = this.container.createJSON(request.getLocale());
        try {
            String className = route.getComponentClass(this.container);
            Object component = this.container.getComponent(className);
            if (component == null) {
                throw new ClassNotFoundException("Component not found: " + className);
            }
            List<Map<?, ?>> params = null;
            if (Container.isJSONType(request.getContentType())) {
                Object o = json.parse(request.getReader());
                if (o instanceof List) {
                    params = (List)Container.cast(o);
                    if (params.isEmpty()) {
                        params = new ArrayList(1);
                        params.add(route.getParameterMap());
                    } else if (params.get(0) instanceof Map) {
                        params.set(0, route.mergeParameterMap((Map)params.get(0)));
                    }
                } else {
                    if (!(o instanceof Map)) throw new IllegalArgumentException("failed to convert parameters from JSON.");
                    params = new ArrayList(1);
                    params.add(route.mergeParameterMap((Map)o));
                }
            } else {
                params = new ArrayList(1);
                params.add(route.getParameterMap());
            }
            Method method = this.container.getMethod(component, route.getRestMethod(), params);
            if (method == null) {
                throw new NoSuchMethodException("Method not found: " + route.getRestMethod());
            }
            json.setContext(component);
            result = this.container.execute(json, component, method, params);
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                this.container.debug("Class Not Found.", e);
                response.sendError(404, "Not Found");
                response.flushBuffer();
            } else if (e instanceof NoSuchMethodException) {
                this.container.debug("Method Not Found.", e);
                response.sendError(404, "Not Found");
                response.flushBuffer();
            } else if (e instanceof JSONException) {
                this.container.debug("Fails to parse JSON.", e);
                response.sendError(400, "Bad Request");
                response.flushBuffer();
            } else if (e instanceof InvocationTargetException) {
                Throwable cause = e.getCause();
                this.container.debug("Cause error on invocation.", cause);
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof IllegalStateException || cause instanceof UnsupportedOperationException) {
                    response.sendError(404, "Not Found");
                    response.flushBuffer();
                } else if (cause instanceof IllegalArgumentException) {
                    response.sendError(400, "Bad Request");
                    response.flushBuffer();
                } else {
                    Integer errorCode = null;
                    for (Map.Entry<String, Integer> entry : this.config.errors.entrySet()) {
                        Class<?> cls = ClassUtil.findClass(entry.getKey());
                        if (!cls.isAssignableFrom(cause.getClass()) || entry.getValue() == null) continue;
                        errorCode = entry.getValue();
                        break;
                    }
                    if (errorCode != null) {
                        response.setStatus(errorCode.intValue());
                        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
                        error.put("name", cause.getClass().getSimpleName());
                        error.put("message", cause.getMessage());
                        error.put("data", cause);
                        result = error;
                    } else {
                        response.sendError(500, "Internal Server Error");
                        response.flushBuffer();
                    }
                }
            } else {
                this.container.error("Internal error occurred.", e);
                response.sendError(500, "Internal Server Error");
                response.flushBuffer();
            }
        }
        finally {
            this.container.end(request, response);
        }
        if (response.isCommitted()) {
            return;
        }
        if (result == null || result instanceof CharSequence || result instanceof Boolean || result instanceof Number || result instanceof Date) {
            if (status != 201) {
                status = 204;
            }
            response.setStatus(status);
            return;
        } else {
            response.setContentType(callback != null ? "text/javascript" : "application/json");
            PrintWriter writer = response.getWriter();
            json.setPrettyPrint(this.container.isDebugMode());
            if (callback != null) {
                ((Writer)writer).append(callback).append("(");
            }
            json.format((Object)result, writer);
            if (callback == null) return;
            ((Writer)writer).append(");");
        }
    }

    public void destroy() {
        this.container.destory();
        super.destroy();
    }

    static {
        DEFAULT_METHOD.put("GET", "find");
        DEFAULT_METHOD.put("POST", "create");
        DEFAULT_METHOD.put("PUT", "update");
        DEFAULT_METHOD.put("DELETE", "delete");
        DEFAULT_VERB.add("HEAD");
        DEFAULT_VERB.add("GET");
        DEFAULT_VERB.add("POST");
        DEFAULT_VERB.add("PUT");
        DEFAULT_VERB.add("DELETE");
        DEFAULT_VERB.add("OPTIONS");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Route {
        static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        String target;
        String httpMethod;
        String restMethod;
        Map<Object, Object> params;

        public Route(String httpMethod, String restMethod, String target, Map<String, Object> params) throws IOException {
            this.httpMethod = httpMethod;
            this.restMethod = restMethod;
            this.target = target;
            this.params = (Map)Container.cast(params);
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String getRestMethod() {
            return this.restMethod;
        }

        public String getParameter(String name) {
            List list;
            Map map;
            Object o = this.params.get(name);
            if (o instanceof Map && (map = (Map)o).containsKey(null)) {
                o = map.get(null);
            }
            if (o instanceof List && !(list = (List)o).isEmpty()) {
                o = list.get(0);
            }
            return o instanceof String ? (String)o : null;
        }

        public Map<?, ?> getParameterMap() {
            return this.params;
        }

        public String getComponentClass(Container container) {
            Matcher m = REPLACE_PATTERN.matcher(this.target);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String key = m.group(1);
                String value = this.getParameter(key);
                if (key.equals("class") && container.namingConversion) {
                    value = ClassUtil.toUpperCamel(value);
                } else if (key.equals("package")) {
                    value = value.replace('/', '.');
                }
                m.appendReplacement(sb, value != null ? value : "");
            }
            m.appendTail(sb);
            return sb.toString();
        }

        public Map<?, ?> mergeParameterMap(Map<?, ?> newParams) {
            for (Map.Entry<?, ?> entry : newParams.entrySet()) {
                if (this.params.containsKey(entry.getKey())) {
                    Object target = this.params.get(entry.getKey());
                    if (target instanceof Map) {
                        Map map = (Map)target;
                        if (map.containsKey(null)) {
                            target = map.get(null);
                            if (target instanceof List) {
                                ((List)target).add(entry.getValue());
                                continue;
                            }
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(target);
                            list.add(entry.getValue());
                            map.put(null, list);
                            continue;
                        }
                        map.put(null, entry.getValue());
                        continue;
                    }
                    if (target instanceof List) {
                        ((List)target).add(entry.getValue());
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(target);
                    list.add(entry.getValue());
                    this.params.put(entry.getKey(), list);
                    continue;
                }
                this.params.put(entry.getKey(), entry.getValue());
            }
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RouteMapping {
        static final Pattern PLACE_PATTERN = Pattern.compile("\\{\\s*(\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}\\.-]*)\\s*(?::\\s*((?:[^{}]|\\{[^{}]*\\})*)\\s*)?\\}");
        static final Pattern DEFAULT_PATTERN = Pattern.compile("[^/().]+");
        public String target;
        public Map<String, String> method;
        public Set<String> verb;
        Config config;
        Pattern pattern;
        List<String> names;

        public void init(String path, Config config) {
            this.config = config;
            this.names = new ArrayList<String>();
            StringBuffer sb = new StringBuffer("^\\Q");
            Matcher m = PLACE_PATTERN.matcher(path);
            while (m.find()) {
                Pattern p;
                String name = m.group(1);
                this.names.add(name);
                Pattern pattern = p = m.group(2) != null ? Pattern.compile(m.group(2)) : null;
                if (p == null && config.definitions.containsKey(name)) {
                    p = config.definitions.get(name);
                }
                if (p == null) {
                    p = DEFAULT_PATTERN;
                }
                m.appendReplacement(sb, "\\\\E(" + p.pattern().replaceAll("\\((?!\\?)", "(?:").replace("\\", "\\\\") + ")\\\\Q");
            }
            m.appendTail(sb);
            sb.append("\\E$");
            this.pattern = Pattern.compile(sb.toString());
        }

        public Route matches(HttpServletRequest request, String path) throws IOException {
            Matcher m = this.pattern.matcher(path);
            if (m.matches()) {
                HashMap<Object, Object> params = new HashMap<Object, Object>();
                for (int i = 0; i < this.names.size(); ++i) {
                    String key = this.names.get(i);
                    String value = m.group(i + 1);
                    if (params.containsKey(key)) {
                        Object target = params.get(key);
                        if (target instanceof List) {
                            ((List)target).add(value);
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>(2);
                        list.add(target);
                        list.add(value);
                        continue;
                    }
                    params.put(key, value);
                }
                String httpMethod = request.getParameter("_method");
                if (httpMethod == null) {
                    httpMethod = request.getMethod();
                }
                if (httpMethod != null) {
                    httpMethod = httpMethod.toUpperCase();
                }
                if (this.verb != null && !this.verb.contains(httpMethod)) {
                    httpMethod = null;
                } else if (!this.config.verb.contains(httpMethod)) {
                    httpMethod = null;
                }
                Object restMethod = params.get("method");
                if (restMethod instanceof List) {
                    List list = (List)restMethod;
                    Object v0 = (restMethod = !list.isEmpty() ? list.get(0) : null);
                }
                if (restMethod == null && this.method != null) {
                    restMethod = this.method.get(httpMethod);
                }
                if (restMethod == null) {
                    restMethod = this.config.method.get(httpMethod);
                }
                RouteMapping.parseParameter(request.getParameterMap(), params);
                return new Route(httpMethod, (String)restMethod, this.target, params);
            }
            return null;
        }

        static void parseParameter(Map<String, String[]> pairs, Map<Object, Object> params) {
            for (Map.Entry<String, String[]> entry : pairs.entrySet()) {
                String name = entry.getKey();
                boolean multiValue = false;
                if (name.endsWith("[]")) {
                    name = name.substring(0, name.length() - 2);
                    multiValue = true;
                }
                String[] values = entry.getValue();
                int start = 0;
                int old = 0;
                LinkedHashMap<String, Object> current = params;
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (c == '.' || c == '[') {
                        String key = name.substring(start, old == 93 ? i - 1 : i);
                        Object target = current.get(key);
                        if (target instanceof Map) {
                            current = (LinkedHashMap<String, Object>)target;
                        } else {
                            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                            if (target != null) {
                                map.put(null, target);
                            }
                            current.put(key, map);
                            current = map;
                        }
                        start = i + 1;
                    }
                    old = c;
                }
                name = name.substring(start, old == 93 ? name.length() - 1 : name.length());
                Object key = name;
                if (name.length() > 0 && name.charAt(0) >= '0' && name.charAt(0) >= '9') {
                    try {
                        key = new BigDecimal(name);
                    }
                    catch (Exception e) {
                        key = name;
                    }
                }
                if (current.containsKey(key)) {
                    ArrayList<Object> list;
                    Object target = current.get(key);
                    if (target instanceof Map) {
                        List<String> list2;
                        Map map = (Map)target;
                        if (map.containsKey(null)) {
                            target = map.get(null);
                            if (target instanceof List) {
                                list2 = (List)target;
                                for (String value : values) {
                                    list2.add(value);
                                }
                                continue;
                            }
                            list2 = new ArrayList(values.length + 1);
                            list2.add((String)target);
                            for (String value : values) {
                                list2.add(value);
                            }
                            map.put(null, list2);
                            continue;
                        }
                        if (multiValue || values.length > 1) {
                            list2 = new ArrayList(values.length);
                            for (String value : values) {
                                list2.add(value);
                            }
                            map.put(null, list2);
                            continue;
                        }
                        map.put(null, values.length > 0 ? values[0] : null);
                        continue;
                    }
                    if (target instanceof List) {
                        list = (ArrayList<Object>)target;
                        for (String value : values) {
                            list.add(value);
                        }
                        continue;
                    }
                    list = new ArrayList<Object>(values.length + 1);
                    list.add(target);
                    for (String value : values) {
                        list.add(value);
                    }
                    current.put((String)key, list);
                    continue;
                }
                if (multiValue || values.length > 1) {
                    ArrayList<String> list = new ArrayList<String>(values.length);
                    for (String value : values) {
                        list.add(value);
                    }
                    current.put((String)key, list);
                    continue;
                }
                current.put((String)key, values.length > 0 ? values[0] : null);
            }
        }
    }

    static class Config {
        public Class<? extends Container> container;
        @JSONHint(anonym="target")
        public Map<String, RouteMapping> mappings;
        public Map<String, Pattern> definitions;
        public Map<String, Integer> errors;
        public Map<String, String> method;
        public Set<String> verb;

        Config() {
        }
    }
}

