/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardTemplateChoicePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.ide.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewReportWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewReportWizard.text.OpenFileForEditing");
    private static final String CREATING = Messages.getString((String)"NewReportWizard.text.Creating");
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewReportWizard.displayName.NewReportFileNamePrefix");
    private static final String NEW_REPORT_FILE_EXTENSION = Messages.getString((String)"NewReportWizard.displayName.NewReportFileExtension");
    private static final String SELECT_A_REPORT_TEMPLATE = Messages.getString((String)"NewReportWizard.text.SelectTemplate");
    private static final String CREATE_A_NEW_REPORT = Messages.getString((String)"NewReportWizard.text.CreateReport");
    String REPORT = Messages.getString((String)"NewReportWizard.title.Report");
    private static final String TEMPLATECHOICEPAGE = Messages.getString((String)"NewReportWizard.title.Template");
    private static final String WIZARDPAGE = Messages.getString((String)"NewReportWizard.title.WizardPage");
    private static final String NEW = Messages.getString((String)"NewReportWizard.title.New");
    private IStructuredSelection selection;
    WizardNewReportCreationPage newReportFileWizardPage;
    WizardReportSettingPage settingPage;
    private WizardTemplateChoicePage templateChoicePage;
    private int UNIQUE_COUNTER = 0;
    private String fileExtension = "rptdesign";
    private static final List<Boolean> tmpList = new ArrayList<Boolean>();
    private IConfigurationElement configElement;

    public NewReportWizard() {
    }

    public NewReportWizard(String fileType) {
        this.fileExtension = fileType;
    }

    public boolean performFinish() {
        final IPath containerName = this.newReportFileWizardPage.getContainerFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        final String fileName = !Platform.getOS().equals("win32") ? (!fn.endsWith("." + this.fileExtension) ? String.valueOf(fn) + "." + this.fileExtension : fn) : (!fn.toLowerCase(Locale.getDefault()).endsWith("." + this.fileExtension) ? String.valueOf(fn) + "." + this.fileExtension : fn);
        String cheatSheetIdFromPage = "";
        boolean showCheatSheetFromPage = false;
        final ReportDesignHandle selTemplate = this.templateChoicePage.getTemplate();
        final String templateName = selTemplate.getFileName();
        cheatSheetIdFromPage = this.templateChoicePage.getTemplate().getCheatSheet();
        if (cheatSheetIdFromPage == null) {
            cheatSheetIdFromPage = "";
        }
        showCheatSheetFromPage = this.templateChoicePage.getShowCheatSheet();
        final String cheatSheetId = cheatSheetIdFromPage;
        final boolean showCheatSheet = showCheatSheetFromPage;
        final boolean isUseDefaultLibray = this.templateChoicePage.isUseDefaultLibrary();
        final LibraryHandle library = this.templateChoicePage.getDefaultLibraryHandle();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewReportWizard.this.doFinish(containerName, fileName, templateName, NewReportWizard.this.resolveRemoteStream(templateName, selTemplate), cheatSheetId, showCheatSheet, isUseDefaultLibray, library, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionUtil.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private InputStream resolveRemoteStream(String templateName, ReportDesignHandle handle) {
        if (templateName == null || handle == null) {
            return null;
        }
        File f = new File(templateName);
        if (!f.exists()) {
            try {
                new URL(templateName);
            }
            catch (Exception exception) {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    handle.serialize((OutputStream)out);
                    byte[] bytes = out.toByteArray();
                    out.close();
                    return new ByteArrayInputStream(bytes);
                }
                catch (IOException ie) {
                    ExceptionHandler.handle((Throwable)ie, (boolean)true);
                }
            }
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        boolean foundOpenProject = false;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                foundOpenProject = true;
                break;
            }
            ++i;
        }
        if (!foundOpenProject) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"NewReportWizard.title.Error"), (String)Messages.getString((String)"NewReportWizard.error.NoProject"));
        }
        this.selection = selection;
        this.setWindowTitle(NEW);
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
    }

    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE, this.selection, this.fileExtension);
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.templateChoicePage = new WizardTemplateChoicePage(TEMPLATECHOICEPAGE);
        this.addPage((IWizardPage)this.templateChoicePage);
        this.newReportFileWizardPage.setTitle(this.REPORT);
        this.newReportFileWizardPage.setDescription(CREATE_A_NEW_REPORT);
        this.templateChoicePage.setTitle(this.REPORT);
        this.templateChoicePage.setDescription(SELECT_A_REPORT_TEMPLATE);
        this.resetUniqueCount();
        this.newReportFileWizardPage.setFileName(this.getUniqueReportName(NEW_REPORT_FILE_NAME_PREFIX, NEW_REPORT_FILE_EXTENSION));
        this.newReportFileWizardPage.setContainerFullPath(this.getDefaultContainerPath());
        this.newReportFileWizardPage.setTemplateChoicePage(this.templateChoicePage);
    }

    void resetUniqueCount() {
        this.UNIQUE_COUNTER = 0;
    }

    IPath getDefaultContainerPath() {
        IEditorPart editor;
        IWorkbenchWindow benchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = benchWindow.getPartService().getActivePart();
        Object selection = null;
        if (part instanceof IEditorPart) {
            selection = ((IEditorPart)part).getEditorInput();
        } else {
            ISelection sel = benchWindow.getSelectionService().getSelection();
            if (sel != null && sel instanceof IStructuredSelection) {
                selection = ((IStructuredSelection)sel).getFirstElement();
            }
        }
        IContainer ct = this.getDefaultContainer(selection);
        if (ct == null && (editor = UIUtil.getActiveEditor((boolean)true)) != null) {
            ct = this.getDefaultContainer(editor.getEditorInput());
        }
        if (ct != null) {
            return ct.getFullPath();
        }
        return null;
    }

    private IContainer getDefaultContainer(Object selection) {
        IContainer ct = null;
        if (selection instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class);
            if (resource instanceof IContainer && resource.isAccessible()) {
                ct = (IContainer)resource;
            } else if (resource != null && resource.getParent() != null && resource.getParent().isAccessible()) {
                ct = resource.getParent();
            }
        }
        return ct;
    }

    String getUniqueReportName(String prefix, String ext) {
        int counter = this.getCounter(prefix, ext);
        return counter == 0 ? String.valueOf(prefix) + ext : String.valueOf(prefix) + "_" + counter + ext;
    }

    int getCounter(String prefix, String ext) {
        IProject[] pjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.resetUniqueCount();
        boolean goon = true;
        block0: while (goon) {
            goon = false;
            int i = 0;
            while (i < pjs.length) {
                if (pjs[i].isAccessible() && !this.validDuplicate(prefix, ext, this.UNIQUE_COUNTER, (IResource)pjs[i])) {
                    ++this.UNIQUE_COUNTER;
                    goon = true;
                    continue block0;
                }
                ++i;
            }
        }
        return this.UNIQUE_COUNTER;
    }

    boolean validDuplicate(String prefix, String ext, int count, IResource res) {
        if (res != null && res.isAccessible()) {
            final String name = count == 0 ? String.valueOf(prefix) + ext : String.valueOf(prefix) + "_" + count + ext;
            try {
                tmpList.clear();
                res.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.getType() == 1) {
                            if (!Platform.getOS().equals("win32")) {
                                if (name.equals(((IFile)resource).getName())) {
                                    tmpList.add(Boolean.TRUE);
                                }
                            } else if (name.equalsIgnoreCase(((IFile)resource).getName())) {
                                tmpList.add(Boolean.TRUE);
                            }
                        }
                        return true;
                    }
                }, 2, true);
                if (tmpList.size() > 0) {
                    return false;
                }
            }
            catch (CoreException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        return true;
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.getFolder(folderPath);
    }

    private void doFinish(IPath containerName, String fileName, String templateFileName, InputStream templateStream, String cheatSheetId, boolean showCheatSheet, boolean isUseDefaultLibrary, LibraryHandle library, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(CREATING) + fileName, 2);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(containerName);
        IContainer container = null;
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            IFolder folder = this.createFolderHandle(containerName);
            UIUtil.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            container = folder;
        } else {
            container = (IContainer)resource;
        }
        final IFile file = container.getFile((IPath)new Path(fileName));
        final String cheatId = cheatSheetId;
        final boolean showCheat = showCheatSheet;
        try {
            ReportDesignHandle handle = templateStream == null ? SessionHandleAdapter.getInstance().getSessionHandle().createDesignFromTemplate(templateFileName) : SessionHandleAdapter.getInstance().getSessionHandle().createDesignFromTemplate(templateFileName, templateStream);
            if (ReportPlugin.getDefault().getEnableCommentPreference(file.getProject())) {
                handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference(file.getProject()));
            }
            if (ReportPlugin.getDefault().getDefaultUnitPreference(file.getProject()) != null) {
                handle.setStringProperty("units", ReportPlugin.getDefault().getDefaultUnitPreference(file.getProject()));
            }
            if (this.isPredifinedTemplate(templateFileName)) {
                handle.setDisplayName(null);
                handle.setDescription(null);
            }
            String bidiOrientation = this.templateChoicePage.isLTRDirection() ? "ltr" : "rtl";
            handle.setBidiOrientation(bidiOrientation);
            UIUtil.addCreateBy((ModuleHandle)handle);
            UIUtil.setDPI((ReportDesignHandle)handle);
            if (isUseDefaultLibrary) {
                UIUtil.includeLibrary((ModuleHandle)handle, (String)"/ThemesReportItems.rptlibrary", (boolean)true);
            }
            handle.saveAs(file.getLocation().toOSString());
            handle.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e, (boolean)true);
        }
        file.refreshLocal(2, monitor);
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)NewReportWizard.this.configElement);
                    if (showCheat && !cheatId.equals("")) {
                        Object oldData = Display.getCurrent().getActiveShell().getData();
                        if (oldData instanceof TrayDialog) {
                            Display.getCurrent().getActiveShell().setData(null);
                        }
                        new OpenCheatSheetAction(cheatId).run();
                    }
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    public boolean canFinish() {
        return this.templateChoicePage.isPageComplete() && this.newReportFileWizardPage.isPageComplete();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    protected boolean isPredifinedTemplate(String sourceFileName) {
        if (sourceFileName == null || sourceFileName.trim().length() == 0) {
            return false;
        }
        String predifinedDir = UIUtil.getFragmentDirectory();
        assert (predifinedDir != null);
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(sourceFileName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }
}

