/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.AbstractCell;
import org.seasar.fisshplate.core.element.Link;
import org.seasar.fisshplate.core.parser.CellParser;
import org.seasar.fisshplate.enums.LinkElementType;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class LinkParser
implements CellParser {
    private static final Pattern pat = Pattern.compile("^\\s*\\#link-(\\S+)\\s+link\\s*=\\s*(.+)\\s+text\\s*=\\s*(.+)$");

    public AbstractCell getElement(CellWrapper cell, String value) {
        Matcher mat = pat.matcher(value);
        if (!mat.find() || !this.isValidType(mat)) {
            return null;
        }
        return new Link(cell);
    }

    private boolean isValidType(Matcher mat) {
        String type = mat.group(1);
        LinkElementType elemType = LinkElementType.get(type);
        return elemType != null;
    }
}

