/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.Iterator;
import java.util.Map;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.AbstractBlock;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.util.IteratorUtil;
import org.seasar.fisshplate.util.OgnlUtil;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class IteratorBlock
extends AbstractBlock {
    private String varName;
    private String iteratorName;
    private String indexName;
    private int max;
    private RowWrapper row;
    private int lineNumPerPage;

    public IteratorBlock(RowWrapper row, String varName, String iteratorName, String indexName, int max) {
        this.varName = varName;
        this.iteratorName = iteratorName;
        this.max = max;
        this.row = row;
        this.indexName = indexName == null || "".equals(indexName.trim()) ? "index" : indexName;
    }

    public void merge(FPContext context) throws FPMergeException {
        Map data = context.getData();
        Object o = OgnlUtil.getValue(this.iteratorName, data);
        Iterator ite = IteratorUtil.getIterator(o, this.iteratorName, this.row);
        this.mergeIteratively(context, ite, data);
    }

    private void mergeIteratively(FPContext context, Iterator ite, Map data) throws FPMergeException {
        context.setCurrentIterator(this);
        this.initLineNumPerPage();
        int index = 0;
        while (ite.hasNext()) {
            Object var = ite.next();
            data.put(this.varName, var);
            data.put(this.indexName, new Integer(index));
            ++this.lineNumPerPage;
            ++index;
            this.mergeChildren(context);
        }
        context.setSkipMerge(true);
        context.clearCurrentIterator();
        while (this.max > this.lineNumPerPage) {
            data.put(this.indexName, new Integer(index));
            ++this.lineNumPerPage;
            ++index;
            this.mergeChildren(context);
        }
        context.setSkipMerge(false);
    }

    public int getLineNumPerPage() {
        return this.lineNumPerPage;
    }

    public void initLineNumPerPage() {
        this.lineNumPerPage = 0;
    }
}

