/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.OutputPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionComposite;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class OutputPropertyDescriptor
extends PropertyDescriptor {
    private static final String All_Title = Messages.getString((String)"VisibilityPage.Label.DetailAll");
    private static final String Spec_Title = Messages.getString((String)"VisibilityPage.Label.DetailSpecific");
    private Button allRadio;
    private Button specRadio;
    private Group group;
    private Composite allContainer;
    private Composite specContainer;
    private ExpressionComposite allExpression;
    private SelectionAdapter listener;
    private boolean inputChanged = false;
    private Object oldInput = null;
    private OutputPropertyDescriptorProvider outputDescriptorProvider;
    private HashMap specCheckButtons;
    private HashMap specExpressions;
    private Button hideCheckbox;
    private Composite container;

    public OutputPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!OutputPropertyDescriptor.this.specCheckButtons.containsValue(e.getSource())) {
                    OutputPropertyDescriptor.this.setOutputEnable(OutputPropertyDescriptor.this.hideCheckbox.getSelection());
                }
                if (OutputPropertyDescriptor.this.hideCheckbox.getSelection()) {
                    OutputPropertyDescriptor.this.saveHideInfo();
                } else {
                    try {
                        OutputPropertyDescriptor.this.outputDescriptorProvider.emptyProperty();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        };
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)WidgetUtil.createGridLayout(4));
        this.hideCheckbox = FormWidgetFactory.getInstance().createButton(this.container, 32, this.isFormStyle());
        this.hideCheckbox.setText(Messages.getString((String)"VisibilityPage.Check.HideElement"));
        GridData data = new GridData();
        data.verticalAlignment = 1;
        this.hideCheckbox.setLayoutData((Object)data);
        this.hideCheckbox.addSelectionListener((SelectionListener)this.listener);
        WidgetUtil.createGridPlaceholder(this.container, 3, true);
        WidgetUtil.createHorizontalLine(this.container, 4);
        this.allRadio = FormWidgetFactory.getInstance().createButton(this.container, 16, this.isFormStyle());
        this.allRadio.setText(Messages.getString((String)"VisibilityPage.Radio.AllOutputs"));
        this.allRadio.addSelectionListener((SelectionListener)this.listener);
        WidgetUtil.createGridPlaceholder(this.container, 3, true);
        this.specRadio = FormWidgetFactory.getInstance().createButton(this.container, 16, this.isFormStyle());
        this.specRadio.setText(Messages.getString((String)"VisibilityPage.Radio.SpecificOutputs"));
        WidgetUtil.createGridPlaceholder(this.container, 3, true);
        this.group = this.isFormStyle() ? FormWidgetFactory.getInstance().createGroup(this.container, "") : new Group(this.container, 0);
        this.group.setLayout((Layout)new GridLayout());
        data = new GridData();
        data.verticalSpan = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.group.setLayoutData((Object)data);
        this.allContainer = this.buildUIForAlloutput((Composite)this.group);
        this.specContainer = this.buildUIForSpecific((Composite)this.group);
        this.allRadio.setSelection(true);
        this.setOutputInfo();
        return this.container;
    }

    public Control getControl() {
        return this.container;
    }

    private Composite buildUIForAlloutput(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label label = FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle());
        label.setText(Messages.getString((String)"VisibilityPage.Label.Expression"));
        this.allExpression = new ExpressionComposite(container, this.isFormStyle());
        this.allExpression.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                OutputPropertyDescriptor.this.saveHideInfo();
            }
        });
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.allExpression.setLayoutData(data);
        return container;
    }

    private Composite buildUIForSpecific(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        ReportEngine engine = new ReportEngine(new EngineConfig());
        String[] typeInfo = engine.getSupportedFormats();
        this.specCheckButtons = new HashMap();
        this.specExpressions = new HashMap();
        int i = 0;
        while (i < typeInfo.length) {
            Button btn = FormWidgetFactory.getInstance().createButton(container, 32, this.isFormStyle());
            btn.setText(typeInfo[i]);
            btn.setSelection(false);
            Label label = FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle());
            label.setText(Messages.getString((String)"VisibilityPage.Label.Expression"));
            ExpressionComposite expression = new ExpressionComposite(container, this.isFormStyle());
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            expression.setLayoutData(data);
            this.specCheckButtons.put(typeInfo[i], btn);
            this.specExpressions.put(typeInfo[i], expression);
            btn.addSelectionListener((SelectionListener)this.listener);
            expression.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    OutputPropertyDescriptor.this.saveHideInfo();
                }
            });
            ++i;
        }
        return container;
    }

    protected void saveHideInfo() {
        this.setOutputInfo();
        if (this.allRadio.getSelection()) {
            try {
                this.outputDescriptorProvider.saveAllOutput(this.allExpression.getExpression());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            boolean[] selections = new boolean[this.outputDescriptorProvider.getTypeInfo().length];
            Expression[] expressions = new Expression[this.outputDescriptorProvider.getTypeInfo().length];
            int i = 0;
            while (i < this.outputDescriptorProvider.getTypeInfo().length) {
                selections[i] = ((Button)this.specCheckButtons.get(this.outputDescriptorProvider.getTypeInfo()[i])).getSelection();
                expressions[i] = ((ExpressionComposite)((Object)this.specExpressions.get(this.outputDescriptorProvider.getTypeInfo()[i]))).getExpression();
                ++i;
            }
            try {
                this.outputDescriptorProvider.saveSpecialOutput(selections, expressions);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.hideCheckbox.setSelection(true);
            this.setOutputEnable(true);
        }
    }

    private void setOutputEnable(boolean enable) {
        this.allRadio.setEnabled(enable);
        this.specRadio.setEnabled(enable);
        this.group.setEnabled(enable);
        Composite container = this.getCurrentContainer();
        Control[] children = container.getChildren();
        if (container == this.allContainer) {
            int i = 0;
            while (i < children.length) {
                children[i].setEnabled(enable);
                ++i;
            }
        } else {
            int i = 0;
            while (i < children.length) {
                if (!(children[i] instanceof ExpressionComposite)) {
                    children[i].setEnabled(enable);
                }
                ++i;
            }
            i = 0;
            while (i < this.outputDescriptorProvider.getTypeInfo().length) {
                ((ExpressionComposite)((Object)this.specExpressions.get(this.outputDescriptorProvider.getTypeInfo()[i]))).setEnabled(this.hideCheckbox.getSelection() && ((Button)this.specCheckButtons.get(this.outputDescriptorProvider.getTypeInfo()[i])).getSelection());
                ++i;
            }
        }
    }

    private Composite getCurrentContainer() {
        return ((GridData)this.allContainer.getLayoutData()).heightHint != 0 ? this.allContainer : this.specContainer;
    }

    private void setOutputInfo() {
        if (this.allRadio.getSelection() && (((GridData)this.allContainer.getLayoutData()).heightHint == 0 || ((GridData)this.specContainer.getLayoutData()).heightHint != 0)) {
            this.group.setText(All_Title);
            ((GridData)this.specContainer.getLayoutData()).heightHint = 0;
            ((GridData)this.allContainer.getLayoutData()).heightHint = -1;
            this.group.layout();
            this.group.getParent().layout();
        }
        if (this.specRadio.getSelection() && (((GridData)this.specContainer.getLayoutData()).heightHint == 0 || ((GridData)this.allContainer.getLayoutData()).heightHint != 0)) {
            this.group.setText(Spec_Title);
            ((GridData)this.specContainer.getLayoutData()).heightHint = -1;
            ((GridData)this.allContainer.getLayoutData()).heightHint = 0;
            this.group.layout();
            this.group.getParent().layout();
        }
        this.dealParentLayout(this.container);
    }

    private void dealParentLayout(Composite container) {
        if (container == null) {
            return;
        }
        if (!(container instanceof ScrolledComposite)) {
            this.dealParentLayout(container.getParent());
            return;
        }
        ScrolledComposite composite = (ScrolledComposite)container;
        Composite control = (Composite)composite.getContent();
        composite.setMinSize(control.computeSize(-1, -1));
        control.layout();
    }

    public void save(Object obj) throws SemanticException {
    }

    public void setInput(Object object) {
        super.setInput(object);
        this.getDescriptorProvider().setInput(object);
        this.inputChanged = true;
    }

    private void resetUI() {
        this.allRadio.setSelection(true);
        this.specRadio.setSelection(false);
        this.setOutputInfo();
        int i = 0;
        while (i < this.outputDescriptorProvider.getTypeInfo().length) {
            ((Button)this.specCheckButtons.get(this.outputDescriptorProvider.getTypeInfo()[i])).setSelection(false);
            ((ExpressionComposite)((Object)this.specExpressions.get(this.outputDescriptorProvider.getTypeInfo()[i]))).setExpression(new Expression((Object)"true", UIUtil.getDefaultScriptType()));
            ++i;
        }
        this.allExpression.setExpression(new Expression((Object)"true", UIUtil.getDefaultScriptType()));
    }

    private boolean needResetUI() {
        Iterator visibilities;
        if (this.oldInput == null) {
            this.oldInput = this.getInput();
        }
        if (((visibilities = this.outputDescriptorProvider.getVisibilityRulesIterator()) == null || !visibilities.hasNext()) && this.hideCheckbox.getSelection()) {
            if (!this.allRadio.getSelection() && this.oldInput.equals(this.getInput())) {
                return false;
            }
            this.oldInput = this.getInput();
            return true;
        }
        this.oldInput = this.getInput();
        while (visibilities.hasNext()) {
            Object obj = visibilities.next();
            String format = this.outputDescriptorProvider.getFormat(obj);
            if (!this.outputDescriptorProvider.isFormatTypeAll(format)) continue;
            return true;
        }
        if (this.getCurrentContainer() == this.specContainer) {
            return !this.hideCheckbox.getSelection();
        }
        return true;
    }

    public void load() {
        if (this.needResetUI()) {
            this.inputChanged();
        }
        this.doLoad();
    }

    private void inputChanged() {
        if (this.inputChanged) {
            this.resetUI();
            this.inputChanged = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doLoad() {
        block12: {
            block11: {
                this.setExpressionProvider();
                if (!this.outputDescriptorProvider.isEnabled()) {
                    this.hideCheckbox.setSelection(false);
                    this.hideCheckbox.setEnabled(false);
                    this.setOutputEnable(false);
                    return;
                }
                this.hideCheckbox.setEnabled(true);
                if (!this.needResetUI()) break block11;
                this.hideCheckbox.setEnabled(true);
                visibilities = this.outputDescriptorProvider.getVisibilityRulesIterator();
                this.hideCheckbox.setSelection(visibilities != null && visibilities.hasNext() != false);
                this.setOutputEnable(this.hideCheckbox.getSelection());
                if (visibilities != null) ** GOTO lbl33
                return;
lbl-1000:
                // 1 sources

                {
                    obj = visibilities.next();
                    format = this.outputDescriptorProvider.getFormat(obj);
                    expression = this.outputDescriptorProvider.getExpression(obj);
                    if (expression == null) {
                        expression = new Expression(null, UIUtil.getDefaultScriptType());
                    }
                    if (this.outputDescriptorProvider.isFormatTypeAll(format)) {
                        this.allRadio.setSelection(true);
                        this.allRadio.forceFocus();
                        this.allExpression.setExpression(expression);
                        this.specRadio.setSelection(false);
                        break;
                    }
                    this.allRadio.setSelection(false);
                    this.specRadio.setSelection(true);
                    if (this.specCheckButtons.containsKey(format)) {
                        ((Button)this.specCheckButtons.get(format)).setSelection(true);
                    }
                    if (!this.specExpressions.containsKey(format)) continue;
                    ((ExpressionComposite)this.specExpressions.get(format)).setExpression(expression);
lbl33:
                    // 3 sources

                    ** while (visibilities.hasNext())
                }
lbl34:
                // 2 sources

                this.setOutputInfo();
                this.setOutputEnable(this.hideCheckbox.getSelection());
                i = 0;
                while (i < this.outputDescriptorProvider.getTypeInfo().length) {
                    expr = (ExpressionComposite)this.specExpressions.get(this.outputDescriptorProvider.getTypeInfo()[i]);
                    check = (Button)this.specCheckButtons.get(this.outputDescriptorProvider.getTypeInfo()[i]);
                    expr.setEnabled(check.getEnabled() != false && check.getSelection() != false && this.hideCheckbox.getSelection() != false);
                    ++i;
                }
                break block12;
            }
            i = 0;
            while (i < this.outputDescriptorProvider.getTypeInfo().length) {
                ((Button)this.specCheckButtons.get(this.outputDescriptorProvider.getTypeInfo()[i])).setSelection(false);
                ((ExpressionComposite)this.specExpressions.get(this.outputDescriptorProvider.getTypeInfo()[i])).setExpression(new Expression((Object)"true", UIUtil.getDefaultScriptType()));
                ++i;
            }
            visibilities = this.outputDescriptorProvider.getVisibilityRulesIterator();
            while (visibilities.hasNext()) {
                obj = visibilities.next();
                format = this.outputDescriptorProvider.getFormat(obj);
                expression = this.outputDescriptorProvider.getExpression(obj);
                if (expression == null) {
                    expression = new Expression(null, UIUtil.getDefaultScriptType());
                }
                if (this.specCheckButtons.containsKey(format)) {
                    ((Button)this.specCheckButtons.get(format)).setSelection(true);
                }
                if (!this.specExpressions.containsKey(format)) continue;
                ((ExpressionComposite)this.specExpressions.get(format)).setExpression(expression);
            }
            i = 0;
            while (i < this.outputDescriptorProvider.getTypeInfo().length) {
                expr = (ExpressionComposite)this.specExpressions.get(this.outputDescriptorProvider.getTypeInfo()[i]);
                check = (Button)this.specCheckButtons.get(this.outputDescriptorProvider.getTypeInfo()[i]);
                expr.setEnabled(check.getEnabled() != false && check.getSelection() != false && this.hideCheckbox.getSelection() != false);
                ++i;
            }
        }
    }

    private void setExpressionProvider() {
        ExpressionProvider provider = this.outputDescriptorProvider.getExpressionProvider();
        this.allExpression.setExpressionProvider((IExpressionProvider)provider);
        this.allExpression.setInput(this.getInput());
        int i = 0;
        while (i < this.outputDescriptorProvider.getTypeInfo().length) {
            ExpressionComposite expressionComposite = (ExpressionComposite)((Object)this.specExpressions.get(this.outputDescriptorProvider.getTypeInfo()[i]));
            expressionComposite.setExpressionProvider((IExpressionProvider)provider);
            expressionComposite.setInput(this.getInput());
            ++i;
        }
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof OutputPropertyDescriptorProvider) {
            this.outputDescriptorProvider = (OutputPropertyDescriptorProvider)provider;
        }
    }
}

