/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.yaml.dom;

import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ScriptElement {
    ScriptEngine engine;
    CompiledScript compiledScript;
    String scriptText = "";
    String engineName;
    static String UTILITY_SCRIPT;
    static int UTILITY_SCRIPT_LINES;
    IFile iFile;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    static {
        StringBuilder buf = new StringBuilder();
        try {
            FileUtil fu = new FileUtil(ScriptElement.class, "prototype.js");
            buf.append(FileUtil.getText((InputStream)fu.getStream(), (String)"UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append(String.format("util = { %n", new Object[0]));
        buf.append(String.format("  isEcmaArray: function(array) { %n", new Object[0]));
        buf.append(String.format("      return !!(array instanceof Array && !('getClass' in array)); %n", new Object[0]));
        buf.append(String.format("  }, %n", new Object[0]));
        buf.append(String.format("  isNativeArray: function(array) { %n", new Object[0]));
        buf.append(String.format("      return !!(array instanceof Array && 'getClass' in array && array.getClass().isArray()); %n", new Object[0]));
        buf.append(String.format("  }, %n", new Object[0]));
        buf.append(String.format("  isEcmaArray: function(array) { %n", new Object[0]));
        buf.append(String.format("      return !!(array instanceof Array && !('getClass' in array)); %n", new Object[0]));
        buf.append(String.format("  }, %n", new Object[0]));
        buf.append(String.format("  ecmaArray: function(collection) {                                   %n", new Object[0]));
        buf.append(String.format("  var ret = []; for( var ite = collection.iterator(); ite.hasNext(); ){ ret.push(ite.next()); } return ret; %n", new Object[0]));
        buf.append(String.format("  } %n", new Object[0]));
        buf.append(String.format("};", new Object[0]));
        UTILITY_SCRIPT = StringUtil.resetCRLF((String)buf.toString(), (boolean)true);
        UTILITY_SCRIPT_LINES = UTILITY_SCRIPT.split(StringUtil.LINE_SEPARATOR).length;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public synchronized void setScriptText(String scriptText) {
        String trimedText = StringUtil.nvl((Object)scriptText);
        if (!this.scriptText.equals(trimedText)) {
            this.compiledScript = null;
        }
        this.scriptText = trimedText;
    }

    public String getEngineName() {
        if (StringUtil.isEmpty((Object)this.engineName)) {
            return "JavaScript";
        }
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public synchronized boolean evaluate(Object root, Object selection_model, Map<String, Object> globalParameter) throws ScriptException {
        if (this.engine == null) {
            ScriptEngineManager manager = new ScriptEngineManager();
            this.engine = manager.getEngineByName(this.getEngineName());
        }
        Bindings bindings = this.engine.getBindings(200);
        bindings.put("root", root);
        bindings.put("selection_model", selection_model);
        if (globalParameter != null) {
            for (String key : globalParameter.keySet()) {
                bindings.put(key, globalParameter.get(key));
            }
        }
        StringBuilder script = new StringBuilder();
        script.append(UTILITY_SCRIPT);
        script.append(this.getScriptText());
        if (this.compiledScript == null && this.engine instanceof Compilable) {
            try {
                this.compiledScript = ((Compilable)((Object)this.engine)).compile(script.toString());
            }
            catch (ScriptException e2) {
                this.dumpDebugLog(e2, script.toString());
                throw e2;
            }
        }
        try {
            if (this.compiledScript == null) {
                this.engine.eval(script.toString(), bindings);
            } else {
                this.compiledScript.eval(bindings);
            }
        }
        catch (ScriptException e2) {
            this.dumpDebugLog(e2, script.toString());
            throw e2;
        }
        return true;
    }

    private void dumpDebugLog(ScriptException e2, String scriptText) {
        int erroredLine = e2.getLineNumber();
        Throwable e2i = e2.getCause();
        Class<?> e2iClazz = e2i.getClass();
        if ("sun.org.mozilla.javascript.internal.EvaluatorException".equals(e2iClazz.getName()) || "sun.org.mozilla.javascript.internal.JavaScriptException".equals(e2iClazz.getName()) || "sun.org.mozilla.javascript.internal.EcmaError".equals(e2iClazz.getName())) {
            try {
                Method lineNumberMethod = e2iClazz.getMethod("getLineNumber", new Class[0]);
                lineNumberMethod.setAccessible(true);
                erroredLine = (Integer)lineNumberMethod.invoke((Object)e2i, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("not support class::" + e2iClazz);
        }
        int min = erroredLine;
        if (erroredLine > 10) {
            min -= 10;
        }
        List linesList = StringUtil.getLinesRangeOf((String)scriptText, (int)min, (int)(min + 20), (boolean)false);
        int i = 0;
        while (i < linesList.size()) {
            String mark = min + i == erroredLine ? ">>" : "  ";
            System.err.println(String.format("[%4d]%s :%s", min + i, mark, linesList.get(i)));
            ++i;
        }
        if (this.iFile != null) {
            HashMap<String, Integer> attributes = new HashMap<String, Integer>();
            MarkerUtilities.setCharStart(attributes, (int)0);
            MarkerUtilities.setCharEnd(attributes, (int)0);
            MarkerUtilities.setMessage(attributes, (String)e2.getMessage());
            attributes.put("severity", 2);
            try {
                MarkerUtilities.createMarker((IResource)this.iFile, attributes, (String)"org.eclipse.core.resources.problemmarker");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

