/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class JavadocConfigurationPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.jdt.ui.propertyPages.JavadocConfigurationPropertyPage";
    private JavadocConfigurationBlock fJavadocConfigurationBlock;
    private boolean fIsValidElement;
    private boolean fIsReadOnly;
    private IPath fContainerPath;
    private IClasspathEntry fEntry;
    private URL fInitalLocation;

    public void createControl(Composite parent) {
        IJavaElement elem = this.getJavaElement();
        try {
            if (elem instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)elem).getKind() == 2) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                IClasspathEntry entry = JavaModelUtil.getClasspathEntry(root);
                if (entry == null) {
                    this.fIsValidElement = false;
                    this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
                } else if (entry.getEntryKind() == 5) {
                    this.fContainerPath = entry.getPath();
                    this.fEntry = this.handleContainerEntry(this.fContainerPath, elem.getJavaProject(), root.getPath());
                    this.fIsValidElement = this.fEntry != null;
                } else {
                    this.fContainerPath = null;
                    this.fEntry = entry;
                    this.fIsValidElement = true;
                    this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsPackageFragmentRoot_description);
                }
            } else if (elem instanceof IJavaProject) {
                this.fIsValidElement = true;
                this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsJavaProject_description);
            } else {
                this.fIsValidElement = false;
                this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
            }
        }
        catch (JavaModelException javaModelException) {
            this.fIsValidElement = false;
            this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
        }
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.javadoc_configuration_property_page_context");
    }

    private IClasspathEntry handleContainerEntry(IPath containerPath, IJavaProject jproject, IPath jarPath) throws JavaModelException {
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        if (initializer == null || container == null) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_invalid_container, BasicElementLabels.getPathLabel(containerPath, false)));
            return null;
        }
        String containerName = container.getDescription();
        IStatus status = initializer.getAttributeStatus(containerPath, jproject, "javadoc_location");
        if (status.getCode() == 1) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_not_supported, containerName));
            return null;
        }
        IClasspathEntry entry = JavaModelUtil.findEntryInContainer(container, jarPath);
        if (status.getCode() == 2) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_read_only, containerName));
            this.fIsReadOnly = true;
            return entry;
        }
        Assert.isNotNull((Object)entry);
        this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsPackageFragmentRoot_description);
        return entry;
    }

    protected Control createContents(Composite parent) {
        if (!this.fIsValidElement || this.fIsReadOnly) {
            Composite inner = new Composite(parent, 0);
            if (this.fIsReadOnly) {
                URL javadocUrl;
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                inner.setLayout((Layout)layout);
                Label label = new Label(inner, 64);
                label.setText(PreferencesMessages.JavadocConfigurationPropertyPage_location_path);
                Text location = new Text(inner, 72);
                GridData gd = new GridData(256);
                gd.widthHint = this.convertWidthInCharsToPixels(80);
                location.setLayoutData((Object)gd);
                String locationPath = PreferencesMessages.JavadocConfigurationPropertyPage_locationPath_none;
                if (this.fEntry != null && (javadocUrl = JavaDocLocations.getLibraryJavadocLocation(this.fEntry)) != null) {
                    locationPath = javadocUrl.toExternalForm();
                }
                location.setText(locationPath);
                Dialog.applyDialogFont((Control)inner);
            }
            return inner;
        }
        IJavaElement elem = this.getJavaElement();
        this.fInitalLocation = null;
        if (elem != null) {
            try {
                this.fInitalLocation = JavaUI.getJavadocBaseLocation(elem);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        boolean isProject = elem instanceof IJavaProject;
        this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(this.getShell(), this, this.fInitalLocation, isProject);
        Control control = this.fJavadocConfigurationBlock.createContents(parent);
        control.setVisible(elem != null);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private IJavaElement getJavaElement() {
        IAdaptable adaptable = this.getElement();
        IJavaElement elem = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
        if (elem == null) {
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            try {
                IProject proj;
                if (resource instanceof IFile && ArchiveFileFilter.isArchivePath(resource.getFullPath(), true) && (proj = resource.getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jproject = JavaCore.create((IProject)proj);
                    elem = jproject.getPackageFragmentRoot(resource);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return elem;
    }

    protected void performDefaults() {
        if (this.fJavadocConfigurationBlock != null) {
            this.fJavadocConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fJavadocConfigurationBlock != null) {
            URL javadocLocation = this.fJavadocConfigurationBlock.getJavadocLocation();
            if (javadocLocation == null && this.fInitalLocation == null || javadocLocation != null && this.fInitalLocation != null && javadocLocation.toExternalForm().equals(this.fInitalLocation.toExternalForm())) {
                return true;
            }
            IJavaElement elem = this.getJavaElement();
            try {
                IRunnableWithProgress runnable = JavadocConfigurationPropertyPage.getRunnable(this.getShell(), elem, javadocLocation, this.fEntry, this.fContainerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = PreferencesMessages.SourceAttachmentPropertyPage_error_title;
                String message = PreferencesMessages.SourceAttachmentPropertyPage_error_message;
                ExceptionHandler.handle(e, this.getShell(), title, message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    private static IRunnableWithProgress getRunnable(final Shell shell, final IJavaElement elem, final URL javadocLocation, final IClasspathEntry entry, final IPath containerPath) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IJavaProject project = elem.getJavaProject();
                    if (elem instanceof IPackageFragmentRoot) {
                        CPListElement cpElem = CPListElement.createFromExisting(entry, project);
                        String loc = javadocLocation != null ? javadocLocation.toExternalForm() : null;
                        cpElem.setAttribute("javadoc_location", loc);
                        IClasspathEntry newEntry = cpElem.getClasspathEntry();
                        String[] changedAttributes = new String[]{"javadoc_location"};
                        BuildPathSupport.modifyClasspathEntry(shell, newEntry, changedAttributes, project, containerPath, entry.getReferencingEntry() != null, monitor);
                    } else {
                        JavaUI.setProjectJavadocLocation(project, javadocLocation);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

