/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.views.attributes.provider;

import org.eclipse.birt.chart.reportitem.ui.ChartFilterFactory;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIUtil;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ChartCubeFilterConditionBuilder;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChartCubeFilterModelProvider;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChartFilterProviderDelegate;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.FilterConditionBuilder;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class ChartCubeFilterHandleProvider
extends ChartFilterProviderDelegate {
    private ChartWizardContext context = null;

    public void setContext(ChartWizardContext context) {
        this.context = context;
    }

    public ChartCubeFilterHandleProvider(AbstractFilterHandleProvider baseProvider) {
        super(baseProvider);
        this.setModelAdapter(new ChartCubeFilterModelProvider());
    }

    public boolean doAddItem(int pos) throws SemanticException {
        Object item = this.getContentInput().get(0);
        if (item instanceof DesignElementHandle) {
            ChartFilterFactory cff = ChartReportItemUIUtil.createChartFilterFactory(item);
            ChartCubeFilterConditionBuilder dialog = cff.createCubeFilterConditionBuilder(UIUtil.getDefaultShell(), FilterConditionBuilder.DLG_TITLE_NEW, FilterConditionBuilder.DLG_MESSAGE_NEW);
            dialog.setDesignHandle((DesignElementHandle)item, this.context);
            dialog.setInput(null);
            dialog.setBindingParams(this.getBindingParams());
            if (item instanceof ReportItemHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)item));
            } else if (item instanceof GroupHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)item).getContainer()));
            }
            if (dialog.open() == 1) {
                return false;
            }
        }
        return true;
    }

    public boolean doEditItem(int pos) {
        Object item = this.getContentInput().get(0);
        if (item instanceof DesignElementHandle) {
            ChartFilterFactory cff;
            DesignElementHandle element = (DesignElementHandle)item;
            PropertyHandle propertyHandle = element.getPropertyHandle("cubeFilter");
            FilterConditionElementHandle filterHandle = (FilterConditionElementHandle)propertyHandle.getListValue().get(pos);
            if (filterHandle == null) {
                return false;
            }
            try {
                cff = ChartReportItemUIUtil.createChartFilterFactory(item);
            }
            catch (ExtendedElementException e) {
                ChartWizard.displayException((Throwable)e);
                return false;
            }
            ChartCubeFilterConditionBuilder dialog = cff.createCubeFilterConditionBuilder(UIUtil.getDefaultShell(), FilterConditionBuilder.DLG_TITLE_EDIT, FilterConditionBuilder.DLG_MESSAGE_EDIT);
            dialog.setDesignHandle((DesignElementHandle)item, this.context);
            dialog.setInput(filterHandle);
            dialog.setBindingParams(this.getBindingParams());
            if (item instanceof ReportItemHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)item));
            } else if (item instanceof GroupHandle) {
                dialog.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)item).getContainer()));
            }
            if (dialog.open() == 1) {
                return false;
            }
        }
        return true;
    }

    public boolean isEditable() {
        return ((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.getInput())).getCube() != null;
    }

    public IFormProvider getConcreteFilterProvider() {
        if (this.input == null) {
            return this;
        }
        return ChartFilterProviderDelegate.createFilterProvider(this.input, this.getInput());
    }

    public boolean needRefreshed(NotificationEvent event) {
        String propertyName;
        if (event instanceof PropertyEvent && "cubeFilter".equals(propertyName = ((PropertyEvent)event).getPropertyName())) {
            return true;
        }
        return super.needRefreshed(event);
    }

    public void add(int pos) throws Exception {
        boolean sucess = false;
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        try {
            sucess = this.doAddItem(pos);
        }
        catch (Exception e) {
            stack.rollback();
            throw new Exception(e);
        }
        if (sucess) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    public boolean edit(int pos) {
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        if (!this.doEditItem(pos)) {
            stack.rollback();
            return false;
        }
        stack.commit();
        return true;
    }
}

