/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.csveditor.dialog.CSVConfigDialog;
import hiro.yoshioka.job.ImportTableFromCSVJob;
import hiro.yoshioka.sdh.RDHTableViewer;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.SqlBasicListener;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import jp.sf.orangesignal.csv.CsvConfig;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ImportTableAction
implements IViewActionDelegate,
SqlBasicListener {
    private ExplorerView fView;
    private CSVConfigDialog.MyCsvConfig csvConfig = new CSVConfigDialog.MyCsvConfig(CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
    boolean doTruncate = true;
    boolean firstName = true;
    IAction fAction;

    public void init(IViewPart view) {
        this.fView = (ExplorerView)view;
        SQLServerThread.getSQLServer().addConnectionListner((SqlBasicListener)this);
    }

    public void run(IAction action) {
        try {
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4098);
            String[] ext = new String[]{"*.csv"};
            dialog.setFilterExtensions(ext);
            IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.csvFolder);
            dialog.setFilterPath(ResourceMarker.cnvFile(folder).getAbsolutePath());
            dialog.setText("CHOOSE IMPORT FILES <TABLE_NAME>.csv....");
            if (dialog.open() == null) {
                return;
            }
            String dir = dialog.getFilterPath();
            String[] files = dialog.getFileNames();
            File[] inputFiles = new File[files.length];
            int i = 0;
            while (i < inputFiles.length) {
                inputFiles[i] = new File(dir, files[i]);
                ++i;
            }
            MyDialog md = new MyDialog(Display.getCurrent().getActiveShell(), inputFiles);
            if (md.open() == 1) {
                return;
            }
            ImportTableFromCSVJob job = new ImportTableFromCSVJob(inputFiles, this.csvConfig.getEncoding(), this.doTruncate, this.firstName);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Application.exec(new PopUp(event.getResult().isOK()));
                }
            });
            job.setUser(true);
            job.schedule();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    private void update() {
        if (this.fAction != null) {
            ConnectionProperties p = this.fView.getSelectedConnectionProperties();
            if (p != null && p.isConnected()) {
                this.fAction.setEnabled(true);
            } else {
                this.fAction.setEnabled(false);
            }
        } else {
            this.fAction.setEnabled(false);
        }
    }

    public void connected() {
        Application.exec(new MyUpdate());
    }

    public void disconnected() {
        Application.exec(new MyUpdate());
    }

    public class MyDialog
    extends Dialog {
        File[] selectedFiles;
        CTabFolder tabFolder;
        int latestSelection;

        public MyDialog(Shell parent, File[] files) {
            super(parent);
            this.latestSelection = -1;
            this.selectedFiles = files;
        }

        protected Point getInitialSize() {
            return new Point(680, 350);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("CSV Import Image");
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            CLabel label = new CLabel(composite, 0);
            label.setText("SHOW 30 ROWS FROM FIRST");
            label.setBackground(new Color[]{Display.getCurrent().getSystemColor(10), Display.getCurrent().getSystemColor(9), Display.getCurrent().getSystemColor(1)}, new int[]{50, 100});
            label.setForeground(Display.getCurrent().getSystemColor(1));
            label.setLayoutData((Object)new GridData(768));
            Composite up = new Composite(composite, 0);
            up.setLayout((Layout)new GridLayout(4, false));
            new Label(up, 0).setText("May i TRUNCATE TABLE before INSERT?");
            final Button truncButton = new Button(up, 32);
            truncButton.setSelection(true);
            truncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((MyDialog)MyDialog.this).ImportTableAction.this.doTruncate = truncButton.getSelection();
                }
            });
            new Label(up, 0).setText("CSV Confing");
            Button cfgButton = new Button(up, 8);
            cfgButton.setText("Set up");
            cfgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSVConfigDialog cDialog = new CSVConfigDialog(MyDialog.this.getShell(), ImportTableAction.this.csvConfig);
                    if (cDialog.open() == 0) {
                        ImportTableAction.this.csvConfig = cDialog.getConfig();
                        MyDialog.this.refreshTables();
                    }
                }
            });
            up.setLayoutData((Object)new GridData(768));
            this.tabFolder = new CTabFolder(composite, 2304);
            this.tabFolder.setSimple(false);
            this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(31), Display.getCurrent().getSystemColor(32)}, new int[]{90}, true);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.tabFolder.setFocus();
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MyDialog.this.latestSelection = MyDialog.this.tabFolder.getSelectionIndex();
                }
            });
            this.refreshTables();
            return composite;
        }

        private void refreshTables() {
            CTabItem[] cTabItemArray = this.tabFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                item.dispose();
                item = null;
                ++n2;
            }
            int i = 0;
            while (i < this.selectedFiles.length) {
                try {
                    CTabItem tabItem1 = new CTabItem(this.tabFolder, 0);
                    tabItem1.setText(this.selectedFiles[i].getName());
                    String[][] datum = CSVUtil.split((File)this.selectedFiles[i], (String)ImportTableAction.this.csvConfig.getEncoding(), (CsvConfig)ImportTableAction.this.csvConfig);
                    RDHTableViewer table = new RDHTableViewer((Composite)this.tabFolder);
                    ResultSetDataHolder rdh = new ResultSetDataHolder(datum[0]);
                    int ii = 1;
                    while (i < 31 && ii < datum.length) {
                        rdh.addRow(datum[ii]);
                        ++ii;
                    }
                    table.setInputAdjustDatum(rdh);
                    table.getTable().setHeaderVisible(true);
                    tabItem1.setControl((Control)table.getTable());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (this.tabFolder.getItemCount() > 0) {
                if (this.latestSelection < 0 || this.tabFolder.getItemCount() <= this.latestSelection) {
                    this.latestSelection = 0;
                }
                this.tabFolder.setSelection(this.latestSelection);
            }
        }
    }

    class MyUpdate
    implements Runnable {
        MyUpdate() {
        }

        @Override
        public void run() {
            ImportTableAction.this.update();
        }
    }

    class PopUp
    implements Runnable {
        boolean result;

        public PopUp(boolean result) {
            this.result = result;
        }

        @Override
        public void run() {
            if (this.result) {
                MessageDialog.openInformation((Shell)ImportTableAction.this.fView.getTreeViewer().getTree().getShell(), (String)"done CSV Import", (String)"Job completed successfully");
            } else {
                MessageDialog.openError((Shell)ImportTableAction.this.fView.getTreeViewer().getTree().getShell(), (String)"done CSV Import", (String)"Job did not complete successfully");
            }
        }
    }
}

