/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.csveditor.dialog.CSVConfigDialog;
import hiro.yoshioka.job.ExportTable2CSVJob;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportTableAction
implements IViewActionDelegate {
    protected Log fLogger = LogFactory.getLog(this.getClass());
    private ExplorerView fView;
    private IDBResource fSelectResource;
    private IDBTable[] fTables;
    private Shell shell;

    public void init(IViewPart view) {
        this.fView = (ExplorerView)view;
        this.shell = this.fView.getTreeViewer().getTree().getShell();
    }

    public void run(IAction action) {
        CSVConfigDialog.MyCsvConfig csvCfg = new CSVConfigDialog.MyCsvConfig(CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
        CSVConfigDialog dialog = new CSVConfigDialog(this.shell, csvCfg);
        if (dialog.open() != 0) {
            return;
        }
        csvCfg = dialog.getConfig();
        IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.csvFolder);
        folder = folder.getFolder(String.format("%tY%<tm%<td_%<tH%<tM", new Date()));
        ExportTable2CSVJob job = null;
        job = this.fSelectResource instanceof IDBSchema ? new ExportTable2CSVJob(folder, (IDBSchema)this.fSelectResource, csvCfg) : new ExportTable2CSVJob(folder, this.fTables, csvCfg);
        job.setConnectionProperties(this.fView.getSelectedConnectionProperties());
        File fDir = ResourceMarker.cnvFile(folder);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Application.exec(new PopUp(event.getResult().isOK(), fDir));
            }
        });
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ConnectionProperties p = this.fView.getSelectedConnectionProperties();
        if (p == null || !p.isConnected()) {
            action.setEnabled(false);
        } else {
            IStructuredSelection sel = (IStructuredSelection)selection;
            this.fSelectResource = (IDBResource)sel.getFirstElement();
            boolean flg = false;
            if (this.fSelectResource instanceof IDBSchema) {
                flg = true;
            } else if (this.fSelectResource instanceof IDBTable) {
                Iterator ite = sel.iterator();
                while (ite.hasNext()) {
                    if (ite.next() instanceof IDBTable) {
                        flg = true;
                        continue;
                    }
                    flg = false;
                    break;
                }
                if (flg) {
                    this.fTables = sel.toList().toArray(new IDBTable[sel.size()]);
                }
            }
            action.setEnabled(flg);
        }
    }

    class PopUp
    implements Runnable {
        boolean result;
        File fDir;

        public PopUp(boolean result, File dir) {
            this.result = result;
            this.fDir = dir;
        }

        @Override
        public void run() {
            if (this.result) {
                MessageDialog.openInformation((Shell)ExportTableAction.this.fView.getTreeViewer().getTree().getShell(), (String)"Notify CSV Export complete successfuly", (String)"Job completed successfully");
                Program.launch((String)this.fDir.getAbsolutePath());
            } else {
                MessageDialog.openError((Shell)ExportTableAction.this.fView.getTreeViewer().getTree().getShell(), (String)"Notify CSV Export not complete", (String)"Job did not complete successfully");
            }
        }
    }
}

