/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view.internal;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.DominoTransactionRequest;
import hiro.yoshioka.sql.engine.MongoTransactionRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.INameFamily;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.sql.util.SQLHistroyManager;
import hiro.yoshioka.sql.util.SelectTableDialog;
import hiro.yoshioka.ui.view.ChartResultSetView;
import hiro.yoshioka.ui.view.HistoryView;
import hiro.yoshioka.ui.view.ResultSetView;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WolfSelectTableDialog
extends SelectTableDialog {
    int latest_width = 700;
    int latest_height = 620;

    public WolfSelectTableDialog(ConnectionProperties connectionProperties, Shell parent, IDBTable dbTable, Integer pref_width, Integer pref_height) {
        super(connectionProperties, parent, dbTable, null);
        if (pref_width != null) {
            this.latest_width = pref_width;
        }
        if (pref_height != null) {
            this.latest_height = pref_height;
        }
    }

    public boolean close() {
        this.latest_width = this.getShell().getBounds().width;
        this.latest_height = this.getShell().getBounds().height;
        return super.close();
    }

    public int getLatest_width() {
        return this.latest_width;
    }

    public int getLatest_height() {
        return this.latest_height;
    }

    protected void createScriptItems() {
        this.fScriptSelection.setItems(ResourceMarker.getScriptFolder().list());
    }

    protected Point getInitialSize() {
        System.out.println("ini_latest_width=" + this.latest_width);
        return new Point(this.latest_width, this.latest_height);
    }

    protected void execute(boolean upd) {
        IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.sqlFolder);
        IFile file = ResourceMarker.createFile(folder, "s__" + this.fIDBTable.getName() + ".sql", upd);
        SQLEditor editor = Application.openNewSQLEditor(file, this.connectionProperties.getDisplayString());
        MongoTransactionRequest req = null;
        this.sqlStatementString = this.sqlText.getText();
        if (this.isMongo()) {
            MongoTransactionRequest mreq;
            req = mreq = new MongoTransactionRequest(SQLOperationType.PREPARED_EXECUTE_QUERY, this.connectionProperties, this.fIDBTable);
            mreq.setQueryUsesedToSearch(this.queryUsesedToSearch);
            mreq.addSqlStatement(this.sqlStatementString);
            mreq.requestForUpdatable = upd;
            mreq.makeBlob = this.btMakeBlob.getSelection();
            mreq.setQueryUsesedToSearch(this.queryUsesedToSearch);
            mreq.setReturnFields(this.returnFields);
            mreq.setOrderBy(this.orderBy);
            mreq.setMaxRownum(this.fMaxRowsFromDB.getSelection());
            mreq.setPartName(this.fIDBTable.getName());
        } else if (this.isDomino()) {
            if (this.unidUsingButton.getSelection()) {
                String[] uids = this.sqlStatementString.split("\r\n|\r|\n");
                req = new DominoTransactionRequest(SQLOperationType.UNID_EXECUTE_QUERY, this.connectionProperties, uids);
                req.setTable(this.fIDBTable);
            } else {
                req = new DominoTransactionRequest(SQLOperationType.PREPARED_EXECUTE_QUERY, this.connectionProperties, this.fIDBTable);
            }
            ((DominoTransactionRequest)req).setDominoSearchQuery(this.dominoSearchQuery);
            req.addSqlStatement(this.getSqlStatementString());
            req.setMaxRownum(this.fMaxRowsFromDB.getSelection());
        } else {
            Object[] bind = null;
            if (this.fCondMap.size() > 0) {
                Collection cv = this.fCondMap.values();
                bind = cv.toArray(new Object[cv.size()]);
            }
            req = new TransactionRequest(SQLOperationType.PREPARED_EXECUTE_QUERY, this.connectionProperties, this.getSqlStatementString(), bind, (INameFamily)this.fIDBTable);
        }
        editor.setText(this.getSqlStatementString());
        editor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), this.connectionProperties.getDisplayString());
        req.setScription(PreferenceUtil.getExternalJars(), ResourceMarker.getScriptFolder());
        for (String key : this.fCondMap.keySet()) {
            req.addWhereCondition(key, (BindObject)this.fCondMap.get(key));
        }
        req.makeBlob = this.btMakeBlob.getSelection();
        req.requestForUpdatable = upd;
        req.setSelectColumnList(this.selectColumnList);
        req.setMaxRownum(this.fMaxRowsFromDB.getSelection());
        editor.setMaxRowNum(this.fMaxRowsFromDB.getSelection());
        req.setPartName(Application.getActiveSQLEditor().getTitle());
        req.addListener((IRequestListener)new RequestAdaptor(){
            int total = -1;
            int worked = 0;
            String taskName = "";

            public void beginTask(String taskName, int row) {
                this.total = row;
                this.worked = 0;
                this.taskName = taskName;
                this.setStatus();
            }

            public void worked(int i) {
                this.worked += i;
                this.setStatus();
            }

            private void setStatus() {
                Application.setStatus(String.format("%s [%d/%d]", this.taskName, this.worked, this.total));
            }

            public void called_done(final Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        TransactionRequest tr = (TransactionRequest)request;
                        if (request.getException() != null) {
                            Application.openErrorDialog(Display.getCurrent().getActiveShell(), "errrrror", tr.getException());
                        }
                        if (tr.getRdh() == null) {
                            return;
                        }
                        ResultSetDataHolder2 rdh = tr.getRdh();
                        try {
                            SingleResultSetView part = null;
                            Application.closeView(tr.getTitle());
                            if (tr.getCommentInfo().supportChartResultSet) {
                                part = Application.showAndCreateChartRstView(tr.getTitle());
                                ((ChartResultSetView)part).setInput(rdh, tr.getCommentInfo());
                            } else {
                                part = Application.showAndCreateRstView(tr.getTitle());
                                ((ResultSetView)part).setInput((Request)tr);
                            }
                            WolfSelectTableDialog.this.fLogger.info((Object)("PK=" + WolfSelectTableDialog.this.fIDBTable.getPkPositions()));
                            tr.getRdh().setPkPositions(WolfSelectTableDialog.this.fIDBTable.getPkPositions());
                            part.setPartName(tr.getTitle());
                            part.showBusy(true);
                            rdh.setNamedInformationFromIDBTable(WolfSelectTableDialog.this.fIDBTable, WolfSelectTableDialog.this.fIDBTable.getParent().getName());
                            SQLHistroyManager.getInstance().addStatement(tr);
                            HistoryView history = (HistoryView)Application.findActiveView("HistoryViewID");
                            if (history != null) {
                                history.resetHistory(null);
                            }
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        SQLServerThread.putRequest((Request)req);
        this.close();
    }
}

