/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.ICommandIds;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbsWorkbenchSQLEditorAction
extends Action
implements IUpdate,
ICommandIds {
    protected Log fLogger = LogFactory.getLog(this.getClass());
    protected IWorkbenchWindow fWindow;
    protected IWorkbenchPage fIWorkbenchPage;

    public AbsWorkbenchSQLEditorAction(int style) {
        super("", style);
    }

    public void update() {
        Application.exec(new Runnable(){

            @Override
            public void run() {
                AbsWorkbenchSQLEditorAction.this.setEnabled(false);
                ConnectionProperties p = Application.getActiveSQLEditorConnectionProperties();
                if (p != null && p.isConnected()) {
                    AbsWorkbenchSQLEditorAction.this.setEnabled(true);
                }
            }
        });
    }

    public void configureAction(String text, String toolTipText, ImageDescriptor image) {
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(image);
    }

    protected abstract void execute(SQLEditor var1, ConnectionProperties var2) throws Exception;

    public void run() {
        try {
            this.setEnabled(false);
            SQLEditor editor = Application.getActiveSQLEditor();
            ConnectionProperties p = Application.getActiveSQLEditorConnectionProperties();
            this.execute(editor, p);
        }
        catch (Exception e) {
            this.fLogger.error((Object)"", (Throwable)e);
        }
    }

    public void dispose() {
    }

    public void setWorkbenchPage(IWorkbenchPage page) {
        this.fIWorkbenchPage = page;
    }
}

