/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.ui.editor.SQLAnnotationHover;
import hiro.yoshioka.sql.ui.editor.SQLCodeScanner;
import hiro.yoshioka.sql.ui.editor.SQLColorProvider;
import hiro.yoshioka.sql.ui.editor.SQLCompletionProcessorUsingAST;
import hiro.yoshioka.sql.ui.editor.SQLTextHover;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.RGB;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    SQLCompletionProcessorUsingAST _myProcessor = new SQLCompletionProcessorUsingAST();
    protected SQLColorProvider _sqlColorProvider;
    private SQLCodeScanner _sqlCodeScanner;

    public SQLCompletionProcessorUsingAST getSQLCompletionProcessor() {
        return this._myProcessor;
    }

    public SQLSourceViewerConfiguration(SQLColorProvider colors) {
        this._sqlColorProvider = colors;
        this._sqlCodeScanner = new SQLCodeScanner(colors);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new SQLAnnotationHover();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__sql_stringfunction", "__sql_systemfunction", "__sql_timedatefunction", "__sql_string", "__sql_default", "__sql_number", "__sql_singleline_comment", "__sql_multiline_comment"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (!PreferenceUtil.getBoolean("BOOLEAN_CONTENT_ASSIST_ACTIVATION")) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)this._myProcessor, "__dftl_partition_content_type");
        assistant.enableAutoActivation(PreferenceUtil.getBoolean("BOOLEAN_CONTENT_ASSIST_AUTO_ACTIVATION"));
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.setContextInformationPopupBackground(this._sqlColorProvider.getColor(new RGB(150, 250, 0)));
        sourceViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent arg0) {
                if (arg0.stateMask == 262144 && arg0.character == ' ') {
                    assistant.showPossibleCompletions();
                }
            }
        });
        return assistant;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this._sqlCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new SQLTextHover();
    }

    public void setConnectionProperties(ConnectionProperties myConnectionPropeteis) {
        this._sqlCodeScanner.setConnectionProperties(this._sqlColorProvider, myConnectionPropeteis);
    }
}

