/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor;

import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.ast.sql.mongo.MongoAstNode;
import hiro.yoshioka.ast.sql.mongo.MongoToken;
import hiro.yoshioka.ast.sql.util.IProposalableParserUtil;
import hiro.yoshioka.ast.sql.util.ProposalParserFactory;
import hiro.yoshioka.ast.sql.view.ASTTreeContentProvider;
import hiro.yoshioka.ast.sql.view.ASTTreeLabelProvider;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.params.IConnectionPropertiesChangeListener;
import hiro.yoshioka.sql.params.PropetiesChangeType;
import hiro.yoshioka.sql.ui.editor.ChangeBackGroundImageAction;
import hiro.yoshioka.sql.ui.editor.ExecuteSelectedSQLAction;
import hiro.yoshioka.sql.ui.editor.KeyBigAction;
import hiro.yoshioka.sql.ui.editor.Messages;
import hiro.yoshioka.sql.ui.editor.SQL2JavaStringAction;
import hiro.yoshioka.sql.ui.editor.SQLColorProvider;
import hiro.yoshioka.sql.ui.editor.SQLDocumentProvider;
import hiro.yoshioka.sql.ui.editor.SQLSourceViewerConfiguration;
import hiro.yoshioka.util.ColorNameEnum;
import hiro.yoshioka.util.ColorUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SQLEditor
extends TextEditor
implements IConnectionPropertiesChangeListener {
    private Combo connectionCombo;
    private ConnectionProperties myConnectionPropeteis;
    private Spinner maxRowSpinner;
    private static int LATEST_FOCUSED_EDITOR;
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private AnnotationPainter.IDrawingStrategy projectionAnnotationDrawingStrategy;
    MatchingCharacterPainter painter;
    private MyOutlinePage outlinePage;
    private SQLColorProvider colorManager;
    private ProjectionSupport fProjectionSupport;
    private IProposalableParserUtil fParserUtil;
    private ArrayList<IUpdate> fExecuteActionList = new ArrayList();
    private String preText = "";
    private Label parseMessageLabel;
    private ScheduledExecutorService fScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private AbsSimpleNode[] errorNodes;
    private boolean canUpdatableMode;
    private Future future;

    public SQLEditor() {
        this.colorManager = SQLColorProvider.getInstance();
        SQLSourceViewerConfiguration conf = new SQLSourceViewerConfiguration(this.colorManager);
        this.setSourceViewerConfiguration(conf);
        conf.getSQLCompletionProcessor().setTemplateStore(PreferenceUtil.getTemplateStore());
        this.setDocumentProvider((IDocumentProvider)new SQLDocumentProvider());
        this.getPreferenceStore();
        TextEditorPlugin.getDefault().getPreferenceStore();
        TextEditorPlugin.getDefault().getPreferenceStore().getBoolean("lineNumberRuler");
        TextEditorPlugin.getDefault().getPreferenceStore().getBoolean("printMargin");
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.fOverviewRuler, true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144 || e.stateMask == 0x400000) {
                    switch (e.keyCode) {
                        case 114: 
                        case 118: 
                        case 120: 
                        case 122: {
                            SQLEditor.this.resetParserDelay();
                        }
                    }
                } else if (e.keyCode == 8 || e.keyCode == 32) {
                    SQLEditor.this.resetParserDelay(2000);
                } else if (e.keyCode == 13 || e.keyCode == 10) {
                    SQLEditor.this.resetParserDelay();
                } else if (Character.isLetter(e.character)) {
                    SQLEditor.this.canUpdatableMode = false;
                }
            }
        });
        return viewer;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator());
        SQL2JavaStringAction action = new SQL2JavaStringAction(this.getSourceViewer().getDocument(), true);
        menu.add((IAction)action);
        action = new SQL2JavaStringAction(this.getSourceViewer().getDocument(), false);
        menu.add((IAction)action);
        KeyBigAction action2 = new KeyBigAction(this.getSourceViewer().getDocument(), this.myConnectionPropeteis);
        menu.add((IAction)action2);
        StyledText stext = this.getSourceViewer().getTextWidget();
        ExecuteSelectedSQLAction action3 = new ExecuteSelectedSQLAction(this, this.myConnectionPropeteis, stext.getSelectionText());
        menu.add((IAction)action3);
        ChangeBackGroundImageAction backAction = new ChangeBackGroundImageAction((Composite)stext);
        menu.add((IAction)backAction);
    }

    public String getConnectionDisplayString() {
        return this.connectionCombo.getText();
    }

    public void setConnectionCombo(String[] displays, String select) {
        this.connectionCombo.setItems(displays);
        if (!StringUtil.isEmpty((Object)select)) {
            this.connectionCombo.setText(select);
        }
        this.myConnectionPropeteis = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(select);
        ((SQLSourceViewerConfiguration)this.getSourceViewerConfiguration()).setConnectionProperties(this.myConnectionPropeteis);
    }

    private GridLayout createGridLayout(int num) {
        GridLayout gl = new GridLayout(num, false);
        gl.horizontalSpacing = 0;
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        return gl;
    }

    private void createToolBar(Composite parent) {
        Composite toolBar = new Composite(parent, 0);
        GridLayout gl2 = this.createGridLayout(6);
        gl2.marginLeft = 8;
        gl2.horizontalSpacing = 1;
        toolBar.setLayout((Layout)gl2);
        toolBar.setLayoutData((Object)new GridData(768));
        new Label(toolBar, 2048).setText(Messages.getString("SQLEditor.LB_Connection"));
        this.connectionCombo = new Combo(toolBar, 8);
        GridData gd = new GridData();
        gd.widthHint = 150;
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SQLEditor.this.myConnectionPropeteis = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(SQLEditor.this.connectionCombo.getText());
                ((SQLSourceViewerConfiguration)SQLEditor.this.getSourceViewerConfiguration()).setConnectionProperties(SQLEditor.this.myConnectionPropeteis);
                SQLEditor.this.callListner();
            }
        });
        new Label(toolBar, 2048).setText(Messages.getString("SQLEditor.LB_MaxRow"));
        this.maxRowSpinner = new Spinner(toolBar, 0);
        this.maxRowSpinner.setMaximum(1000000);
        this.maxRowSpinner.setSelection(1000);
        gd = new GridData();
        gd.widthHint = 100;
        this.maxRowSpinner.setLayoutData((Object)gd);
        this.parseMessageLabel = new Label(toolBar, 2048);
        this.parseMessageLabel.setLayoutData((Object)new GridData(768));
        this.parseMessageLabel.setText("");
    }

    public void createPartControl(Composite parent) {
        GridLayout gl = this.createGridLayout(1);
        parent.setLayout((Layout)gl);
        this.createToolBar(parent);
        Composite editorComposite = new Composite(parent, 0);
        editorComposite.setLayout((Layout)new FillLayout());
        editorComposite.setLayoutData((Object)new GridData(1808));
        super.createPartControl(editorComposite);
        ISourceViewer sourceViewer = this.getSourceViewer();
        ITextViewerExtension2 extension = (ITextViewerExtension2)sourceViewer;
        DefaultCharacterPairMatcher matcher = new DefaultCharacterPairMatcher(new char[]{'(', ')', '{', '}', '[', ']'});
        this.painter = new MatchingCharacterPainter(sourceViewer, (ICharacterPairMatcher)matcher);
        this.painter.setColor(ColorUtil.getColor((ColorNameEnum)ColorNameEnum.SELECTION));
        extension.addPainter((IPainter)this.painter);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.info");
        this.fProjectionSupport.setAnnotationPainterDrawingStrategy(this.projectionAnnotationDrawingStrategy);
        this.fProjectionSupport.install();
        SQLServerThread.getSQLServer().addConnectionPropertiesChangedListener((IConnectionPropertiesChangeListener)this);
        this.setTitleImage(ImageManager.getImageDescriptor("action/edit_sql.png").createImage());
        StyledText stext = this.getSourceViewer().getTextWidget();
        stext.setBackgroundImage(ImageManager.getSQLEditorImage());
        stext.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SQLEditor.this.callListner();
                SQLEditor.this.resetParserDelay();
                LATEST_FOCUSED_EDITOR = ((Object)((Object)this)).hashCode();
            }
        });
        ConnectionSettingBean bean = SQLServerThread.getSQLServer().getConnectionSettingBean();
        this.connectionCombo.setItems(bean.getDisplayStrings());
        if (this.connectionCombo.getItemCount() > 0) {
            this.connectionCombo.select(0);
            this.myConnectionPropeteis = bean.getConnectionPropertiesByDisplay(this.connectionCombo.getText());
            ((SQLSourceViewerConfiguration)this.getSourceViewerConfiguration()).setConnectionProperties(this.myConnectionPropeteis);
        }
    }

    public void dispose() {
        try {
            SQLServerThread.getSQLServer().removeConnectionPropertiesChangedListener((IConnectionPropertiesChangeListener)this);
            this.cancelFuture();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.painter.dispose();
        super.dispose();
    }

    public void setText(String target) {
        this.cancelFuture();
        try {
            this.getSourceViewer().getDocument().set(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fLogger.error((Object)e);
        }
        this.resetParserDelay();
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = new MyOutlinePage();
            }
            return this.outlinePage;
        }
        if (this.fProjectionSupport != null && (obj = this.fProjectionSupport.getAdapter(this.getSourceViewer(), adapter)) != null) {
            return obj;
        }
        return super.getAdapter(adapter);
    }

    public String getText(boolean original) {
        String str = this.getSourceViewer().getDocument().get();
        if (original) {
            return str;
        }
        if ((str = str.trim()).endsWith(";")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String getText() {
        return this.getText(false);
    }

    public void setFocus() {
        this.getSourceViewer().getTextWidget().setFocus();
    }

    private void cancelFuture() {
        if (this.future != null && !this.future.isCancelled()) {
            this.fLogger.trace((Object)("cancel:" + this.future));
            this.future.cancel(true);
        }
    }

    private void resetParserDelay(int milli) {
        this.cancelFuture();
        this.future = this.fScheduledExecutorService.schedule(new MyExecutor(), (long)milli, TimeUnit.MILLISECONDS);
    }

    private void resetParserDelay() {
        this.resetParserDelay(1000);
    }

    private void resetParser() {
        try {
            if (this.getConnectionProperties() != null) {
                String target = this.getSourceViewer().getDocument().get();
                if (this.preText.equals(target)) {
                    return;
                }
                this.asyncResetParsedMessage(ColorUtil.getColor((ColorNameEnum)ColorNameEnum.NULL), Messages.getString("SQLEditor.NOW_PARSING"));
                long time = System.currentTimeMillis();
                IProposalableParserUtil pu = this.getUtil();
                this.outlinePage.reset();
                time = System.currentTimeMillis() - time;
                if (pu == null || !pu.wasParseSuccess()) {
                    this.asyncResetParsedMessage(ColorUtil.getColor((ColorNameEnum)ColorNameEnum.CHANGE), String.format(Messages.getString("SQLEditor.PARSE_FAILUER"), time));
                } else {
                    this.asyncResetParsedMessage(null, String.format(Messages.getString("SQLEditor.PARSE_SUCCESS"), time));
                }
            }
            this.callListner();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.fLogger.trace((Object)"", e);
        }
    }

    private void asyncResetParsedMessage(Color bg, String message) {
        Application.exec(new Runnable(){

            @Override
            public void run() {
                SQLEditor.this.parseMessageLabel.setBackground(bg);
                SQLEditor.this.parseMessageLabel.setText(message);
            }
        });
    }

    public synchronized IProposalableParserUtil getUtil() {
        return this.getUtil(false);
    }

    private ConnectionProperties getConnectionProperties() {
        return this.myConnectionPropeteis;
    }

    public synchronized IProposalableParserUtil getUtil(boolean force) {
        ConnectionProperties p = this.getConnectionProperties();
        if (p != null) {
            String target = this.getSourceViewer().getDocument().get();
            boolean change = this.preText.equals(target);
            if (!force && change && this.fParserUtil != null) {
                return this.fParserUtil;
            }
            this.preText = target;
            ProposalParserFactory factory = ProposalParserFactory.createFactory((String)p.getDriverName());
            this.fParserUtil = factory.createParserUtil(target, p.getDBRootResource());
            this.fParserUtil.parse();
        }
        return this.fParserUtil;
    }

    public List<AbsSimpleNode> getErrorAtLine(int lineNumber) {
        ArrayList<AbsSimpleNode> retList = new ArrayList<AbsSimpleNode>();
        int i = 0;
        while (i < this.errorNodes.length) {
            IToken token = this.errorNodes[i].getFirstToken();
            IToken endToken = this.errorNodes[i].getLastToken();
            int first = token.getBeginLine() - 1;
            endToken.getEndLine();
            if (lineNumber == first) {
                retList.add(this.errorNodes[i]);
            }
            ++i;
        }
        return retList;
    }

    public void addUpdateListener(IUpdate executeAction) {
        if (!this.fExecuteActionList.contains(executeAction)) {
            this.fExecuteActionList.add(executeAction);
        }
    }

    private void callListner() {
        int i = 0;
        while (i < this.fExecuteActionList.size()) {
            this.fExecuteActionList.get(i).update();
            ++i;
        }
    }

    public void addTextAfterCursol(String string) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        int widgetOffset = styledText.getCaretOffset();
        int modelOffset = SQLEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)widgetOffset);
        String a1 = sourceViewer.getDocument().get().substring(0, modelOffset);
        String a2 = sourceViewer.getDocument().get().substring(modelOffset);
        this.setText(String.valueOf(a1) + string + a2);
        styledText.setCaretOffset(modelOffset + string.length());
    }

    public boolean isDirty() {
        if (this.getTitle().startsWith("s__")) {
            return false;
        }
        return super.isDirty();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            IFile inputFile = ((FileEditorInput)this.getEditorInput()).getFile();
            if (this.getTitle().toLowerCase().startsWith("s__")) {
                InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), "Input File Name", "Input File Name", "", new IInputValidator(){

                    public String isValid(String arg0) {
                        if (arg0.length() == 0) {
                            return "Name must not null";
                        }
                        File[] children = inputFile.getLocation().toFile().getParentFile().listFiles();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i].getName().equalsIgnoreCase(String.valueOf(arg0) + "." + ResourceMarker.sqlFolder)) {
                                return "Already exists same file";
                            }
                            ++i;
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0) {
                    super.doSave(progressMonitor);
                    IFolder folder = ResourceMarker.getMyProject().getFolder(ResourceMarker.sqlFolder);
                    String fileName = String.valueOf(dlg.getValue()) + "." + ResourceMarker.sqlFolder;
                    IFile copiedFile = folder.getFile(fileName);
                    inputFile.copy(copiedFile.getFullPath(), true, progressMonitor);
                    Application.exec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage page = Application.getWorkbenchPage();
                            String dispName = SQLEditor.this.getConnectionDisplayString();
                            page.closeEditor((IEditorPart)SQLEditor.this, true);
                            SQLEditor editor = (SQLEditor)Application.openNewEditor(copiedFile);
                            editor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), dispName);
                        }
                    });
                }
            } else {
                super.doSave(progressMonitor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getMaxRowNum() {
        return this.maxRowSpinner.getSelection();
    }

    public void setMaxRowNum(int rownum) {
        this.maxRowSpinner.setSelection(rownum);
    }

    public void setCanUpdatableMode(boolean canUpdatableMode) {
        this.canUpdatableMode = canUpdatableMode;
    }

    public boolean isCanUpdatableMode() {
        return this.canUpdatableMode;
    }

    public void changed(PropetiesChangeType type, ConnectionSettingBean bean) {
        this.setConnectionCombo(bean.getDisplayStrings(), this.connectionCombo.getText());
    }

    class MyExecutor
    implements Runnable {
        MyExecutor() {
        }

        @Override
        public void run() {
            SQLEditor.this.resetParser();
        }
    }

    class MyOutlinePage
    extends ContentOutlinePage
    implements Runnable {
        MyOutlinePage() {
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            TreeColumn item = new TreeColumn(this.getTreeViewer().getTree(), 0);
            item.setText("1retu");
            item.setResizable(true);
            item.setWidth(400);
            this.getTreeViewer().setContentProvider((IContentProvider)new ASTTreeContentProvider());
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new ASTTreeLabelProvider());
            this.getTreeViewer().setAutoExpandLevel(4);
        }

        public void reset() {
            Application.exec(this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            super.selectionChanged(event);
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object element = sel.getFirstElement();
            if (element instanceof AbsSimpleNode) {
                StyledText stext = SQLEditor.this.getSourceViewer().getTextWidget();
                try {
                    if (element instanceof MongoAstNode) {
                        MongoAstNode mnode = (MongoAstNode)element;
                        int offset = ((MongoToken)mnode.getFirstToken()).getStart();
                        int endOffset = ((MongoToken)mnode.getFirstToken()).getEnd();
                        SQLEditor.this.selectAndReveal(offset, endOffset - offset);
                    } else {
                        IToken token = ((AbsSimpleNode)element).getFirstToken();
                        IToken endToken = ((AbsSimpleNode)element).getLastToken();
                        int offset = stext.getOffsetAtLine(token.getBeginLine() - 1);
                        int endOffset = stext.getOffsetAtLine(endToken.getEndLine() - 1);
                        SQLEditor.this.selectAndReveal(offset += token.getBeginColumn() - 1, (endOffset += endToken.getEndColumn()) - offset);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }

        private void makeErrorNodeList(AbsSimpleNode node, ArrayList<AbsSimpleNode> list) {
            if (node == null) {
                return;
            }
            AbsSimpleNode[] sn = node.getChildren();
            if (node.containErrorNode) {
                list.add(node);
            } else {
                int i = 0;
                while (i < sn.length) {
                    this.makeErrorNodeList(sn[i], list);
                    ++i;
                }
            }
        }

        @Override
        public void run() {
            if (Application.activeOutline() && SQLEditor.this.fParserUtil != null) {
                try {
                    SQLEditor.this.errorNodes = SQLEditor.this.fParserUtil.getErrorNodes(SQLEditor.this.fParserUtil.getRoot());
                    ArrayList<AbsSimpleNode> list = new ArrayList<AbsSimpleNode>();
                    this.makeErrorNodeList(SQLEditor.this.fParserUtil.getRoot(), list);
                    this.getTreeViewer().setInput((Object)SQLEditor.this.fParserUtil.getRoot());
                    if (SQLEditor.this.errorNodes.length > 0) {
                        this.getTreeViewer().setExpandedElements((Object[])SQLEditor.this.fParserUtil.getNodesPaths(SQLEditor.this.errorNodes[0]));
                    }
                    StyledText styledText = SQLEditor.this.getSourceViewer().getTextWidget();
                    int maxLength = styledText.getText().length();
                    IFile file = ((FileEditorInput)SQLEditor.this.getEditorInput()).getFile();
                    if (file.exists()) {
                        file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        styledText.getTextLimit();
                        int i = 0;
                        while (i < SQLEditor.this.errorNodes.length) {
                            IToken token = SQLEditor.this.errorNodes[i].getFirstToken();
                            IToken endToken = SQLEditor.this.errorNodes[i].getLastToken();
                            int offset = styledText.getOffsetAtLine(token.getBeginLine() - 1);
                            int endOffset = styledText.getOffsetAtLine(endToken.getEndLine() - 1);
                            int length = (endOffset += endToken.getEndColumn()) - (offset += token.getBeginColumn() - 1);
                            if (endOffset > 0 && endOffset <= maxLength) {
                                HashMap<String, Integer> attributes = new HashMap<String, Integer>();
                                MarkerUtilities.setCharStart(attributes, (int)offset);
                                MarkerUtilities.setCharEnd(attributes, (int)(offset + length));
                                int line = token.getBeginLine() - 1;
                                MarkerUtilities.setLineNumber(attributes, (int)(line == -1 ? -1 : line + 1));
                                MarkerUtilities.setMessage(attributes, (String)SQLEditor.this.errorNodes[i].getErrorString());
                                attributes.put("severity", new Integer(2));
                                MarkerUtilities.createMarker((IResource)file, attributes, (String)"org.eclipse.core.resources.problemmarker");
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

