/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator.formatter;

import hiro.yoshioka.generator.FormatArg;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class GenerateFormatDef {
    List<FormatArg> formatArgList;
    String format;
    final String initiaFormat;

    public GenerateFormatDef(String format) {
        this.format = format;
        this.initiaFormat = format;
    }

    public String getInitiaFormat() {
        return this.initiaFormat;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFormatArgList(List<FormatArg> formatArgList) {
        this.formatArgList = formatArgList;
    }

    public String toString() {
        return this.format;
    }

    public String getValue(int grCounter, int griCounter, int totalCounter, Date today) {
        if (this.formatArgList == null) {
            return this.format;
        }
        Object[] args = new Object[this.formatArgList.size()];
        int j = 0;
        while (j < args.length) {
            FormatArg arg = this.formatArgList.get(j);
            switch (arg.type) {
                case DATE: {
                    args[j] = today;
                    break;
                }
                case RANDOM: {
                    Random rand = new Random();
                    args[j] = Math.abs(rand.nextInt(arg.maxValue));
                    break;
                }
                case GROUP_COUNTER: {
                    args[j] = grCounter + arg.additionalValue;
                    break;
                }
                case GROUP_IN_COUNTER: {
                    args[j] = griCounter + arg.additionalValue;
                    break;
                }
                case TOTAL_COUNTER: {
                    args[j] = totalCounter + arg.additionalValue;
                    break;
                }
                default: {
                    args[j] = new Integer(1);
                }
            }
            ++j;
        }
        return String.format(this.format, args);
    }

    public List<FormatArg> getFmtArgTypeList() {
        if (this.formatArgList == null) {
            return Collections.EMPTY_LIST;
        }
        return this.formatArgList;
    }
}

