/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.editor;

import hiro.yoshioka.gef.dnd.DataEditDropTargetListener;
import hiro.yoshioka.gef.part.factory.SchemaEditPartFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorSite;

public class GraphicalViewerCreator {
    private KeyHandler sharedKeyHandler;
    private GraphicalViewer viewer;
    private ActionRegistry actionRegistry;
    private IEditorSite editorSite;

    public GraphicalViewerCreator(IEditorSite editorSite) {
        this.editorSite = editorSite;
    }

    public void createGraphicalViewer(Composite parent) {
        this.viewer = this.createViewer(parent);
    }

    protected GraphicalViewer createViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        viewer.getControl().setBackground(ColorConstants.white);
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)viewer));
        DataEditDropTargetListener listener = new DataEditDropTargetListener((EditPartViewer)viewer);
        viewer.addDropTargetListener((TransferDropTargetListener)listener);
        viewer.setEditPartFactory(this.getEditPartFactory());
        return viewer;
    }

    protected EditPartFactory getEditPartFactory() {
        return new SchemaEditPartFactory();
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }
}

