/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddTaskOptionsPage
extends WizardPage {
    private Text m_descText = null;
    private Combo m_priorityCombo = null;

    public AddTaskOptionsPage(String pageName) {
        super(pageName);
    }

    public AddTaskOptionsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public String getDescription() {
        return this.m_descText.getText();
    }

    public int getPriority() {
        switch (this.m_priorityCombo.getSelectionIndex()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 1;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText("Description:");
        this.m_descText = new Text(composite, 2048);
        this.m_descText.setTextLimit(200);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.m_descText.setLayoutData((Object)gridData);
        this.m_descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddTaskOptionsPage.this.setPageComplete(AddTaskOptionsPage.this.validatePage());
            }
        });
        new Label(composite, 0).setText("Priority:");
        this.m_priorityCombo = new Combo(composite, 12);
        this.m_priorityCombo.add("High");
        this.m_priorityCombo.add("Normal");
        this.m_priorityCombo.add("Low");
        this.m_priorityCombo.select(1);
        this.setDescription("Choose the description and priority of the todo task to be created.");
        this.setPageComplete(false);
    }

    protected boolean validatePage() {
        return this.m_descText.getText().length() > 0;
    }

    public String getTitle() {
        return "Add Todo Task";
    }
}

