/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.views;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.CTabItem;
import org.graysky.eclipse.logwatcher.LogwatcherPlugin;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.watchers.TextFileWatcher;
import org.graysky.eclipse.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WatcherData {
    private TextViewer m_viewer = null;
    private TextFileWatcher m_watcher = null;
    private CTabItem m_tab = null;
    private Vector m_filters = null;
    private boolean m_scroll = true;

    public WatcherData(TextViewer v, TextFileWatcher w, CTabItem t, Vector f) {
        this.setViewer(v);
        this.setWatcher(w);
        this.setTab(t);
        this.setFilters(f);
    }

    public void toXML(Document doc, Node node) {
        Element watcher = doc.createElement("watcher");
        watcher.appendChild(XmlUtils.createElementWithText(doc, "file", this.getWatcher().getFilename()));
        watcher.appendChild(XmlUtils.createElementWithText(doc, "numLines", Integer.toString(this.getWatcher().getNumLines())));
        watcher.appendChild(XmlUtils.createElementWithText(doc, "interval", Integer.toString(this.getWatcher().getInterval())));
        Iterator iter = this.getFilters().iterator();
        while (iter.hasNext()) {
            Filter filter = (Filter)iter.next();
            filter.toXML(doc, watcher);
        }
        node.appendChild(watcher);
    }

    public void dispose() {
        try {
            this.getWatcher().halt();
            if (this.getViewer().getControl() != null) {
                this.getViewer().getControl().dispose();
            }
            this.getTab().dispose();
            Iterator iterator = this.getFilters().iterator();
            while (iterator.hasNext()) {
                Filter element = (Filter)iterator.next();
                element.dispose();
            }
        }
        catch (Throwable throwable) {
            LogwatcherPlugin.getDefault().logError("Error disposing of the entry", null);
        }
    }

    public void setViewer(TextViewer v) {
        this.m_viewer = v;
    }

    public TextViewer getViewer() {
        return this.m_viewer;
    }

    public void setWatcher(TextFileWatcher watcher) {
        this.m_watcher = watcher;
    }

    public TextFileWatcher getWatcher() {
        return this.m_watcher;
    }

    public void setTab(CTabItem tab) {
        this.m_tab = tab;
    }

    public CTabItem getTab() {
        return this.m_tab;
    }

    public void setFilters(Vector filters) {
        this.m_filters = filters;
    }

    public Vector getFilters() {
        return this.m_filters;
    }

    public void setScroll(boolean scroll) {
        this.m_scroll = scroll;
    }

    public boolean isScroll() {
        return this.m_scroll;
    }
}

