/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ParameterBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.BindingGroupSection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.dialogs.MessageDialog;

public class BindingGroupDescriptorProvider
extends AbstractDescriptorProvider {
    private Map<String, ReportItemHandle> referMap = new HashMap<String, ReportItemHandle>();
    private Object input;
    private String[] references;
    public static final String NONE = Messages.getString((String)"BindingPage.None");
    private transient boolean enableAutoCommit = true;
    private DataSetColumnBindingsFormHandleProvider dataSetProvider;
    protected BindingGroupSection section;

    public String getDisplayName() {
        return null;
    }

    protected List getAvailableDataBindingReferenceList(ReportItemHandle element) {
        return element.getAvailableDataSetBindingReferenceList();
    }

    public Object load() {
        String value;
        this.referMap.clear();
        ReportItemHandle element = this.getReportItemHandle();
        int type = element.getDataBindingType();
        List referenceList = this.getAvailableDataBindingReferenceList(element);
        this.references = new String[referenceList.size() + 1];
        this.references[0] = NONE;
        this.referMap.put(this.references[0], null);
        int j = 0;
        int i = 0;
        while (i < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i);
            if (item.getName() != null) {
                this.references[++j] = item.getQualifiedName();
                this.referMap.put(this.references[j], item);
            }
            ++i;
        }
        int tmp = j + 1;
        Arrays.sort(this.references, 1, tmp);
        int i2 = 0;
        while (i2 < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i2);
            if (item.getName() == null) {
                this.references[++j] = String.valueOf(item.getElement().getDefn().getDisplayName()) + " (ID " + item.getID() + ") - " + Messages.getString((String)"BindingPage.ReportItem.NoName");
                this.referMap.put(this.references[j], item);
            }
            ++i2;
        }
        Arrays.sort(this.references, tmp, referenceList.size() + 1);
        switch (type) {
            case 1: {
                DataSetHandle dataset = element.getDataSet();
                if (dataset == null) {
                    value = NONE;
                    break;
                }
                value = dataset.getQualifiedName();
                break;
            }
            case 2: {
                ReportItemHandle reference = element.getDataBindingReference();
                if (reference == null) {
                    value = NONE;
                    break;
                }
                value = reference.getQualifiedName();
                break;
            }
            default: {
                value = NONE;
            }
        }
        BindingInfo info = new BindingInfo(type, value);
        return info;
    }

    public void save(Object saveValue) throws SemanticException {
        if (saveValue instanceof BindingInfo) {
            BindingInfo info = (BindingInfo)saveValue;
            int type = info.getBindingType();
            String value = info.getBindingValue().toString();
            String oldValue = ((BindingInfo)this.load()).getBindingValue().toString();
            block0 : switch (type) {
                case 1: {
                    if (value.equals(NONE)) {
                        value = null;
                    }
                    int ret = 0;
                    if (!(NONE.equals(oldValue) && !this.getReportItemHandle().getColumnBindings().iterator().hasNext() || value != null && value.equals(oldValue))) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret = prefDialog.open();
                    }
                    switch (ret) {
                        case 0: {
                            this.resetDataSetReference(value, true);
                            break;
                        }
                        case 1: {
                            this.resetDataSetReference(value, false);
                            break;
                        }
                        case 2: {
                            this.section.load();
                        }
                    }
                    break;
                }
                case 2: {
                    if (value.equals(NONE)) {
                        value = null;
                    } else if (this.referMap.get(value).getName() == null) {
                        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.haveNoName"), null, Messages.getString((String)"dataBinding.message.haveNoName"), 3, new String[]{Messages.getString((String)"dataBinding.button.OK")}, 0);
                        dialog.open();
                        this.section.load();
                        return;
                    }
                    int ret1 = 0;
                    if (!(NONE.equals(oldValue) && !this.getReportItemHandle().getColumnBindings().iterator().hasNext() || value != null && value.equals(oldValue))) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeReference"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret1 = prefDialog.open();
                    }
                    switch (ret1) {
                        case 0: {
                            this.resetReference(value);
                            break block0;
                        }
                        case 1: {
                            this.section.load();
                        }
                    }
                }
            }
        }
    }

    public String[] getReferences() {
        return this.references;
    }

    public void setReferences(String[] references) {
        this.references = references;
    }

    public String[] getAvailableDatasetItems() {
        String[] dataSets = ChoiceSetFactory.getDataSets();
        String[] newList = new String[dataSets.length + 1];
        newList[0] = NONE;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        return newList;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) == 1;
    }

    private void resetDataSetReference(Object value, boolean clearHistory) {
        try {
            this.startTrans(Messages.getString((String)"DataColumBindingDialog.stackMsg.resetReference"));
            this.getReportItemHandle().setDataBindingReference(null);
            DataSetHandle dataSet = null;
            if (value != null) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(value.toString());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            this.getReportItemHandle().setDataSet(dataSet);
            if (clearHistory) {
                this.getReportItemHandle().getColumnBindings().clearValue();
                this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            this.dataSetProvider.generateAllBindingColumns();
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionUtil.handle((Throwable)e);
        }
        this.section.load();
    }

    private void resetReference(Object value) {
        if (value == null && this.getReportItemHandle().getDataBindingType() == 1) {
            this.resetDataSetReference(null, true);
        } else {
            try {
                this.startTrans(Messages.getString((String)"DataColumBindingDialog.stackMsg.resetReference"));
                ReportItemHandle element = null;
                if (value != null) {
                    element = (ReportItemHandle)SessionHandleAdapter.getInstance().getReportDesignHandle().findElement(value.toString());
                }
                this.getReportItemHandle().setDataBindingReference(element);
                this.commit();
            }
            catch (SemanticException e) {
                this.rollback();
                ExceptionUtil.handle((Throwable)e);
            }
            this.section.load();
        }
    }

    public ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input);
    }

    public boolean isBindingReference() {
        return this.getReportItemHandle().getDataBindingType() == 2;
    }

    protected CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    protected void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    protected void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setDependedProvider(DataSetColumnBindingsFormHandleProvider provider) {
        this.dataSetProvider = provider;
    }

    public DataSetColumnBindingsFormHandleProvider getDependedProvider() {
        return this.dataSetProvider;
    }

    public void setRefrenceSection(BindingGroupSection section) {
        this.section = section;
    }

    public void bindingDialog() {
        ParameterBindingDialog dialog = new ParameterBindingDialog(UIUtil.getDefaultShell(), (DesignElementHandle)this.getReportItemHandle());
        this.startTrans("");
        if (dialog.open() == 0) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    public String getText(int key) {
        switch (key) {
            case 0: {
                return Messages.getString((String)"BindingPage.Dataset.Label");
            }
            case 1: {
                return Messages.getString((String)"parameterBinding.title");
            }
            case 2: {
                return Messages.getString((String)"BindingPage.ReportItem.Label");
            }
        }
        return "";
    }

    public boolean enableBindingButton() {
        return !NONE.equals(((BindingInfo)this.load()).getBindingValue());
    }

    public static class BindingInfo {
        private int bindingType;
        private Object bindingValue;
        private boolean isReadOnly = false;

        public BindingInfo(int type, Object value) {
            this.bindingType = type;
            this.bindingValue = value;
        }

        public BindingInfo() {
        }

        public int getBindingType() {
            return this.bindingType;
        }

        public Object getBindingValue() {
            return this.bindingValue;
        }

        public void setBindingType(int bindingType) {
            this.bindingType = bindingType;
        }

        public void setBindingValue(Object bindingValue) {
            this.bindingValue = bindingValue;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public void setReadOnly(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }
    }
}

