/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor;
import org.eclipse.birt.report.engine.script.internal.AutoTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ImageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.PageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnPageBreakScriptVisitor
extends DefaultReportItemVisitorImpl {
    protected static Logger logger = Logger.getLogger(LocalizedContentVisitor.class.getName());
    private ExecutionContext context;
    private OnPageBreakExecutor executor;

    public OnPageBreakScriptVisitor(ExecutionContext context) {
        this.context = context;
        this.executor = new OnPageBreakExecutor();
    }

    public void onPageStart(Report report, PageContent pageContent, Collection<IContent> contents) {
        ReportScriptExecutor.handleOnPageStartScript(report, this.context, pageContent, contents);
    }

    public void onPageStart(PageContent pageContent, Collection<IContent> contents) {
        PageScriptExecutor.handleOnPageStartScript(this.context, pageContent, contents);
    }

    public void onPageEnd(Report report, PageContent pageContent, Collection<IContent> contents) {
        ReportScriptExecutor.handleOnPageEndScript(report, this.context, pageContent, contents);
    }

    public void onPageEnd(PageContent pageContent, Collection<IContent> contents) {
        PageScriptExecutor.handleOnPageEndScript(this.context, pageContent, contents);
    }

    public IContent onPageBreak(IContent content) {
        ReportItemDesign design = this.getGenerateDesign(content);
        if (design != null) {
            Object value = design.accept(this.executor, content);
            return (IContent)value;
        }
        return content;
    }

    private ReportItemDesign getGenerateDesign(IContent content) {
        Object design = content.getGenerateBy();
        if (design instanceof ReportItemDesign) {
            return (ReportItemDesign)design;
        }
        if (design instanceof ReportItemHandle) {
            IReportContent reportContent = content.getReportContent();
            Report reportDesign = reportContent.getDesign();
            return reportDesign.findDesign((ReportElementHandle)((ReportItemHandle)design));
        }
        return null;
    }

    private class OnPageBreakExecutor
    extends DefaultReportItemVisitorImpl {
        private OnPageBreakExecutor() {
        }

        public Object visitAutoTextItem(AutoTextItemDesign autoText, Object value) {
            AutoTextScriptExecutor.handleOnPageBreak((IAutoTextContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitBand(BandDesign band, Object value) {
            return this.visitReportItem(band, value);
        }

        public Object visitCell(CellDesign cell, Object value) {
            CellScriptExecutor.handleOnPageBreak((ICellContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            DataItemScriptExecutor.handleOnPageBreak((IDataContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            return this.visitReportItem(item, value);
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            return this.visitReportItem(container, value);
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            GridScriptExecutor.handleOnPageBreak((ITableContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitGroup(GroupDesign group, Object value) {
            return this.visitReportItem(group, value);
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            ImageScriptExecutor.handleOnPageBreak((IContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitLabelItem(LabelItemDesign label, Object value) {
            LabelScriptExecutor.handleOnPageBreak((ILabelContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitListBand(ListBandDesign band, Object value) {
            return this.visitReportItem(band, value);
        }

        public Object visitListGroup(ListGroupDesign group, Object value) {
            ListGroupScriptExecutor.handleOnPageBreak((IListGroupContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitListItem(ListItemDesign list, Object value) {
            ListScriptExecutor.handleOnPageBreak((IListContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitListing(ListingDesign listing, Object value) {
            return this.visitReportItem(listing, value);
        }

        public Object visitDynamicTextItem(DynamicTextItemDesign dynamicText, Object value) {
            DynamicTextScriptExecutor.handleOnPageBreak((IContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitRow(RowDesign row, Object value) {
            RowScriptExecutor.handleOnPageBreak((IRowContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitTableBand(TableBandDesign band, Object value) {
            return this.visitReportItem(band, value);
        }

        public Object visitTableGroup(TableGroupDesign group, Object value) {
            TableGroupScriptExecutor.handleOnPageBreak((ITableGroupContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            TableScriptExecutor.handleOnPageBreak((ITableContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitTemplate(TemplateDesign template, Object value) {
            TextItemScriptExecutor.handleOnPageBreak((IContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            TextItemScriptExecutor.handleOnPageBreak((IContent)value, OnPageBreakScriptVisitor.this.context);
            return value;
        }
    }
}

