/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.birt.report.engine.layout.pdf.font.CharSegment;

public class CompositeFontConfig {
    String fontName;
    String defaultFont;
    CharSegment[] specialCharacters;
    LinkedHashSet allFonts = new LinkedHashSet();
    HashMap fontCatalogs = new HashMap();
    HashMap charSegments = new HashMap();

    CompositeFontConfig(String fontName) {
        this.fontName = fontName;
    }

    CompositeFontConfig(CompositeFontConfig config) {
        this.fontName = config.fontName;
        this.defaultFont = config.defaultFont;
        this.fontCatalogs.putAll(config.fontCatalogs);
        this.charSegments.putAll(config.charSegments);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void addFont(String font, String catalog) {
        if (!this.allFonts.contains(font)) {
            this.allFonts.add(font);
        }
        if (catalog != null) {
            this.fontCatalogs.put(font, catalog);
        }
    }

    public Collection getAllFonts() {
        return this.allFonts;
    }

    public Collection getFontByCatalog(String catalog) {
        ArrayList<String> fonts = new ArrayList<String>();
        for (String fontName : this.allFonts) {
            String fontCatalog = (String)this.fontCatalogs.get(fontName);
            if (catalog != fontCatalog && (catalog == null || !catalog.equals(fontCatalog))) continue;
            fonts.add(fontName);
        }
        return fonts;
    }

    public void addCharSegment(String fontName, CharSegment[] segment) {
        this.charSegments.put(fontName, segment);
    }

    public void setSpecialCharacters(CharSegment[] segment) {
        this.specialCharacters = segment;
    }

    public CharSegment[] getSpecialCharacters() {
        return this.specialCharacters;
    }

    public CharSegment[] getCharSegment(String name) {
        return (CharSegment[])this.charSegments.get(name);
    }

    public Map getAllCharSegments() {
        return this.charSegments;
    }

    public void merge(CompositeFontConfig config) {
        this.fontCatalogs.putAll(config.fontCatalogs);
        this.charSegments.putAll(config.charSegments);
    }
}

