/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.dom;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.w3c.dom.css.CSSValue;

public class CellMergedStyle
extends AbstractStyle {
    IStyle cellStyle;
    IStyle rowStyle;
    IStyle columnStyle;

    public CellMergedStyle(ICellContent cell) {
        super(cell.getCSSEngine());
        this.cellStyle = cell.getStyle();
        IElement parent = cell.getParent();
        if (parent instanceof IRowContent) {
            int columnId;
            IRowContent row = (IRowContent)parent;
            this.rowStyle = row.getStyle();
            ITableContent table = row.getTable();
            if (table != null && (columnId = cell.getColumn()) >= 0 && columnId < table.getColumnCount()) {
                IColumn column = table.getColumn(columnId);
                this.columnStyle = column.getStyle();
            }
        }
    }

    public CSSValue getProperty(int index) {
        CSSValue rowValue;
        if (this.cellStyle != null && this.cellStyle.getProperty(index) != null) {
            return null;
        }
        if (this.columnStyle == null) {
            return null;
        }
        CSSValue value = this.columnStyle.getProperty(index);
        if (value == null) {
            return null;
        }
        if (!this.engine.isInheritedProperty(index)) {
            CSSValue rowValue2;
            if (this.isBackgroundProperties(index) && this.rowStyle != null && (rowValue2 = this.rowStyle.getProperty(index)) != null) {
                return null;
            }
            if (index == 38 && this.rowStyle != null && (rowValue2 = this.rowStyle.getProperty(index)) != null) {
                return null;
            }
        } else if (this.rowStyle != null && (rowValue = this.rowStyle.getProperty(index)) != null) {
            return null;
        }
        return value;
    }

    public boolean isEmpty() {
        if (this.cellStyle != null && !this.cellStyle.isEmpty()) {
            return false;
        }
        if (this.rowStyle != null && !this.rowStyle.isEmpty()) {
            return false;
        }
        return this.columnStyle == null || this.columnStyle.isEmpty();
    }

    public void setProperty(int index, CSSValue value) {
    }

    private boolean isBackgroundProperties(int index) {
        return 25 == index || 52 == index || 49 == index || 15 == index;
    }
}

