/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IProgressMonitor;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.DataExtractionTaskV0;
import org.eclipse.birt.report.engine.api.impl.DataExtractionTaskV1;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;

public class DataExtractionTask
implements IDataExtractionTask {
    IDataExtractionTask task;
    TimeZone timeZone = TimeZone.getDefault();

    public DataExtractionTask(ReportEngine engine, IReportDocument reader) throws EngineException {
        String version = reader.getProperty("extraction");
        if ("0".equals(version)) {
            this.task = new DataExtractionTaskV0(engine, reader);
        } else if ("1".equals(version)) {
            this.task = new DataExtractionTaskV1(engine, reader);
        }
    }

    public void addScriptableJavaObject(String jsName, Object obj) {
        this.task.addScriptableJavaObject(jsName, obj);
    }

    public void cancel() {
        this.task.cancel();
    }

    public void cancel(Object signal) {
        this.task.cancel(signal);
    }

    public void close() {
        this.task.close();
    }

    public IExtractionResults extract() throws EngineException {
        return this.task.extract();
    }

    public Map getAppContext() {
        return this.task.getAppContext();
    }

    public boolean getCancelFlag() {
        return this.task.getCancelFlag();
    }

    public IReportEngine getEngine() {
        return this.task.getEngine();
    }

    public List getErrors() {
        return this.task.getErrors();
    }

    public int getID() {
        return this.task.getID();
    }

    public Locale getLocale() {
        return this.task.getLocale();
    }

    public List getMetaData() throws EngineException {
        return this.task.getMetaData();
    }

    public Object getParameterDisplayText(String name) {
        return this.task.getParameterDisplayText(name);
    }

    public Object getParameterValue(String name) {
        return this.task.getParameterValue(name);
    }

    public HashMap getParameterValues() {
        return this.task.getParameterValues();
    }

    public IReportRunnable getReportRunnable() {
        return this.task.getReportRunnable();
    }

    public List getResultSetList() throws EngineException {
        return this.task.getResultSetList();
    }

    public int getStatus() {
        return this.task.getStatus();
    }

    public ULocale getULocale() {
        return this.task.getULocale();
    }

    public void selectColumns(String[] columnNames) {
        this.task.selectColumns(columnNames);
    }

    public void selectResultSet(String resultSetName) {
        this.task.selectResultSet(resultSetName);
    }

    public void setAppContext(Map context) {
        this.task.setAppContext(context);
    }

    public void setDataSource(IDocArchiveReader dataSource) {
        this.task.setDataSource(dataSource);
    }

    public void setDataSource(IDocArchiveReader dataSource, String reportlet) {
        this.task.setDataSource(dataSource, reportlet);
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.task.setFilters(simpleFilterExpression);
    }

    public void setSorts(ISortDefinition[] simpleSortExpression) {
        this.task.setSorts(simpleSortExpression);
    }

    public void setMaxRows(int maxRows) {
        this.task.setMaxRows(maxRows);
    }

    public void setInstanceID(InstanceID iid) {
        this.task.setInstanceID(iid);
    }

    public void setLocale(Locale locale) {
        this.task.setLocale(locale);
    }

    public void setLocale(ULocale locale) {
        this.task.setLocale(locale);
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
        this.task.setTimeZone(this.timeZone);
    }

    public void setParameter(String name, Object value, String displayText) {
        this.task.setParameter(name, value, displayText);
    }

    public void setParameter(String name, Object[] values, String[] displayText) {
        this.task.setParameter(name, values, displayText);
    }

    public void setParameterDisplayText(String name, String displayText) {
        this.task.setParameterDisplayText(name, displayText);
    }

    public void setParameterDisplayText(String name, String[] displayText) {
        this.task.setParameterDisplayText(name, displayText);
    }

    public void setParameterValue(String name, Object value) {
        this.task.setParameterValue(name, value);
    }

    public void setParameterValue(String name, Object[] values) {
        this.task.setParameterValue(name, values);
    }

    public void setParameterValues(Map params) {
        this.task.setParameterValues(params);
    }

    public boolean validateParameters() {
        return this.task.validateParameters();
    }

    public Logger getLogger() {
        return this.task.getLogger();
    }

    public int getTaskType() {
        return this.task.getTaskType();
    }

    public void setErrorHandlingOption(int option) {
        this.task.setErrorHandlingOption(option);
    }

    public void setLogger(Logger logger) {
        this.task.setLogger(logger);
    }

    public void extract(IExtractionOption option) throws BirtException {
        this.task.extract(option);
    }

    public void setStartRow(int startRow) {
        this.task.setStartRow(startRow);
    }

    public void setUserACL(String[] acl) {
        this.task.setUserACL(acl);
    }

    public void setDistinctValuesOnly(boolean distinct) {
        this.task.setDistinctValuesOnly(distinct);
    }

    public void setCubeExportEnabled(boolean isCubeExportEnabled) {
        this.task.setCubeExportEnabled(isCubeExportEnabled);
    }

    public boolean isCubeExportEnabled() {
        return this.task.isCubeExportEnabled();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.task.setProgressMonitor(monitor);
    }

    public void setStatusHandler(IStatusHandler handler) {
        this.task.setStatusHandler(handler);
    }
}

