/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.script.JSExpressionContext;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataSetParameterBindingInputDialog
extends BaseDialog {
    private static final String LABEL_NAME = Messages.getString((String)"DataSetParameterBindingInputDialog.Label.Name");
    private static final String LABEL_DATA_TYPE = Messages.getString((String)"DataSetParameterBindingInputDialog.Label.DataType");
    private static final String LABEL_VALUE = Messages.getString((String)"DataSetParameterBindingInputDialog.Label.Value");
    private static final String DIALOG_TITLE = Messages.getString((String)"DataSetParameterBindingInputDialog.Title");
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("DataSetParam").getMember("dataType").getAllowedChoices();
    private Label nameLabel;
    private Label typeLabel;
    private Text valueEditor;
    private Expression value;
    private DataSetParameterHandle handle;
    private JSExpressionContext provider;

    public DataSetParameterBindingInputDialog(Shell parentShell, DataSetParameterHandle handle, JSExpressionContext provider) {
        super(parentShell, DIALOG_TITLE);
        this.handle = handle;
        this.provider = provider;
    }

    public DataSetParameterBindingInputDialog(DataSetParameterHandle handle, JSExpressionContext provider) {
        this(UIUtil.getDefaultShell(), handle, provider);
    }

    protected boolean initDialog() {
        this.nameLabel.setText(this.handle.getName());
        this.typeLabel.setText(this.getParameterDataTypeDisplayName(this.handle.getParameterDataType()));
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.valueEditor, this.value);
        return true;
    }

    private String getParameterDataTypeDisplayName(String type) {
        IChoice choice = DATA_TYPE_CHOICE_SET.findChoice(type);
        if (choice != null) {
            return choice.getDisplayName();
        }
        return type;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        composite.setLayout((Layout)layout);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.DataSetParameterBindingInputDialog_ID");
        new Label(composite, 0).setText(LABEL_NAME);
        this.nameLabel = new Label(composite, 0);
        this.nameLabel.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(LABEL_DATA_TYPE);
        this.typeLabel = new Label(composite, 0);
        this.typeLabel.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(LABEL_VALUE);
        Composite valueComposite = new Composite(composite, 0);
        valueComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        valueComposite.setLayoutData((Object)new GridData(768));
        this.valueEditor = new Text(valueComposite, 2052);
        GridData gd = new GridData(768);
        gd.minimumWidth = 250;
        this.valueEditor.setLayoutData((Object)gd);
        ExpressionButtonUtil.createExpressionButton(valueComposite, (Control)this.valueEditor, this.provider.getExpressionProvider(), this.provider.getContextObject());
        gd = new GridData(768);
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)gd);
        return composite;
    }

    protected void okPressed() {
        this.setResult(new Expression((Object)this.valueEditor.getText(), (String)this.valueEditor.getData("exprType")));
        super.okPressed();
    }

    public void setValue(Expression value) {
        this.value = value;
    }
}

