/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractPopupSheet
implements ITaskPopupSheet {
    private transient ChartWizardContext context;
    private transient Composite cmpTop = null;
    private boolean needRefresh = false;
    private String strTitle;

    public AbstractPopupSheet(String title, ChartWizardContext context, boolean needRefresh) {
        this.strTitle = title;
        this.context = context;
        this.needRefresh = needRefresh;
    }

    protected abstract Composite getComponent(Composite var1);

    protected void bindHelp(Composite parent) {
    }

    public Composite getUI(Composite parent) {
        this.cmpTop = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.cmpTop.setLayout((Layout)layout);
        this.bindHelp(this.cmpTop);
        Composite components = this.getComponent(this.cmpTop);
        GridData gd = (GridData)components.getLayoutData();
        if (gd == null) {
            components.setLayoutData((Object)new GridData(1808));
        } else {
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
        }
        Label lblSeparator = new Label(this.cmpTop, 258);
        lblSeparator.setLayoutData((Object)new GridData(768));
        Composite cmpBar = new Composite(this.cmpTop, 0);
        GridLayout layout2 = new GridLayout(2, false);
        cmpBar.setLayout((Layout)layout2);
        this.createCloseButton(cmpBar);
        this.createHelpControl(cmpBar);
        return this.cmpTop;
    }

    private ToolBar createCloseButton(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(UIHelper.getImage((String)"icons/obj16/arrow.gif"));
        item.setToolTipText(Messages.getString("AbstractPopupSheet.Label.Close"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPopupSheet.this.cmpTop != null && !AbstractPopupSheet.this.cmpTop.isDisposed()) {
                    AbstractPopupSheet.this.cmpTop.getShell().close();
                }
            }
        });
        return toolBar;
    }

    private Control createHelpControl(Composite parent) {
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage != null) {
            return this.createHelpImageButton(parent, helpImage);
        }
        return this.createHelpLink(parent);
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(Messages.getString("AbstractPopupSheet.Label.Help"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPopupSheet.this.helpPressed();
            }
        });
        return toolBar;
    }

    private Link createHelpLink(Composite parent) {
        Link link = new Link(parent, 524352);
        link.setLayoutData((Object)new GridData(64));
        link.setText("<a>" + IDialogConstants.HELP_LABEL + "</a>");
        link.setToolTipText(IDialogConstants.HELP_LABEL);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPopupSheet.this.helpPressed();
            }
        });
        return link;
    }

    private void helpPressed() {
        Control c = this.cmpTop.getDisplay().getFocusControl();
        while (c != null) {
            if (c.isListening(28)) {
                c.notifyListeners(28, new Event());
                break;
            }
            c = c.getParent();
        }
    }

    public void refreshComponent(Composite parent) {
        if (this.needRefresh) {
            if (this.cmpTop != null && !this.cmpTop.isDisposed()) {
                this.cmpTop.dispose();
            }
            this.getUI(parent);
            parent.layout();
            parent.pack();
        }
    }

    protected ChartWizardContext getContext() {
        return this.context;
    }

    protected Chart getChart() {
        return this.getContext().getModel();
    }

    protected void setTitle(String title) {
        this.strTitle = title;
    }

    public String getTitle() {
        return this.strTitle;
    }
}

