/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.ChartSlider;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PieSeriesAttributeComposite
extends Composite
implements Listener,
SelectionListener,
ModifyListener {
    private static final String[] MINMUM_SLICE_ITEMS = new String[]{Messages.getString("PieBottomAreaComponent.Label.Percentage"), Messages.getString("PieBottomAreaComponent.Label.Value")};
    private Group grpLeaderLine = null;
    private FillChooserComposite fccSliceOutline = null;
    private ChartCombo cmbLeaderLine = null;
    private ChartSpinner iscLeaderLength = null;
    private LineAttributesComposite liacLeaderLine = null;
    private PieSeries series = null;
    private PieSeries defSeries = DefaultValueProvider.defPieSeries();
    private static final int MAX_LEADER_LENGTH = 200;
    private ChartWizardContext context;
    private TextEditorComposite txtExplode;
    private Button btnBuilder;
    private ChartSpinner iscExplosion;
    private ChartSlider sRatio;
    private ChartSlider sRotation;
    private ChartCheckbox btnDirection;
    private AbstractChartNumberEditor txtInnerRadius;
    private ChartCombo cmbInnerRadiusPercent;
    private Label lblInnerRadiusPercent;
    private static final String TOOLTIP_EXPLODE_SLICE_WHEN = Messages.getString("PieBottomAreaComponent.Label.TheExplosionCondition");
    private static final String TOOLTIP_EXPLOSION_DISTANCE = Messages.getString("PieBottomAreaComponent.Label.TheAmplitudeOfTheExplosion");
    private static final String TOOLTIP_RATIO = Messages.getString("PieBottomAreaComponent.Label.TheRatioOfTheChart");
    private static final String TOOLTIP_ROTATION = Messages.getString("PiesBottomAreaComponent.Label.TheRotationOfTheChart");
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public PieSeriesAttributeComposite(Composite parent, int style, Series series, ChartWizardContext context) {
        super(parent, style);
        this.context = context;
        if (!(series instanceof PieSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "PieSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (PieSeries)series;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatPieChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 2;
        glContent.marginWidth = 4;
        this.setLayout((Layout)glContent);
        this.grpLeaderLine = new Group((Composite)this, 0);
        GridData gdGRPLeaderLine = new GridData(1808);
        this.grpLeaderLine.setLayoutData((Object)gdGRPLeaderLine);
        GridLayout glLeaderLine = new GridLayout();
        glLeaderLine.numColumns = 2;
        glLeaderLine.marginHeight = 0;
        glLeaderLine.marginWidth = 2;
        glLeaderLine.verticalSpacing = 0;
        this.grpLeaderLine.setLayout((Layout)glLeaderLine);
        this.grpLeaderLine.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLine"));
        this.liacLeaderLine = new LineAttributesComposite((Composite)this.grpLeaderLine, 0, this.getLeaderLineAttributesStyle(), this.context, this.series.getLeaderLineAttributes(), this.defSeries.getLeaderLineAttributes());
        GridData gdLIACLeaderLine = new GridData(768);
        gdLIACLeaderLine.horizontalSpan = 2;
        this.liacLeaderLine.setLayoutData(gdLIACLeaderLine);
        this.liacLeaderLine.addListener(this);
        Composite cmpStyle = new Composite((Composite)this.grpLeaderLine, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        cmpStyle.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        cmpStyle.setLayoutData((Object)gd);
        this.createLeaderLineStyle(cmpStyle);
        Label lblLeaderSize = new Label(cmpStyle, 0);
        GridData gdLBLLeaderSize = new GridData();
        lblLeaderSize.setLayoutData((Object)gdLBLLeaderSize);
        lblLeaderSize.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLineLength"));
        Composite comp = new Composite(cmpStyle, 0);
        GridLayout gl2 = new GridLayout(2, false);
        gl2.marginWidth = 0;
        gl2.marginHeight = 0;
        comp.setLayout((Layout)gl2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.iscLeaderLength = this.context.getUIFactory().createChartSpinner(comp, 2048, (EObject)this.series, "leaderLineLength", true);
        GridData gdISCLeaderLength = new GridData(768);
        gdISCLeaderLength.horizontalSpan = 2;
        this.iscLeaderLength.setLayoutData((Object)gdISCLeaderLength);
        this.iscLeaderLength.getWidget().setMinimum(0);
        this.iscLeaderLength.getWidget().setMaximum(200);
        this.iscLeaderLength.getWidget().setSelection((int)this.series.getLeaderLineLength());
        Composite cmpRight = new Composite((Composite)this, 0);
        cmpRight.setLayout((Layout)new GridLayout(3, false));
        cmpRight.setLayoutData((Object)new GridData(1808));
        Label lblInnerRadius = new Label(cmpRight, 0);
        lblInnerRadius.setText(Messages.getString("PieSeriesAttributeComposite.Button.InnerRadius"));
        comp = new Composite(cmpRight, 0);
        gd2 = new GridData(768);
        gd2.horizontalSpan = 3;
        comp.setLayoutData((Object)gd2);
        gl2 = new GridLayout(3, false);
        gl2.marginLeft = 0;
        gl2.marginTop = 0;
        gl2.marginRight = 0;
        gl2.marginBottom = 0;
        gl2.marginWidth = 0;
        gl2.marginHeight = 0;
        comp.setLayout((Layout)gl2);
        this.cmbInnerRadiusPercent = this.context.getUIFactory().createChartCombo(comp, 12, (EObject)this.series, "innerRadiusPercent", Messages.getString("PieBottomAreaComponent.Label.Percentage"));
        this.cmbInnerRadiusPercent.setItems(MINMUM_SLICE_ITEMS);
        this.cmbInnerRadiusPercent.setItemData(MINMUM_SLICE_ITEMS);
        this.cmbInnerRadiusPercent.setSelection(this.series.isInnerRadiusPercent() ? Messages.getString("PieBottomAreaComponent.Label.Percentage") : Messages.getString("PieBottomAreaComponent.Label.Value"));
        this.cmbInnerRadiusPercent.addSelectionListener((SelectionListener)this);
        this.txtInnerRadius = this.context.getUIFactory().createChartNumberEditor(comp, 2048, "%", (EObject)this.series, "innerRadius");
        new TextNumberEditorAssistField(this.txtInnerRadius.getTextControl(), null);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.txtInnerRadius.setLayoutData((Object)gridData);
        this.txtInnerRadius.setValue(this.series.getInnerRadius());
        this.txtInnerRadius.addModifyListener((ModifyListener)this);
        this.lblInnerRadiusPercent = this.txtInnerRadius.getUnitLabel();
        this.lblInnerRadiusPercent.setVisible(this.series.isInnerRadiusPercent());
        this.createRotation(cmpRight);
        this.createSeriesDetail(cmpRight);
        this.updateInnerRadiusStates();
    }

    protected int getLeaderLineAttributesStyle() {
        return 31;
    }

    protected void createLeaderLineStyle(Composite cmpStyle) {
        Label lblLeaderStyle = new Label(cmpStyle, 0);
        GridData gdLBLLeaderStyle = new GridData();
        lblLeaderStyle.setLayoutData((Object)gdLBLLeaderStyle);
        lblLeaderStyle.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.LeaderLineStyle"));
        this.cmbLeaderLine = this.context.getUIFactory().createChartCombo(cmpStyle, 12, (EObject)this.series, "leaderLineStyle", this.defSeries.getLeaderLineStyle().getName());
        GridData gdCMBLeaderLine = new GridData(768);
        this.cmbLeaderLine.setLayoutData((Object)gdCMBLeaderLine);
        this.cmbLeaderLine.addSelectionListener((SelectionListener)this);
        NameSet ns = LiteralHelper.leaderLineStyleSet;
        this.cmbLeaderLine.setItems(ns.getDisplayNames());
        this.cmbLeaderLine.setItemData(ns.getNames());
        this.cmbLeaderLine.setSelection(this.series.getLeaderLineStyle().getName());
    }

    protected void createRotation(Composite cmpRight) {
        Label lblRatio = new Label(cmpRight, 0);
        lblRatio.setText(Messages.getString("PieBottomAreaComponent.Label.Ratio"));
        lblRatio.setToolTipText(TOOLTIP_RATIO);
        this.sRatio = this.context.getUIFactory().createChartSlider(cmpRight, 256, (EObject)this.series, "ratio");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.sRatio.setRatio(10.0);
        this.sRatio.setLayoutData((Object)gridData);
        this.sRatio.setValues((int)(this.series.getRatio() * 10.0), 1, 101, 1, 1, 10);
        this.sRatio.setToolTipText(String.valueOf(this.series.getRatio()));
        this.sRatio.setEnabled(true);
        this.sRatio.addSelectionListener((SelectionListener)this);
        Label lblRotation = new Label(cmpRight, 0);
        lblRotation.setText(Messages.getString("PieBottomAreaComponent.Label.Rotation"));
        lblRotation.setToolTipText(TOOLTIP_ROTATION);
        this.sRotation = this.context.getUIFactory().createChartSlider(cmpRight, 256, (EObject)this.series, "rotation");
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.sRotation.setLayoutData((Object)gridData2);
        this.sRotation.setValues((int)this.series.getRotation(), 0, 360, 1, 1, 10);
        this.sRotation.setToolTipText(String.valueOf(this.series.getRotation()));
        this.sRotation.setEnabled(true);
        this.sRotation.addSelectionListener((SelectionListener)this);
        this.btnDirection = this.context.getUIFactory().createChartCheckbox(cmpRight, 0, this.defSeries.isClockwise());
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.btnDirection.setLayoutData((Object)gd);
        this.btnDirection.setText(Messages.getString("PieSeriesAttributeComposite.Button.Direction"));
        this.btnDirection.setToolTipText(Messages.getString("PieSeriesAttributeComposite.Button.Direction.ToolTipText"));
        this.btnDirection.setSelectionState(this.series.isSetClockwise() ? (this.series.isClockwise() ? 1 : 2) : 0);
        this.btnDirection.addListener(13, (Listener)this);
    }

    private void updateInnerRadiusStates() {
        this.lblInnerRadiusPercent.setVisible(this.series.isInnerRadiusPercent());
    }

    private void createSeriesDetail(Composite cmpRight) {
        Group grpSlice = new Group(cmpRight, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        grpSlice.setLayoutData((Object)gd);
        grpSlice.setLayout((Layout)gridLayout);
        grpSlice.setText(Messages.getString("PieSeriesAttributeComposite.Grp.Slice"));
        Label lblExpSliWhen = new Label((Composite)grpSlice, 0);
        lblExpSliWhen.setText(Messages.getString("PieBottomAreaComponent.Label.ExplodeSliceWhen"));
        lblExpSliWhen.setToolTipText(TOOLTIP_EXPLODE_SLICE_WHEN);
        this.txtExplode = new TextEditorComposite((Composite)grpSlice, 2052);
        gd = new GridData(768);
        this.txtExplode.setLayoutData(gd);
        if (this.series.getExplosionExpression() != null) {
            this.txtExplode.setText(this.series.getExplosionExpression());
        }
        this.txtExplode.setToolTipText(Messages.getString("PieBaseSeriesComponent.Tooltip.EnterBooleanExpression"));
        this.txtExplode.addListener(this);
        this.btnBuilder = new Button((Composite)grpSlice, 8);
        GridData gdBTNBuilder = new GridData();
        gdBTNBuilder.heightHint = 20;
        gdBTNBuilder.widthHint = 20;
        this.btnBuilder.setLayoutData((Object)gdBTNBuilder);
        this.btnBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
        this.btnBuilder.addSelectionListener((SelectionListener)this);
        this.btnBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
        this.btnBuilder.getImage().setBackground(this.btnBuilder.getBackground());
        if (this.context.getUIServiceProvider() == null) {
            this.btnBuilder.setEnabled(false);
        }
        Label lblExpDistance = new Label((Composite)grpSlice, 0);
        lblExpDistance.setText(Messages.getString("PieBottomAreaComponent.Label.ByDistance"));
        lblExpDistance.setToolTipText(TOOLTIP_EXPLOSION_DISTANCE);
        this.iscExplosion = this.context.getUIFactory().createChartSpinner((Composite)grpSlice, 2048, (EObject)this.series, "explosion", true);
        GridData gdISCExplosion = new GridData(768);
        gdISCExplosion.horizontalSpan = 2;
        this.iscExplosion.setLayoutData((Object)gdISCExplosion);
        this.iscExplosion.getWidget().setMinimum(0);
        this.iscExplosion.getWidget().setMaximum(100);
        this.iscExplosion.getWidget().setSelection(this.series.getExplosion());
        Label lblSliceOutline = new Label((Composite)grpSlice, 0);
        GridData gdLBLSliceOutline = new GridData();
        lblSliceOutline.setLayoutData((Object)gdLBLSliceOutline);
        lblSliceOutline.setText(Messages.getString("PieSeriesAttributeComposite.Lbl.SliceOutline"));
        int fillStyles = 152;
        this.fccSliceOutline = new FillChooserComposite((Composite)grpSlice, 0, fillStyles |= this.context.getUIFactory().supportAutoUI() ? 4 : fillStyles, this.context, (Fill)this.series.getSliceOutline());
        GridData gdFCCSliceOutline = new GridData(768);
        gdFCCSliceOutline.horizontalSpan = 2;
        this.fccSliceOutline.setLayoutData(gdFCCSliceOutline);
        this.fccSliceOutline.addListener(this);
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.fccSliceOutline)) {
            this.series.setSliceOutline((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.liacLeaderLine)) {
            switch (event.type) {
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.series.getLeaderLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                    break;
                }
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.series.getLeaderLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.series.getLeaderLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.series.getLeaderLineAttributes().setColor((ColorDefinition)event.data);
                }
            }
        } else if (event.widget.equals((Object)this.txtExplode)) {
            this.series.setExplosionExpression(this.txtExplode.getText());
        } else if (event.widget == this.btnDirection) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"clockwise", (Object)(this.btnDirection.getSelectionState() == 1 ? 1 : 0), (this.btnDirection.getSelectionState() == 0 ? 1 : 0) != 0);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbLeaderLine)) {
            String selectedLineStyle = this.cmbLeaderLine.getSelectedItemData();
            if (selectedLineStyle != null) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"leaderLineStyle", (Object)LeaderLineStyle.getByName((String)selectedLineStyle), (boolean)false);
            }
        } else if (e.widget.equals(this.btnBuilder)) {
            try {
                String sExpr = this.context.getUIServiceProvider().invoke(2, this.txtExplode.getText(), this.context.getExtendedItem(), Messages.getString("PieBaseSeriesComponent.Text.SpecifyExplodeSlice"));
                this.txtExplode.setText(sExpr);
                this.txtExplode.setToolTipText(sExpr);
                this.series.setExplosionExpression(sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        } else if (e.widget.equals(this.sRatio)) {
            this.series.setRatio((double)this.sRatio.getSelection() / 10.0);
            if (this.series.isSetRatio()) {
                this.sRatio.setToolTipText(String.valueOf(this.series.getRatio()));
            } else {
                this.sRatio.setToolTipText(String.valueOf(this.defSeries.getRatio()));
            }
        } else if (e.widget.equals(this.sRotation)) {
            this.series.setRotation((double)this.sRotation.getSelection());
            if (this.series.isSetRotation()) {
                this.sRotation.setToolTipText(String.valueOf(this.series.getRotation()));
            } else {
                this.sRotation.setToolTipText(String.valueOf(this.defSeries.getRotation()));
            }
        } else if (e.widget == this.cmbInnerRadiusPercent) {
            String selectedRadius = this.cmbInnerRadiusPercent.getSelectedItemData();
            if (selectedRadius != null) {
                this.series.setInnerRadiusPercent(selectedRadius.equals(Messages.getString("PieBottomAreaComponent.Label.Percentage")));
            }
            this.updateInnerRadiusStates();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this.txtInnerRadius && !"Reset".equals(event.data)) {
            this.series.setInnerRadius(this.txtInnerRadius.getValue());
        }
    }
}

