/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedColumnDefPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetBasePage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWTException;

public class DefaultDataSetWizard
extends Wizard {
    private static final String CREATE_DATA_SET_TRANS_NAME = Messages.getString((String)"AbstractDataSetWizard.ModelTrans.Create");
    private transient boolean useTransaction = true;
    private DataSetBasePage dataSetPage;
    private AdvancedColumnDefPage columnDefPage;
    private DataSetHandle dataSetHandle;

    public DefaultDataSetWizard() {
        this(null, true);
    }

    public DefaultDataSetWizard(DataSourceHandle dataSourceHandle, boolean useTransaction) {
        this.useTransaction = useTransaction;
        this.dataSetPage = new DataSetBasePage(useTransaction);
        this.dataSetPage.setNewDataSource(dataSourceHandle);
        this.setForcePreviousAndNextButtons(true);
        this.addPage((IWizardPage)this.dataSetPage);
        this.columnDefPage = new AdvancedColumnDefPage();
        this.addPage((IWizardPage)this.columnDefPage);
    }

    public boolean performFinish() {
        block12: {
            if (!this.canFinish()) {
                return false;
            }
            if (this.useTransaction) {
                Utility.getCommandStack().startTrans(CREATE_DATA_SET_TRANS_NAME);
            }
            this.dataSetHandle = this.dataSetPage.createSelectedDataSet();
            if (this.dataSetHandle != null) {
                if (this.dataSetHandle instanceof ScriptDataSetHandle) {
                    this.columnDefPage.saveResult(this.dataSetHandle);
                }
                if (this.useTransaction) {
                    Utility.getCommandStack().commit();
                }
                try {
                    this.createSelectedDataSetTearDown(this.dataSetHandle);
                    DataSetUIUtil.updateColumnCache((DataSetHandle)this.dataSetHandle, (boolean)false);
                }
                catch (Exception e) {
                    Throwable cause;
                    if (e instanceof SWTException) {
                        SWTException swtException = (SWTException)e;
                        if (swtException.code == 24) {
                            Utility.log((Exception)e);
                        }
                    }
                    if ((cause = e.getCause()) != null && cause instanceof DataException) {
                        Logger logger = Logger.getLogger(DefaultDataSetWizard.class.getName());
                        logger.log(Level.WARNING, e.getLocalizedMessage(), e);
                        break block12;
                    }
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                if (this.useTransaction) {
                    Utility.getCommandStack().rollback();
                }
                return false;
            }
        }
        return true;
    }

    public DataSetHandle getNewCreateDataSetHandle() {
        return this.dataSetHandle;
    }

    private void createSelectedDataSetTearDown(DataSetHandle dataSetHandle) throws ContentException, NameException {
        ModuleHandle parentHandle = Utility.getReportModuleHandle();
        SlotHandle slotHandle = parentHandle.getDataSets();
        slotHandle.add((DesignElementHandle)dataSetHandle);
        if (dataSetHandle instanceof ScriptDataSetHandle) {
            Utility.setScriptActivityEditor();
        }
    }

    public boolean canFinish() {
        return this.dataSetPage.canFinish() && this.columnDefPage.isPageComplete();
    }
}

