/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibilityProvider
implements IExtendableElement {
    protected DesignElement element;
    protected ExtensionElementDefn cachedExtDefn = null;

    public ExtensibilityProvider(DesignElement element) {
        this.element = element;
    }

    public List<IElementPropertyDefn> getPropertyDefns() {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null && extDefn.getProperties() != null) {
            List<IElementPropertyDefn> props = extDefn.getProperties();
            List<UserPropertyDefn> userProps = this.element.getUserProperties();
            if (userProps != null) {
                props.addAll(userProps);
            }
            return props;
        }
        return Collections.emptyList();
    }

    public ElementPropertyDefn getPropertyDefn(String propName) {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null) {
            return (ElementPropertyDefn)extDefn.getProperty(propName);
        }
        return null;
    }

    public IPropertyDefn getExtensionPropertyDefn(String propName) {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null && extDefn.getLocalProperties() != null) {
            return extDefn.getProperty(propName);
        }
        return null;
    }

    public abstract void checkExtends(DesignElement var1) throws ExtendsException;

    public boolean hasLocalPropertyValues() {
        return false;
    }
}

