/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;

public class TotalCount
extends AggrFunction {
    public String getName() {
        return "COUNT";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 2;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, true, true, SupportedDataTypes.ANY, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalCount.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalCount.displayName");
    }

    public Object getDefaultValue() {
        return 0;
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private int count = 0;
        boolean countByColumn = true;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.count = 0;
        }

        public void onRow(Object[] args) {
            if (!this.countByColumn || args == null || args.length == 0) {
                if (this.countByColumn) {
                    this.countByColumn = false;
                }
                ++this.count;
            } else if (args.length > 0 && args[0] != null) {
                ++this.count;
            }
        }

        public Object getSummaryValue() {
            return this.count;
        }
    }
}

