/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include "timidity.h"
#include "common.h"
#include "strtab.h"
#include "instrum.h"
#include "playmidi.h"
#include "readmidi.h"
#include "wrd.h"
#include "arc.h"
#include "interface.h"

#include "wrd_prv.h"

/*
 * Remap WRD @COLOR(16)-@COLOR(23) to RGB plain number.
 * Usage: rgb = wrd_color_remap[color-16];
 *
 * R G B
 * 1 2 4
 *
int wrd_color_remap[8] =
{
    0, * 16 secret?, I don't know this code meaning. *
    1, * 17 red *
    4, * 18 blue *
    5, * 19 magenta *
    2, * 20 green *
    3, * 21 yellow *
    6, * 22 cyan *
    7  * 23 white *
};

/* Map RGB plane from MIMPI plane.
 *
 * {0,1,2,3,4,5,6,7} -- No conversion
 * {0,4,1,5,2,6,3,7} -- BRG to RGB
 * {0,1,4,5,2,3,6,7} -- GRB to RGB
 *
int wrd_plane_remap[8] = {0,1,2,3,4,5,6,7};
*/

/*ARGSUSED*/
static int null_wrdt_open(tmdy_struct_ex_t *tmdy_struct, char *wrdt_opts) { return 0; }
/*ARGSUSED*/
static void null_wrdt_apply(tmdy_struct_ex_t *tmdy_struct, int cmd, int argc, int args[]) { }
static void null_wrdt_update_events(tmdy_struct_ex_t *tmdy_struct) { }
static void null_wrdt_end(tmdy_struct_ex_t *tmdy_struct) { }
static void null_wrdt_close(tmdy_struct_ex_t *tmdy_struct) { }

WRDTracer null_wrdt_mode =
{
    "No WRD trace", '-',
    0,
    null_wrdt_open,
    null_wrdt_apply,
    NULL,
    null_wrdt_update_events,
    NULL,
    null_wrdt_end,
    null_wrdt_close
};
/*
static StringTable path_list;
static StringTable default_path_list;
*/
static int wrd_add_path_one(tmdy_struct_ex_t *tmdy_struct, char *path, int pathlen);

void wrd_init_path(tmdy_struct_ex_t *tmdy_struct)
{
    StringTableNode *p;
    
    TMDY_UTILS->strtab->delete_string_table(tmdy_struct, &TMDY_WRD->path_list);
    for(p = TMDY_WRD->default_path_list.head; p; p = p->next)
	wrd_add_path_one(tmdy_struct, p->string, strlen(p->string));

    if(TMDY_READMIDI->current_file_info)
    {
	if(strchr(TMDY_READMIDI->current_file_info->filename, '#') != NULL)
	    wrd_add_path_one(tmdy_struct, TMDY_READMIDI->current_file_info->filename,
			     strchr(TMDY_READMIDI->current_file_info->filename, '#') -
			     TMDY_READMIDI->current_file_info->filename + 1);
	if(TMDY_COMMON->pathsep_strrchr(tmdy_struct, TMDY_READMIDI->current_file_info->filename) != NULL)
	    wrd_add_path_one(tmdy_struct, TMDY_READMIDI->current_file_info->filename,
			     TMDY_COMMON->pathsep_strrchr(tmdy_struct, TMDY_READMIDI->current_file_info->filename) -
			     TMDY_READMIDI->current_file_info->filename + 1);
    }
}

static int wrd_add_path_one(tmdy_struct_ex_t *tmdy_struct, char *path, int pathlen)
{
    int exists;
    StringTableNode *p;

    exists = 0;
    for(p = TMDY_WRD->path_list.head; p; p = p->next)
	if(strncmp(p->string, path, pathlen) == 0 &&
	   p->string[pathlen] == '\0')
	{
	    exists = 1;
	    break;
	}
    if(exists){
		return 0;
	}
    TMDY_UTILS->strtab->put_string_table(tmdy_struct, &TMDY_WRD->path_list, path, pathlen);
    return 1;
}

void wrd_add_path(tmdy_struct_ex_t *tmdy_struct, char *path, int pathlen)
{
    if(pathlen == 0)
	pathlen = strlen(path);
    if(!wrd_add_path_one(tmdy_struct, path, pathlen)){
		return;
	}

    if(TMDY_READMIDI->current_file_info &&
       TMDY_ARC->arc->get_archive_type(tmdy_struct, TMDY_READMIDI->current_file_info->filename) != -1)
    {
	MBlockList buf;
	char *arc_path;
	int baselen;

	TMDY_UTILS->mblock->init_mblock(tmdy_struct, &buf);
	baselen = strrchr(TMDY_READMIDI->current_file_info->filename, '#') -
	    TMDY_READMIDI->current_file_info->filename + 1;
	arc_path = TMDY_UTILS->mblock->new_segment(tmdy_struct, &buf, baselen + pathlen + 1);
	strncpy(arc_path, TMDY_READMIDI->current_file_info->filename, baselen);
	strncpy(arc_path + baselen, path, pathlen);
	arc_path[baselen + pathlen] = '\0';
	TMDY_UTILS->strtab->put_string_table(tmdy_struct, &TMDY_WRD->path_list, arc_path, strlen(arc_path));
	TMDY_UTILS->mblock->reuse_mblock(tmdy_struct, &buf);
    }
}

void wrd_add_default_path(tmdy_struct_ex_t *tmdy_struct, char *path)
{
    TMDY_UTILS->strtab->put_string_table(tmdy_struct, &TMDY_WRD->default_path_list, path, strlen(path));
}

static struct timidity_file *try_wrd_open_file(tmdy_struct_ex_t *tmdy_struct, char *prefix, char *fn)
{
    MBlockList buf;
    char *path;
    int len1, len2;
    struct timidity_file *tf;

    TMDY_UTILS->mblock->init_mblock(tmdy_struct, &buf);
    len1 = strlen(prefix);
    len2 = strlen(fn);
    path = (char *)TMDY_UTILS->mblock->new_segment(tmdy_struct, &buf, len1 + len2 + 2);
    strcpy(path, prefix);
    if( len1>0 && path[len1 - 1] != '#' && !IS_PATH_SEP(path[len1 - 1]))
    {
	path[len1++] = PATH_SEP;
	path[len1] = '\0';
    }
    strcat(path, fn);
    tf = TMDY_COMMON->open_file(tmdy_struct, path, 0, OF_SILENT);
    TMDY_UTILS->mblock->reuse_mblock(tmdy_struct, &buf);
    return tf;
}

#define CUR_DIR_PATH ""

struct timidity_file *wrd_open_file(tmdy_struct_ex_t *tmdy_struct, char *filename)
{
    StringTableNode *path;
    struct timidity_file *tf;

    if(TMDY_ARC->arc->get_archive_type(tmdy_struct, filename) != -1){
		return TMDY_COMMON->open_file(tmdy_struct, filename, 0, OF_SILENT);
	}

    for(path = TMDY_WRD->path_list.head; path; path = path->next){
	if((tf = try_wrd_open_file(tmdy_struct, path->string, filename)) != NULL){
	    return tf;
	}
    }
    return try_wrd_open_file(tmdy_struct, CUR_DIR_PATH, filename);
}

void wrd_midi_event(tmdy_struct_ex_t *tmdy_struct, int cmd, int arg)
{
/*
    static int wrd_argc = 0;
    static int wrd_args[WRD_MAXPARAM];
*/
	
    if(!TMDY_WRD->wrdt->opened){ /* Ignore any WRD command if WRD is closed */
		return;
	}

    if(cmd == -1)
    {
	TMDY_WRD->wrd_argc = 0;
	return;
    }

    TMDY_WRD->wrd_args[TMDY_WRD->wrd_argc++] = arg;
    if(cmd != WRD_ARG)
    {
	timidity_mutex_unlock(TMDY_WRD->busy);
	TMDY_WRD->wrdt->apply(tmdy_struct, cmd, TMDY_WRD->wrd_argc, TMDY_WRD->wrd_args);
	timidity_mutex_lock(TMDY_WRD->busy);
	TMDY_WRD->wrd_argc = 0;
    }
}

void wrd_sherry_event(tmdy_struct_ex_t *tmdy_struct, int addr)
{
    if(!TMDY_WRD->wrdt->opened || TMDY_WRD->wrdt->sherry == NULL){
		return;
	}
    timidity_mutex_unlock(TMDY_WRD->busy);
    TMDY_WRD->wrdt->sherry(tmdy_struct, TMDY_WRD->datapacket[addr].data, TMDY_WRD->datapacket[addr].len);
    timidity_mutex_lock(TMDY_WRD->busy);
}
